/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.util;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColorUtil {
    public static String adjustHsl(String color, double h, double s, double l) throws IllegalArgumentException {
        HslaColor origin = HslaColor.of(color);
        HslaColor target = HslaColor.of(origin.hue() + h, origin.saturation() + s, origin.luminance() + l, origin.alpha());
        return target.toRgba().toString();
    }

    private static class NamedColors {
        public static final Color TRANSPARENT = RgbaColor.of(0.0, 0.0, 0.0, 0.0);
        public static final Color ALICEBLUE = RgbaColor.of(0.9411764740943909, 0.972549f, 1.0);
        public static final Color ANTIQUEWHITE = RgbaColor.of(0.9803921580314636, 0.9215686321258545, 0.843137264251709);
        public static final Color AQUA = RgbaColor.of(0.0, 1.0, 1.0);
        public static final Color AQUAMARINE = RgbaColor.of(0.49803921580314636, 1.0, 0.8313725590705872);
        public static final Color AZURE = RgbaColor.of(0.9411764740943909, 1.0, 1.0);
        public static final Color BEIGE = RgbaColor.of(0.9607843160629272, 0.9607843160629272, 0.8627451062202454);
        public static final Color BISQUE = RgbaColor.of(1.0, 0.8941176533699036, 0.7686274647712708);
        public static final Color BLACK = RgbaColor.of(0.0, 0.0, 0.0);
        public static final Color BLANCHEDALMOND = RgbaColor.of(1.0, 0.9215686321258545, 0.8039215803146362);
        public static final Color BLUE = RgbaColor.of(0.0, 0.0, 1.0);
        public static final Color BLUEVIOLET = RgbaColor.of(0.5411764979362488, 0.16862745583057404, 0.886274516582489);
        public static final Color BROWN = RgbaColor.of(0.6470588445663452, 0.16470588743686676, 0.16470588743686676);
        public static final Color BURLYWOOD = RgbaColor.of(0.8705882430076599, 0.7215686440467834, 0.529411792755127);
        public static final Color CADETBLUE = RgbaColor.of(0.37254902720451355, 0.6196078658103943, 0.627451f);
        public static final Color CHARTREUSE = RgbaColor.of(0.49803921580314636, 1.0, 0.0);
        public static final Color CHOCOLATE = RgbaColor.of(0.8235294222831726, 0.4117647111415863, 0.11764705926179886);
        public static final Color CORAL = RgbaColor.of(1.0, 0.49803921580314636, 0.3137255012989044);
        public static final Color CORNFLOWERBLUE = RgbaColor.of(0.3921568691730499, 0.5843137502670288, 0.929411768913269);
        public static final Color CORNSILK = RgbaColor.of(1.0, 0.972549f, 0.8627451062202454);
        public static final Color CRIMSON = RgbaColor.of(0.8627451062202454, 0.0784313753247261, 0.23529411852359772);
        public static final Color CYAN = RgbaColor.of(0.0, 1.0, 1.0);
        public static final Color DARKBLUE = RgbaColor.of(0.0, 0.0, 0.545098066329956);
        public static final Color DARKCYAN = RgbaColor.of(0.0, 0.545098066329956, 0.545098066329956);
        public static final Color DARKGOLDENROD = RgbaColor.of(0.7215686440467834, 0.5254902243614197, 0.04313725605607033);
        public static final Color DARKGRAY = RgbaColor.of(0.6627451181411743, 0.6627451181411743, 0.6627451181411743);
        public static final Color DARKGREEN = RgbaColor.of(0.0, 0.3921568691730499, 0.0);
        public static final Color DARKGREY = DARKGRAY;
        public static final Color DARKKHAKI = RgbaColor.of(0.7411764860153198, 0.7176470756530762, 0.41960784792900085);
        public static final Color DARKMAGENTA = RgbaColor.of(0.545098066329956, 0.0, 0.545098066329956);
        public static final Color DARKOLIVEGREEN = RgbaColor.of(0.3333333432674408, 0.41960784792900085, 0.18431372940540314);
        public static final Color DARKORANGE = RgbaColor.of(1.0, 0.5490196347236633, 0.0);
        public static final Color DARKORCHID = RgbaColor.of(0.6f, 0.19607843458652496, 0.8f);
        public static final Color DARKRED = RgbaColor.of(0.545098066329956, 0.0, 0.0);
        public static final Color DARKSALMON = RgbaColor.of(0.9137254953384399, 0.5882353186607361, 0.47843137383461);
        public static final Color DARKSEAGREEN = RgbaColor.of(0.5607843399047852, 0.7372549176216125, 0.5607843399047852);
        public static final Color DARKSLATEBLUE = RgbaColor.of(0.2823529541492462, 0.239215686917305, 0.545098066329956);
        public static final Color DARKSLATEGRAY;
        public static final Color DARKSLATEGREY;
        public static final Color DARKTURQUOISE;
        public static final Color DARKVIOLET;
        public static final Color DEEPPINK;
        public static final Color DEEPSKYBLUE;
        public static final Color DIMGRAY;
        public static final Color DIMGREY;
        public static final Color DODGERBLUE;
        public static final Color FIREBRICK;
        public static final Color FLORALWHITE;
        public static final Color FORESTGREEN;
        public static final Color FUCHSIA;
        public static final Color GAINSBORO;
        public static final Color GHOSTWHITE;
        public static final Color GOLD;
        public static final Color GOLDENROD;
        public static final Color GRAY;
        public static final Color GREEN;
        public static final Color GREENYELLOW;
        public static final Color GREY;
        public static final Color HONEYDEW;
        public static final Color HOTPINK;
        public static final Color INDIANRED;
        public static final Color INDIGO;
        public static final Color IVORY;
        public static final Color KHAKI;
        public static final Color LAVENDER;
        public static final Color LAVENDERBLUSH;
        public static final Color LAWNGREEN;
        public static final Color LEMONCHIFFON;
        public static final Color LIGHTBLUE;
        public static final Color LIGHTCORAL;
        public static final Color LIGHTCYAN;
        public static final Color LIGHTGOLDENRODYELLOW;
        public static final Color LIGHTGRAY;
        public static final Color LIGHTGREEN;
        public static final Color LIGHTGREY;
        public static final Color LIGHTPINK;
        public static final Color LIGHTSALMON;
        public static final Color LIGHTSEAGREEN;
        public static final Color LIGHTSKYBLUE;
        public static final Color LIGHTSLATEGRAY;
        public static final Color LIGHTSLATEGREY;
        public static final Color LIGHTSTEELBLUE;
        public static final Color LIGHTYELLOW;
        public static final Color LIME;
        public static final Color LIMEGREEN;
        public static final Color LINEN;
        public static final Color MAGENTA;
        public static final Color MAROON;
        public static final Color MEDIUMAQUAMARINE;
        public static final Color MEDIUMBLUE;
        public static final Color MEDIUMORCHID;
        public static final Color MEDIUMPURPLE;
        public static final Color MEDIUMSEAGREEN;
        public static final Color MEDIUMSLATEBLUE;
        public static final Color MEDIUMSPRINGGREEN;
        public static final Color MEDIUMTURQUOISE;
        public static final Color MEDIUMVIOLETRED;
        public static final Color MIDNIGHTBLUE;
        public static final Color MINTCREAM;
        public static final Color MISTYROSE;
        public static final Color MOCCASIN;
        public static final Color NAVAJOWHITE;
        public static final Color NAVY;
        public static final Color OLDLACE;
        public static final Color OLIVE;
        public static final Color OLIVEDRAB;
        public static final Color ORANGE;
        public static final Color ORANGERED;
        public static final Color ORCHID;
        public static final Color PALEGOLDENROD;
        public static final Color PALEGREEN;
        public static final Color PALETURQUOISE;
        public static final Color PALEVIOLETRED;
        public static final Color PAPAYAWHIP;
        public static final Color PEACHPUFF;
        public static final Color PERU;
        public static final Color PINK;
        public static final Color PLUM;
        public static final Color POWDERBLUE;
        public static final Color PURPLE;
        public static final Color RED;
        public static final Color ROSYBROWN;
        public static final Color ROYALBLUE;
        public static final Color SADDLEBROWN;
        public static final Color SALMON;
        public static final Color SANDYBROWN;
        public static final Color SEAGREEN;
        public static final Color SEASHELL;
        public static final Color SIENNA;
        public static final Color SILVER;
        public static final Color SKYBLUE;
        public static final Color SLATEBLUE;
        public static final Color SLATEGRAY;
        public static final Color SLATEGREY;
        public static final Color SNOW;
        public static final Color SPRINGGREEN;
        public static final Color STEELBLUE;
        public static final Color TAN;
        public static final Color TEAL;
        public static final Color THISTLE;
        public static final Color TOMATO;
        public static final Color TURQUOISE;
        public static final Color VIOLET;
        public static final Color WHEAT;
        public static final Color WHITE;
        public static final Color WHITESMOKE;
        public static final Color YELLOW;
        public static final Color YELLOWGREEN;
        public static final Map<String, Color> COLORS;

        private NamedColors() {
        }

        public static Color forName(String name) {
            if (name == null) {
                return null;
            }
            name = name.toLowerCase(Locale.US);
            return COLORS.get(name);
        }

        static {
            DARKSLATEGREY = DARKSLATEGRAY = RgbaColor.of(0.18431372940540314, 0.30980393290519714, 0.30980393290519714);
            DARKTURQUOISE = RgbaColor.of(0.0, 0.8078431487083435, 0.8196078538894653);
            DARKVIOLET = RgbaColor.of(0.5803921818733215, 0.0, 0.827451f);
            DEEPPINK = RgbaColor.of(1.0, 0.0784313753247261, 0.5764706134796143);
            DEEPSKYBLUE = RgbaColor.of(0.0, 0.7490196228027344, 1.0);
            DIMGREY = DIMGRAY = RgbaColor.of(0.4117647111415863, 0.4117647111415863, 0.4117647111415863);
            DODGERBLUE = RgbaColor.of(0.11764705926179886, 0.5647059082984924, 1.0);
            FIREBRICK = RgbaColor.of(0.6980392336845398, 0.13333334028720856, 0.13333334028720856);
            FLORALWHITE = RgbaColor.of(1.0, 0.9803921580314636, 0.9411764740943909);
            FORESTGREEN = RgbaColor.of(0.13333334028720856, 0.545098066329956, 0.13333334028720856);
            FUCHSIA = RgbaColor.of(1.0, 0.0, 1.0);
            GAINSBORO = RgbaColor.of(0.8627451062202454, 0.8627451062202454, 0.8627451062202454);
            GHOSTWHITE = RgbaColor.of(0.972549f, 0.972549f, 1.0);
            GOLD = RgbaColor.of(1.0, 0.843137264251709, 0.0);
            GOLDENROD = RgbaColor.of(0.8549019694328308, 0.6470588445663452, 0.125490203499794);
            GRAY = RgbaColor.of(0.501960813999176, 0.501960813999176, 0.501960813999176);
            GREEN = RgbaColor.of(0.0, 0.501960813999176, 0.0);
            GREENYELLOW = RgbaColor.of(0.6784313917160034, 1.0, 0.18431372940540314);
            GREY = GRAY;
            HONEYDEW = RgbaColor.of(0.9411764740943909, 1.0, 0.9411764740943909);
            HOTPINK = RgbaColor.of(1.0, 0.4117647111415863, 0.7058823704719543);
            INDIANRED = RgbaColor.of(0.8039215803146362, 0.3607843220233917, 0.3607843220233917);
            INDIGO = RgbaColor.of(0.29411765933036804, 0.0, 0.5098039507865906);
            IVORY = RgbaColor.of(1.0, 1.0, 0.9411764740943909);
            KHAKI = RgbaColor.of(0.9411764740943909, 0.9019607901573181, 0.5490196347236633);
            LAVENDER = RgbaColor.of(0.9019607901573181, 0.9019607901573181, 0.9803921580314636);
            LAVENDERBLUSH = RgbaColor.of(1.0, 0.9411764740943909, 0.9607843160629272);
            LAWNGREEN = RgbaColor.of(0.4862745f, 0.9882352948188782, 0.0);
            LEMONCHIFFON = RgbaColor.of(1.0, 0.9803921580314636, 0.8039215803146362);
            LIGHTBLUE = RgbaColor.of(0.6784313917160034, 0.8470588326454163, 0.9019607901573181);
            LIGHTCORAL = RgbaColor.of(0.9411764740943909, 0.501960813999176, 0.501960813999176);
            LIGHTCYAN = RgbaColor.of(0.8784313797950745, 1.0, 1.0);
            LIGHTGOLDENRODYELLOW = RgbaColor.of(0.9803921580314636, 0.9803921580314636, 0.8235294222831726);
            LIGHTGRAY = RgbaColor.of(0.827451f, 0.827451f, 0.827451f);
            LIGHTGREEN = RgbaColor.of(0.5647059082984924, 0.9333333373069763, 0.5647059082984924);
            LIGHTGREY = LIGHTGRAY;
            LIGHTPINK = RgbaColor.of(1.0, 0.7137255072593689, 0.7568627595901489);
            LIGHTSALMON = RgbaColor.of(1.0, 0.627451f, 0.47843137383461);
            LIGHTSEAGREEN = RgbaColor.of(0.125490203499794, 0.6980392336845398, 0.6666666865348816);
            LIGHTSKYBLUE = RgbaColor.of(0.529411792755127, 0.8078431487083435, 0.9803921580314636);
            LIGHTSLATEGREY = LIGHTSLATEGRAY = RgbaColor.of(0.46666666865348816, 0.5333333611488342, 0.6f);
            LIGHTSTEELBLUE = RgbaColor.of(0.6901960968971252, 0.7686274647712708, 0.8705882430076599);
            LIGHTYELLOW = RgbaColor.of(1.0, 1.0, 0.8784313797950745);
            LIME = RgbaColor.of(0.0, 1.0, 0.0);
            LIMEGREEN = RgbaColor.of(0.19607843458652496, 0.8039215803146362, 0.19607843458652496);
            LINEN = RgbaColor.of(0.9803921580314636, 0.9411764740943909, 0.9019607901573181);
            MAGENTA = RgbaColor.of(1.0, 0.0, 1.0);
            MAROON = RgbaColor.of(0.501960813999176, 0.0, 0.0);
            MEDIUMAQUAMARINE = RgbaColor.of(0.4f, 0.8039215803146362, 0.6666666865348816);
            MEDIUMBLUE = RgbaColor.of(0.0, 0.0, 0.8039215803146362);
            MEDIUMORCHID = RgbaColor.of(0.729411780834198, 0.3333333432674408, 0.827451f);
            MEDIUMPURPLE = RgbaColor.of(0.5764706134796143, 0.4392157f, 0.8588235378265381);
            MEDIUMSEAGREEN = RgbaColor.of(0.23529411852359772, 0.7019608020782471, 0.4431372582912445);
            MEDIUMSLATEBLUE = RgbaColor.of(0.48235294222831726, 0.40784314274787903, 0.9333333373069763);
            MEDIUMSPRINGGREEN = RgbaColor.of(0.0, 0.9803921580314636, 0.6039215922355652);
            MEDIUMTURQUOISE = RgbaColor.of(0.2823529541492462, 0.8196078538894653, 0.8f);
            MEDIUMVIOLETRED = RgbaColor.of(0.7803921699523926, 0.08235294371843338, 0.5215686559677124);
            MIDNIGHTBLUE = RgbaColor.of(0.09803921729326248, 0.09803921729326248, 0.4392157f);
            MINTCREAM = RgbaColor.of(0.9607843160629272, 1.0, 0.9803921580314636);
            MISTYROSE = RgbaColor.of(1.0, 0.8941176533699036, 0.8823529481887817);
            MOCCASIN = RgbaColor.of(1.0, 0.8941176533699036, 0.7098039388656616);
            NAVAJOWHITE = RgbaColor.of(1.0, 0.8705882430076599, 0.6784313917160034);
            NAVY = RgbaColor.of(0.0, 0.0, 0.501960813999176);
            OLDLACE = RgbaColor.of(0.9921568632125854, 0.9607843160629272, 0.9019607901573181);
            OLIVE = RgbaColor.of(0.501960813999176, 0.501960813999176, 0.0);
            OLIVEDRAB = RgbaColor.of(0.41960784792900085, 0.5568627715110779, 0.13725490868091583);
            ORANGE = RgbaColor.of(1.0, 0.6470588445663452, 0.0);
            ORANGERED = RgbaColor.of(1.0, 0.2705882489681244, 0.0);
            ORCHID = RgbaColor.of(0.8549019694328308, 0.4392157f, 0.8392156958580017);
            PALEGOLDENROD = RgbaColor.of(0.9333333373069763, 0.9098039269447327, 0.6666666865348816);
            PALEGREEN = RgbaColor.of(0.5960784554481506, 0.9843137264251709, 0.5960784554481506);
            PALETURQUOISE = RgbaColor.of(0.686274528503418, 0.9333333373069763, 0.9333333373069763);
            PALEVIOLETRED = RgbaColor.of(0.8588235378265381, 0.4392157f, 0.5764706134796143);
            PAPAYAWHIP = RgbaColor.of(1.0, 0.9372549057006836, 0.8352941274642944);
            PEACHPUFF = RgbaColor.of(1.0, 0.8549019694328308, 0.7254902124404907);
            PERU = RgbaColor.of(0.8039215803146362, 0.5215686559677124, 0.24705882370471954);
            PINK = RgbaColor.of(1.0, 0.7529411911964417, 0.7960784435272217);
            PLUM = RgbaColor.of(0.8666666746139526, 0.627451f, 0.8666666746139526);
            POWDERBLUE = RgbaColor.of(0.6901960968971252, 0.8784313797950745, 0.9019607901573181);
            PURPLE = RgbaColor.of(0.501960813999176, 0.0, 0.501960813999176);
            RED = RgbaColor.of(1.0, 0.0, 0.0);
            ROSYBROWN = RgbaColor.of(0.7372549176216125, 0.5607843399047852, 0.5607843399047852);
            ROYALBLUE = RgbaColor.of(0.2549019753932953, 0.4117647111415863, 0.8823529481887817);
            SADDLEBROWN = RgbaColor.of(0.545098066329956, 0.2705882489681244, 0.07450980693101883);
            SALMON = RgbaColor.of(0.9803921580314636, 0.501960813999176, 0.4470588266849518);
            SANDYBROWN = RgbaColor.of(0.95686274766922, 0.6431372761726379, 0.3764705955982208);
            SEAGREEN = RgbaColor.of(0.18039216101169586, 0.545098066329956, 0.34117648005485535);
            SEASHELL = RgbaColor.of(1.0, 0.9607843160629272, 0.9333333373069763);
            SIENNA = RgbaColor.of(0.627451f, 0.32156863808631897, 0.1764705926179886);
            SILVER = RgbaColor.of(0.7529411911964417, 0.7529411911964417, 0.7529411911964417);
            SKYBLUE = RgbaColor.of(0.529411792755127, 0.8078431487083435, 0.9215686321258545);
            SLATEBLUE = RgbaColor.of(0.4156862795352936, 0.3529411852359772, 0.8039215803146362);
            SLATEGREY = SLATEGRAY = RgbaColor.of(0.4392157f, 0.501960813999176, 0.5647059082984924);
            SNOW = RgbaColor.of(1.0, 0.9803921580314636, 0.9803921580314636);
            SPRINGGREEN = RgbaColor.of(0.0, 1.0, 0.49803921580314636);
            STEELBLUE = RgbaColor.of(0.27450981736183167, 0.5098039507865906, 0.7058823704719543);
            TAN = RgbaColor.of(0.8235294222831726, 0.7058823704719543, 0.5490196347236633);
            TEAL = RgbaColor.of(0.0, 0.501960813999176, 0.501960813999176);
            THISTLE = RgbaColor.of(0.8470588326454163, 0.7490196228027344, 0.8470588326454163);
            TOMATO = RgbaColor.of(1.0, 0.3882353f, 0.2784314f);
            TURQUOISE = RgbaColor.of(0.250980406999588, 0.8784313797950745, 0.8156862854957581);
            VIOLET = RgbaColor.of(0.9333333373069763, 0.5098039507865906, 0.9333333373069763);
            WHEAT = RgbaColor.of(0.9607843160629272, 0.8705882430076599, 0.7019608020782471);
            WHITE = RgbaColor.of(1.0, 1.0, 1.0);
            WHITESMOKE = RgbaColor.of(0.9607843160629272, 0.9607843160629272, 0.9607843160629272);
            YELLOW = RgbaColor.of(1.0, 1.0, 0.0);
            YELLOWGREEN = RgbaColor.of(0.6039215922355652, 0.8039215803146362, 0.19607843458652496);
            TreeMap<String, Color> colors = new TreeMap<String, Color>();
            colors.put("aliceblue", ALICEBLUE);
            colors.put("antiquewhite", ANTIQUEWHITE);
            colors.put("aqua", AQUA);
            colors.put("aquamarine", AQUAMARINE);
            colors.put("azure", AZURE);
            colors.put("beige", BEIGE);
            colors.put("bisque", BISQUE);
            colors.put("black", BLACK);
            colors.put("blanchedalmond", BLANCHEDALMOND);
            colors.put("blue", BLUE);
            colors.put("blueviolet", BLUEVIOLET);
            colors.put("brown", BROWN);
            colors.put("burlywood", BURLYWOOD);
            colors.put("cadetblue", CADETBLUE);
            colors.put("chartreuse", CHARTREUSE);
            colors.put("chocolate", CHOCOLATE);
            colors.put("coral", CORAL);
            colors.put("cornflowerblue", CORNFLOWERBLUE);
            colors.put("cornsilk", CORNSILK);
            colors.put("crimson", CRIMSON);
            colors.put("cyan", CYAN);
            colors.put("darkblue", DARKBLUE);
            colors.put("darkcyan", DARKCYAN);
            colors.put("darkgoldenrod", DARKGOLDENROD);
            colors.put("darkgray", DARKGRAY);
            colors.put("darkgreen", DARKGREEN);
            colors.put("darkgrey", DARKGREY);
            colors.put("darkkhaki", DARKKHAKI);
            colors.put("darkmagenta", DARKMAGENTA);
            colors.put("darkolivegreen", DARKOLIVEGREEN);
            colors.put("darkorange", DARKORANGE);
            colors.put("darkorchid", DARKORCHID);
            colors.put("darkred", DARKRED);
            colors.put("darksalmon", DARKSALMON);
            colors.put("darkseagreen", DARKSEAGREEN);
            colors.put("darkslateblue", DARKSLATEBLUE);
            colors.put("darkslategray", DARKSLATEGRAY);
            colors.put("darkslategrey", DARKSLATEGREY);
            colors.put("darkturquoise", DARKTURQUOISE);
            colors.put("darkviolet", DARKVIOLET);
            colors.put("deeppink", DEEPPINK);
            colors.put("deepskyblue", DEEPSKYBLUE);
            colors.put("dimgray", DIMGRAY);
            colors.put("dimgrey", DIMGREY);
            colors.put("dodgerblue", DODGERBLUE);
            colors.put("firebrick", FIREBRICK);
            colors.put("floralwhite", FLORALWHITE);
            colors.put("forestgreen", FORESTGREEN);
            colors.put("fuchsia", FUCHSIA);
            colors.put("gainsboro", GAINSBORO);
            colors.put("ghostwhite", GHOSTWHITE);
            colors.put("gold", GOLD);
            colors.put("goldenrod", GOLDENROD);
            colors.put("gray", GRAY);
            colors.put("green", GREEN);
            colors.put("greenyellow", GREENYELLOW);
            colors.put("grey", GREY);
            colors.put("honeydew", HONEYDEW);
            colors.put("hotpink", HOTPINK);
            colors.put("indianred", INDIANRED);
            colors.put("indigo", INDIGO);
            colors.put("ivory", IVORY);
            colors.put("khaki", KHAKI);
            colors.put("lavender", LAVENDER);
            colors.put("lavenderblush", LAVENDERBLUSH);
            colors.put("lawngreen", LAWNGREEN);
            colors.put("lemonchiffon", LEMONCHIFFON);
            colors.put("lightblue", LIGHTBLUE);
            colors.put("lightcoral", LIGHTCORAL);
            colors.put("lightcyan", LIGHTCYAN);
            colors.put("lightgoldenrodyellow", LIGHTGOLDENRODYELLOW);
            colors.put("lightgray", LIGHTGRAY);
            colors.put("lightgreen", LIGHTGREEN);
            colors.put("lightgrey", LIGHTGREY);
            colors.put("lightpink", LIGHTPINK);
            colors.put("lightsalmon", LIGHTSALMON);
            colors.put("lightseagreen", LIGHTSEAGREEN);
            colors.put("lightskyblue", LIGHTSKYBLUE);
            colors.put("lightslategray", LIGHTSLATEGRAY);
            colors.put("lightslategrey", LIGHTSLATEGREY);
            colors.put("lightsteelblue", LIGHTSTEELBLUE);
            colors.put("lightyellow", LIGHTYELLOW);
            colors.put("lime", LIME);
            colors.put("limegreen", LIMEGREEN);
            colors.put("linen", LINEN);
            colors.put("magenta", MAGENTA);
            colors.put("maroon", MAROON);
            colors.put("mediumaquamarine", MEDIUMAQUAMARINE);
            colors.put("mediumblue", MEDIUMBLUE);
            colors.put("mediumorchid", MEDIUMORCHID);
            colors.put("mediumpurple", MEDIUMPURPLE);
            colors.put("mediumseagreen", MEDIUMSEAGREEN);
            colors.put("mediumslateblue", MEDIUMSLATEBLUE);
            colors.put("mediumspringgreen", MEDIUMSPRINGGREEN);
            colors.put("mediumturquoise", MEDIUMTURQUOISE);
            colors.put("mediumvioletred", MEDIUMVIOLETRED);
            colors.put("midnightblue", MIDNIGHTBLUE);
            colors.put("mintcream", MINTCREAM);
            colors.put("mistyrose", MISTYROSE);
            colors.put("moccasin", MOCCASIN);
            colors.put("navajowhite", NAVAJOWHITE);
            colors.put("navy", NAVY);
            colors.put("oldlace", OLDLACE);
            colors.put("olive", OLIVE);
            colors.put("olivedrab", OLIVEDRAB);
            colors.put("orange", ORANGE);
            colors.put("orangered", ORANGERED);
            colors.put("orchid", ORCHID);
            colors.put("palegoldenrod", PALEGOLDENROD);
            colors.put("palegreen", PALEGREEN);
            colors.put("paleturquoise", PALETURQUOISE);
            colors.put("palevioletred", PALEVIOLETRED);
            colors.put("papayawhip", PAPAYAWHIP);
            colors.put("peachpuff", PEACHPUFF);
            colors.put("peru", PERU);
            colors.put("pink", PINK);
            colors.put("plum", PLUM);
            colors.put("powderblue", POWDERBLUE);
            colors.put("purple", PURPLE);
            colors.put("red", RED);
            colors.put("rosybrown", ROSYBROWN);
            colors.put("royalblue", ROYALBLUE);
            colors.put("saddlebrown", SADDLEBROWN);
            colors.put("salmon", SALMON);
            colors.put("sandybrown", SANDYBROWN);
            colors.put("seagreen", SEAGREEN);
            colors.put("seashell", SEASHELL);
            colors.put("sienna", SIENNA);
            colors.put("silver", SILVER);
            colors.put("skyblue", SKYBLUE);
            colors.put("slateblue", SLATEBLUE);
            colors.put("slategray", SLATEGRAY);
            colors.put("slategrey", SLATEGREY);
            colors.put("snow", SNOW);
            colors.put("springgreen", SPRINGGREEN);
            colors.put("steelblue", STEELBLUE);
            colors.put("tan", TAN);
            colors.put("teal", TEAL);
            colors.put("thistle", THISTLE);
            colors.put("tomato", TOMATO);
            colors.put("transparent", TRANSPARENT);
            colors.put("turquoise", TURQUOISE);
            colors.put("violet", VIOLET);
            colors.put("wheat", WHEAT);
            colors.put("white", WHITE);
            colors.put("whitesmoke", WHITESMOKE);
            colors.put("yellow", YELLOW);
            colors.put("yellowgreen", YELLOWGREEN);
            COLORS = Collections.unmodifiableMap(colors);
        }
    }

    private static class WebColorParser {
        private static final Pattern RGB_HEX = Pattern.compile("^#([0-9a-f]{3}|[0-9a-f]{4}|[0-9a-f]{6}|[0-9a-f]{8})$", 2);
        private static final Pattern RGB_INTEGERS = Pattern.compile("^rgb\\(\\s*([+-]?[0-9]+)\\s*,\\s*([+-]?[0-9]+)\\s*,\\s*([+-]?[0-9]+)\\s*\\)$", 2);
        private static final Pattern RGBA_INTEGERS = Pattern.compile("^rgba\\(\\s*([+-]?[0-9]+)\\s*,\\s*([+-]?[0-9]+)\\s*,\\s*([+-]?[0-9]+)\\s*,\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)\\s*\\)$", 2);
        private static final Pattern RGB_PERCENTS = Pattern.compile("^rgb\\(\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)%\\s*,\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)%\\s*,\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)%\\s*\\)$", 2);
        private static final Pattern RGBA_PERCENTS = Pattern.compile("^rgba\\(\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)%\\s*,\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)%\\s*,\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)%\\s*,\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)\\s*\\)$", 2);
        private static final Pattern HSL_LITERAL = Pattern.compile("^hsl\\(\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)\\s*,\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)%\\s*,\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)%\\s*\\)$", 2);
        private static final Pattern HSLA_LITERAL = Pattern.compile("^hsla\\(\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)\\s*,\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)%\\s*,\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)%\\s*,\\s*([+-]?\\.[0-9]+|[+-]?[0-9]+|[+-]?[0-9]+\\.[0-9]+)\\s*\\)$", 2);
        private static final Pattern NAMED_COLOR = Pattern.compile("^[a-z]+$", 2);

        private WebColorParser() {
        }

        public static Color parse(String value) throws IllegalArgumentException {
            if (value == null) {
                throw new IllegalArgumentException("null color value");
            }
            if ((value = value.trim().toLowerCase(Locale.US)).startsWith("#")) {
                Matcher rgbHexMatcher = RGB_HEX.matcher(value);
                if (rgbHexMatcher.matches()) {
                    String hex = rgbHexMatcher.group(1);
                    if (hex.length() == 3) {
                        int r = WebColorParser.parseHex(hex.substring(0, 1)) * 17;
                        int g = WebColorParser.parseHex(hex.substring(1, 2)) * 17;
                        int b = WebColorParser.parseHex(hex.substring(2, 3)) * 17;
                        return RgbaColor.of(r, g, b);
                    }
                    if (hex.length() == 4) {
                        int r = WebColorParser.parseHex(hex.substring(0, 1)) * 17;
                        int g = WebColorParser.parseHex(hex.substring(1, 2)) * 17;
                        int b = WebColorParser.parseHex(hex.substring(2, 3)) * 17;
                        int a = WebColorParser.parseHex(hex.substring(3, 4)) * 17;
                        return RgbaColor.of(r, g, b, a);
                    }
                    if (hex.length() == 6) {
                        int r = WebColorParser.parseHex(hex.substring(0, 2));
                        int g = WebColorParser.parseHex(hex.substring(2, 4));
                        int b = WebColorParser.parseHex(hex.substring(4, 6));
                        return RgbaColor.of(r, g, b);
                    }
                    if (hex.length() == 8) {
                        int r = WebColorParser.parseHex(hex.substring(0, 2));
                        int g = WebColorParser.parseHex(hex.substring(2, 4));
                        int b = WebColorParser.parseHex(hex.substring(4, 6));
                        int a = WebColorParser.parseHex(hex.substring(6, 8));
                        return RgbaColor.of(r, g, b, a);
                    }
                }
                throw new IllegalArgumentException("invalid hexadecimal rgb color: " + value);
            }
            if (value.startsWith("rgb(")) {
                Matcher rgbIntMatcher = RGB_INTEGERS.matcher(value);
                if (rgbIntMatcher.matches()) {
                    int r = WebColorParser.parseInt(rgbIntMatcher.group(1));
                    int g = WebColorParser.parseInt(rgbIntMatcher.group(2));
                    int b = WebColorParser.parseInt(rgbIntMatcher.group(3));
                    return RgbaColor.of(r, g, b);
                }
                Matcher rgbPercentMatcher = RGB_PERCENTS.matcher(value);
                if (rgbPercentMatcher.matches()) {
                    double r = WebColorParser.parseDouble(rgbPercentMatcher.group(1)) / 100.0;
                    double g = WebColorParser.parseDouble(rgbPercentMatcher.group(2)) / 100.0;
                    double b = WebColorParser.parseDouble(rgbPercentMatcher.group(3)) / 100.0;
                    return RgbaColor.of(r, g, b);
                }
                throw new IllegalArgumentException("invalid rgb color: " + value);
            }
            if (value.startsWith("rgba(")) {
                Matcher rgbaIntMatcher = RGBA_INTEGERS.matcher(value);
                if (rgbaIntMatcher.matches()) {
                    int r = WebColorParser.parseInt(rgbaIntMatcher.group(1));
                    int g = WebColorParser.parseInt(rgbaIntMatcher.group(2));
                    int b = WebColorParser.parseInt(rgbaIntMatcher.group(3));
                    int a = (int)Math.round(WebColorParser.parseDouble(rgbaIntMatcher.group(4)) * 255.0);
                    return RgbaColor.of(r, g, b, a);
                }
                Matcher rgbaPercentMatcher = RGBA_PERCENTS.matcher(value);
                if (rgbaPercentMatcher.matches()) {
                    double r = WebColorParser.parseDouble(rgbaPercentMatcher.group(1)) / 100.0;
                    double g = WebColorParser.parseDouble(rgbaPercentMatcher.group(2)) / 100.0;
                    double b = WebColorParser.parseDouble(rgbaPercentMatcher.group(3)) / 100.0;
                    double a = WebColorParser.parseDouble(rgbaPercentMatcher.group(4));
                    return RgbaColor.of(r, g, b, a);
                }
                throw new IllegalArgumentException("invalid rgba color: " + value);
            }
            if (value.startsWith("hsl(")) {
                Matcher hslMatcher = HSL_LITERAL.matcher(value);
                if (hslMatcher.matches()) {
                    double h = WebColorParser.parseDouble(hslMatcher.group(1));
                    double s = WebColorParser.parseDouble(hslMatcher.group(2)) / 100.0;
                    double l = WebColorParser.parseDouble(hslMatcher.group(3)) / 100.0;
                    return HslaColor.of(h, s, l);
                }
                throw new IllegalArgumentException("invalid hsl color: " + value);
            }
            if (value.startsWith("hsla(")) {
                Matcher hslaMatcher = HSLA_LITERAL.matcher(value);
                if (hslaMatcher.matches()) {
                    double h = WebColorParser.parseDouble(hslaMatcher.group(1));
                    double s = WebColorParser.parseDouble(hslaMatcher.group(2)) / 100.0;
                    double l = WebColorParser.parseDouble(hslaMatcher.group(3)) / 100.0;
                    double a = WebColorParser.parseDouble(hslaMatcher.group(4));
                    return HslaColor.of(h, s, l, a);
                }
                throw new IllegalArgumentException("invalid hsla color: " + value);
            }
            if (NAMED_COLOR.matcher(value).matches()) {
                Color color = NamedColors.COLORS.get(value);
                if (color != null) {
                    return color;
                }
                throw new IllegalArgumentException("unknown named color: " + value);
            }
            throw new IllegalArgumentException("invalid color value: " + value);
        }

        private static int parseInt(String value) throws IllegalArgumentException {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("invalid integer in color: " + value);
            }
        }

        private static int parseHex(String value) throws IllegalArgumentException {
            try {
                return Integer.parseInt(value, 16);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("invalid hex in color: " + value);
            }
        }

        private static double parseDouble(String value) throws IllegalArgumentException {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("invalid number in color: " + value);
            }
        }
    }

    public static class HslaColor
    implements Color {
        private final double h;
        private final double s;
        private final double l;
        private final double a;

        private HslaColor(double h, double s, double l, double a) {
            this.h = h < 0.0 ? h + 360.0 : (h %= 360.0);
            this.s = Math.max(0.0, Math.min(1.0, s));
            this.l = Math.max(0.0, Math.min(1.0, l));
            this.a = Math.max(0.0, Math.min(1.0, a));
        }

        public static HslaColor of(double h, double s, double l) {
            return HslaColor.of(h, s, l, 1.0);
        }

        public static HslaColor of(double h, double s, double l, double a) {
            return new HslaColor(h, s, l, a);
        }

        public static HslaColor of(String value) throws IllegalArgumentException {
            return WebColorParser.parse(value).toHsla();
        }

        @Override
        public RgbaColor toRgba() {
            double h = this.h % 360.0 / 360.0;
            double q = this.l < 0.5 ? this.l * (1.0 + this.s) : this.l + this.s - this.s * this.l;
            double p = 2.0 * this.l - q;
            double r = Math.max(0.0, Math.min(1.0, HslaColor.hueToRgb(p, q, h + 0.3333333333333333)));
            double g = Math.max(0.0, Math.min(1.0, HslaColor.hueToRgb(p, q, h)));
            double b = Math.max(0.0, Math.min(1.0, HslaColor.hueToRgb(p, q, h - 0.3333333333333333)));
            return RgbaColor.of(r, g, b, this.a);
        }

        private static double hueToRgb(double p, double q, double h) {
            if (h < 0.0) {
                h += 1.0;
            }
            if (h > 1.0) {
                h -= 1.0;
            }
            if (6.0 * h < 1.0) {
                return p + (q - p) * 6.0 * h;
            }
            if (2.0 * h < 1.0) {
                return q;
            }
            if (3.0 * h < 2.0) {
                return p + (q - p) * 6.0 * (0.6666666666666666 - h);
            }
            return p;
        }

        @Override
        public HslaColor toHsla() {
            return this;
        }

        @Override
        public double red() {
            return this.toRgba().red();
        }

        @Override
        public double green() {
            return this.toRgba().green();
        }

        @Override
        public double blue() {
            return this.toRgba().blue();
        }

        @Override
        public double hue() {
            return this.h;
        }

        @Override
        public double saturation() {
            return this.s;
        }

        @Override
        public double luminance() {
            return this.l;
        }

        @Override
        public double alpha() {
            return this.a;
        }

        public String toString() {
            double h = this.h % 360.0;
            double s = this.s * 100.0;
            double l = this.l * 100.0;
            double a = this.a;
            return a == 1.0 ? String.format("hsl(%.2f, %.2f%%, %.2f%%)", h, s, l) : String.format("hsla(%.2f, %.2f%%, %.2f%%, %f)", h, s, l, a);
        }
    }

    public static class RgbaColor
    implements Color {
        private final double r;
        private final double g;
        private final double b;
        private final double a;

        private RgbaColor(double r, double g, double b, double a) {
            this.r = Math.max(0.0, Math.min(1.0, r));
            this.g = Math.max(0.0, Math.min(1.0, g));
            this.b = Math.max(0.0, Math.min(1.0, b));
            this.a = Math.max(0.0, Math.min(1.0, a));
        }

        public static RgbaColor of(int r, int g, int b) {
            return RgbaColor.of(r, g, b, 255);
        }

        public static RgbaColor of(int r, int g, int b, int a) {
            return RgbaColor.of((double)r / 255.0, (double)g / 255.0, (double)b / 255.0, (double)a / 255.0);
        }

        public static RgbaColor of(double r, double g, double b) {
            return RgbaColor.of(r, g, b, 1.0);
        }

        public static RgbaColor of(double r, double g, double b, double a) {
            return new RgbaColor(r, g, b, a);
        }

        public static RgbaColor of(String value) throws IllegalArgumentException {
            return WebColorParser.parse(value).toRgba();
        }

        @Override
        public RgbaColor toRgba() {
            return this;
        }

        @Override
        public HslaColor toHsla() {
            double min = Math.min(this.r, Math.min(this.g, this.b));
            double max = Math.max(this.r, Math.max(this.g, this.b));
            double h = 0.0;
            if (max == min) {
                h = 0.0;
            } else if (max == this.r) {
                h = (60.0 * (this.g - this.b) / (max - min) + 360.0) % 360.0;
            } else if (max == this.g) {
                h = 60.0 * (this.b - this.r) / (max - min) + 120.0;
            } else if (max == this.b) {
                h = 60.0 * (this.r - this.g) / (max - min) + 240.0;
            }
            double l = (max + min) / 2.0;
            double s = max == min ? 0.0 : (l <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min));
            return HslaColor.of(h, s, l, this.a);
        }

        @Override
        public double red() {
            return this.r;
        }

        @Override
        public double green() {
            return this.g;
        }

        @Override
        public double blue() {
            return this.b;
        }

        @Override
        public double hue() {
            return this.toHsla().hue();
        }

        @Override
        public double saturation() {
            return this.toHsla().saturation();
        }

        @Override
        public double luminance() {
            return this.toHsla().luminance();
        }

        @Override
        public double alpha() {
            return this.a;
        }

        public String toString() {
            int r = (int)Math.round(this.r * 255.0);
            int g = (int)Math.round(this.g * 255.0);
            int b = (int)Math.round(this.b * 255.0);
            int a = (int)Math.round(this.a * 255.0);
            return a == 255 ? String.format("#%02x%02x%02x", r, g, b) : String.format("#%02x%02x%02x%02x", r, g, b, a);
        }
    }

    public static interface Color {
        public static Color valueOf(String value) throws IllegalArgumentException {
            return WebColorParser.parse(value);
        }

        public static Color forName(String name) {
            return NamedColors.forName(name);
        }

        public double red();

        public double green();

        public double blue();

        public double hue();

        public double saturation();

        public double luminance();

        public double alpha();

        public RgbaColor toRgba();

        public HslaColor toHsla();
    }
}

