/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.formatter;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatResult;
import com.jxdinfo.hussar.formdesign.common.model.ResultCoreVO;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.RestTemplateHttpUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeFormatter {
    private static final Logger logger = LoggerFactory.getLogger(CodeFormatter.class);

    private CodeFormatter() {
    }

    public static CodeFormatResult formatterHtml(String sourceCode, String parserType) {
        CodeFormatResult codeFormatResult = new CodeFormatResult();
        if (ToolUtil.isEmpty(sourceCode)) {
            logger.error("\u5f85\u6e32\u67d3\u4ee3\u7801\u4e3a\u7a7a");
            codeFormatResult = new CodeFormatResult(false, sourceCode, "\u5f85\u6e32\u67d3\u4ee3\u7801\u4e3a\u7a7a");
            return codeFormatResult;
        }
        FormDesignProperties formDesignProperties = SpringUtil.getBean(FormDesignProperties.class);
        if (formDesignProperties.isFormat()) {
            long codeFormatStart = System.currentTimeMillis();
            codeFormatResult = CodeFormatter.formatWithCodeFormatServer(sourceCode, formDesignProperties, parserType);
            String codeFormatUse = ToolUtil.logTime(codeFormatStart);
            logger.info("run codeFormat\u670d\u52a1\u8017\u65f6:{}s", (Object)codeFormatUse);
            return codeFormatResult;
        }
        codeFormatResult.setSucceed(true);
        codeFormatResult.setCodeFormatCode(sourceCode);
        return codeFormatResult;
    }

    public static CodeFormatResult formatWithCodeFormatServer(String sourceCode, FormDesignProperties formDesignProperties, String parserType) {
        CodeFormatResult codeFormatResult = new CodeFormatResult();
        String formatCode = "";
        HashMap<String, Object> compileParams = new HashMap<String, Object>();
        compileParams.put("sourceCode", sourceCode);
        compileParams.put("parserType", parserType);
        compileParams.put("checkedCode", formDesignProperties.isCheckedCode());
        ResultCoreVO resultCoreVO = RestTemplateHttpUtil.sendPostRequest(formDesignProperties.getCodeFormatAddress(), compileParams);
        Object data = resultCoreVO.getData();
        if (ToolUtil.isEmpty(data)) {
            logger.error("codeFormat\u683c\u5f0f\u5316\u4ee3\u7801\u5f02\u5e38\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            codeFormatResult.setSucceed(false);
            codeFormatResult.setMsg("codeFormat\u683c\u5f0f\u5316\u4ee3\u7801\u5f02\u5e38\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            codeFormatResult.setCodeFormatCode(sourceCode);
            return codeFormatResult;
        }
        HashMap resultMap = (HashMap)JSON.parseObject((String)JSON.toJSONString(data), HashMap.class);
        Object outputObj = resultMap.get("output");
        if (ToolUtil.isNotEmpty(outputObj)) {
            codeFormatResult.setSucceed((Boolean)resultMap.get("isSucceed"));
            codeFormatResult.setMessages((List)resultMap.get("messages"));
            try {
                formatCode = new String(String.valueOf(outputObj).getBytes(), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        codeFormatResult.setCodeFormatCode(formatCode);
        return codeFormatResult;
    }
}

