/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.StorageContext;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.file.StorageDumpLoadService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageEntity;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StorageDumpLoadServiceImpl
implements StorageDumpLoadService {
    private static final Logger logger = LoggerFactory.getLogger(StorageDumpLoadServiceImpl.class);
    private final StorageService storageService;
    private final StorageContext storageContext;
    private final ResourcePathService resourcePathService;

    public StorageDumpLoadServiceImpl(StorageService storageService, StorageContext storageContext, ResourcePathService resourcePathService) {
        this.storageService = storageService;
        this.storageContext = storageContext;
        this.resourcePathService = resourcePathService;
    }

    @Override
    public void dump(String appId, File target) throws IOException {
        this.dump(appId, path -> true, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String appId, Predicate<String> filter, File target) throws IOException {
        if (appId == null || filter == null || target == null) {
            throw new NullPointerException();
        }
        String recover = this.storageContext.getOverwrite("storageWorkspace");
        this.storageContext.setWorkspace(appId);
        try {
            StorageResult listResult = this.storageService.list("", "", false);
            if (listResult == null || !listResult.isSuccess() || listResult.getData() == null) {
                throw new StorageDumpLoadService.StorageDumpLoadException("list " + appId);
            }
            List list = (List)listResult.getData();
            list = list.stream().filter(Objects::nonNull).filter(entity -> StringUtils.isNotEmpty((CharSequence)entity.getPath()) && filter.test(entity.getPath())).sorted(Comparator.comparing(StorageEntity::getPath)).collect(Collectors.toList());
            for (StorageEntity entity2 : list) {
                String path = entity2.getPath();
                String type = StringUtils.defaultString((String)entity2.getType(), (String)CategoryEnum.PATH.getValue());
                StorageResult downloadResult = this.storageService.downloadByPath(path);
                if (downloadResult == null || !downloadResult.isSuccess() || downloadResult.getData() == null) {
                    throw new StorageDumpLoadService.StorageDumpLoadException("download " + appId + ":" + path);
                }
                byte[] content = (byte[])downloadResult.getData();
                this.mkdirs(target, this.remoteParent(path));
                if (CategoryEnum.fromValue((String)type) == CategoryEnum.META && this.isModule(content)) {
                    this.mkdirs(target, StringUtils.removeEnd((String)path, (String)".meta"));
                }
                File file = this.localFromRemote(target, path);
                logger.debug("dumping {}:{} => {}", new Object[]{appId, path, file});
                FileUtils.writeByteArrayToFile((File)file, (byte[])content);
            }
        }
        finally {
            this.storageContext.setOverwrite("storageWorkspace", recover);
        }
    }

    @Override
    public void load(String appId, File source) throws IOException {
        this.load(appId, path -> true, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(String appId, Predicate<String> filter, File source) throws IOException {
        if (appId == null || filter == null || source == null) {
            throw new NullPointerException();
        }
        String recover = this.storageContext.getOverwrite("storageWorkspace");
        this.storageContext.setWorkspace(appId);
        try {
            List<UploadTask> tasks = this.searchLocalWorkspace(source);
            for (UploadTask task : tasks) {
                StorageResult uploadResult;
                CategoryEnum type = task.getType();
                String path = task.getRemote();
                String uuid = task.getUuid();
                if (!filter.test(path)) continue;
                File file = task.getLocal();
                byte[] content = FileUtils.readFileToByteArray((File)file);
                logger.debug("loading {} => {}:{} ({})", new Object[]{file, appId, path, type});
                switch (type) {
                    case META: 
                    case JSON: {
                        uploadResult = this.storageService.uploadByUuid(type, uuid, path, content, true);
                        break;
                    }
                    case PATH: {
                        uploadResult = this.storageService.uploadByPath(path, content, true);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                if (uploadResult != null && uploadResult.isSuccess() && Objects.equals(uploadResult.getData(), true)) continue;
                throw new StorageDumpLoadService.StorageDumpLoadException("upload " + appId + ":" + path);
            }
        }
        finally {
            this.storageContext.setOverwrite("storageWorkspace", recover);
        }
    }

    private boolean isModule(byte[] content) {
        try {
            JSONObject meta = JSONObject.parseObject((String)new String(content, StandardCharsets.UTF_8));
            return Optional.ofNullable(meta).map(root -> root.get((Object)"type")).map("Module"::equals).orElse(false);
        }
        catch (JSONException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private String remoteParent(String path) {
        int index = path.lastIndexOf(47);
        if (index < 0) {
            return "";
        }
        return path.substring(0, index);
    }

    private File localFromRemote(File base, String path) {
        return new File(FileUtil.systemPath(base.getPath(), path));
    }

    private void mkdirs(File base, String path) throws IOException {
        File directory = this.localFromRemote(base, path);
        FileUtils.forceMkdir((File)directory);
    }

    private List<UploadTask> searchLocalWorkspace(File workspace) throws IOException {
        if (!workspace.exists()) {
            return Collections.emptyList();
        }
        if (!workspace.isDirectory()) {
            throw new StorageDumpLoadService.StorageDumpLoadException("not a directory " + workspace);
        }
        Collection files = FileUtils.listFiles((File)workspace, null, (boolean)true);
        LinkedHashMap<String, MetaJsonPair> mapping = new LinkedHashMap<String, MetaJsonPair>();
        ArrayList<Object> phase1Remain = new ArrayList<Object>();
        for (Object file : files) {
            if (((File)file).getName().endsWith(".meta")) {
                JSONObject jSONObject = this.parseJson((File)file);
                String type = Optional.ofNullable(jSONObject).map(json -> json.get((Object)"type")).filter(v -> v instanceof String).orElse(null);
                String uuid = Optional.ofNullable(jSONObject).map(json -> json.get((Object)"id")).filter(v -> v instanceof String).orElse(null);
                if (uuid != null) {
                    String path = FilenameUtils.removeExtension((String)((File)file).getPath());
                    MetaJsonPair pair = new MetaJsonPair();
                    pair.setUuid(uuid);
                    pair.setMeta((File)file);
                    pair.setModule(Objects.equals(type, "Module"));
                    mapping.put(path, pair);
                    continue;
                }
            }
            phase1Remain.add(file);
        }
        ArrayList<File> phase2Remain = new ArrayList<File>();
        for (File file : phase1Remain) {
            MetaJsonPair pair = (MetaJsonPair)mapping.get(file.getPath());
            if (pair != null) {
                pair.setJson(file);
                continue;
            }
            phase2Remain.add(file);
        }
        ArrayList<UploadTask> list = new ArrayList<UploadTask>();
        for (MetaJsonPair pair : mapping.values()) {
            UploadTask metaTask = new UploadTask();
            metaTask.setType(CategoryEnum.META);
            metaTask.setModule(pair.isModule());
            metaTask.setUuid(pair.getUuid());
            metaTask.setLocal(pair.getMeta());
            metaTask.setRemote(this.remotePath(workspace, pair.getMeta()));
            list.add(metaTask);
            if (pair.getJson() == null) continue;
            UploadTask jsonTask = new UploadTask();
            jsonTask.setType(CategoryEnum.JSON);
            jsonTask.setUuid(pair.getUuid());
            jsonTask.setLocal(pair.getJson());
            jsonTask.setRemote(this.remotePath(workspace, pair.getJson()));
            list.add(jsonTask);
        }
        for (File file : phase2Remain) {
            UploadTask dataTask = new UploadTask();
            dataTask.setType(CategoryEnum.PATH);
            dataTask.setLocal(file);
            dataTask.setRemote(this.remotePath(workspace, file));
            list.add(dataTask);
        }
        list.sort(Comparator.comparing(UploadTask::getRemote));
        return list;
    }

    private String remotePath(File base, File path) {
        String relative = FileUtil.removePathPrefixAndConvertPosix(base.getPath(), path.getPath());
        return FileUtil.posixPath("/", relative).substring(1);
    }

    private JSONObject parseJson(File file) {
        try {
            return JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
        }
        catch (JSONException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static class MetaJsonPair {
        private File meta;
        private File json;
        private String uuid;
        private boolean module;

        private MetaJsonPair() {
        }

        public File getMeta() {
            return this.meta;
        }

        public void setMeta(File meta) {
            this.meta = meta;
        }

        public File getJson() {
            return this.json;
        }

        public void setJson(File json) {
            this.json = json;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public boolean isModule() {
            return this.module;
        }

        public void setModule(boolean module) {
            this.module = module;
        }
    }

    private static class UploadTask {
        private File local;
        private String remote;
        private CategoryEnum type;
        private String uuid;
        private boolean module;

        private UploadTask() {
        }

        public File getLocal() {
            return this.local;
        }

        public void setLocal(File local) {
            this.local = local;
        }

        public String getRemote() {
            return this.remote;
        }

        public void setRemote(String remote) {
            this.remote = remote;
        }

        public CategoryEnum getType() {
            return this.type;
        }

        public void setType(CategoryEnum type) {
            this.type = type;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public boolean isModule() {
            return this.module;
        }

        public void setModule(boolean module) {
            this.module = module;
        }
    }
}

