/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.config;

import com.jxdinfo.hussar.formdesign.common.properties.FormDesignStorageProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageConfiguration;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Primary
@Component
public class StorageContext
implements StorageConfiguration {
    public static final String OVERWRITE_ADDR = "storageAddr";
    public static final String OVERWRITE_WORKSPACE = "storageWorkspace";
    public static final String OVERWRITE_CIPHER = "storageCipher";
    private final FormDesignStorageProperties formDesignStorageProperties;

    @Autowired
    public StorageContext(FormDesignStorageProperties formDesignStorageProperties) {
        this.formDesignStorageProperties = formDesignStorageProperties;
    }

    public void with(String addr, String workspace, String cipher, Runnable execution) {
        this.with(addr, workspace, cipher, () -> {
            execution.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T with(String addr, String workspace, String cipher, Supplier<T> computation) {
        String oldAddr = this.getOverwrite(OVERWRITE_ADDR);
        String oldWorkspace = this.getOverwrite(OVERWRITE_WORKSPACE);
        String oldCipher = this.getOverwrite(OVERWRITE_CIPHER);
        this.setOverwrite(OVERWRITE_ADDR, addr);
        this.setOverwrite(OVERWRITE_WORKSPACE, workspace);
        this.setOverwrite(OVERWRITE_CIPHER, cipher);
        try {
            T t = computation.get();
            return t;
        }
        finally {
            this.setOverwrite(OVERWRITE_ADDR, oldAddr);
            this.setOverwrite(OVERWRITE_WORKSPACE, oldWorkspace);
            this.setOverwrite(OVERWRITE_CIPHER, oldCipher);
        }
    }

    public String getAddr() {
        return this.computeOverwrite(OVERWRITE_ADDR, this.formDesignStorageProperties::getAddr);
    }

    public void setAddr(String addr) {
        this.setOverwrite(OVERWRITE_ADDR, addr);
    }

    public String getWorkspace() {
        return this.computeOverwrite(OVERWRITE_WORKSPACE, () -> {
            String appId = AppContextUtil.getAppId();
            if (appId != null) {
                return appId;
            }
            return this.formDesignStorageProperties.getWorkspace();
        });
    }

    public void setWorkspace(String workspace) {
        this.setOverwrite(OVERWRITE_WORKSPACE, workspace);
    }

    public String getCipher() {
        return this.computeOverwrite(OVERWRITE_CIPHER, this.formDesignStorageProperties::getCipher);
    }

    public void setCipher(String cipher) {
        this.setOverwrite(OVERWRITE_CIPHER, cipher);
    }

    private String computeOverwrite(String name, Supplier<String> computation) {
        String value = this.getOverwrite(name);
        if (value != null) {
            return value;
        }
        value = computation.get();
        return value;
    }

    public String getOverwrite(String name) {
        Object value = this.currentRequest().getAttribute(name);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void setOverwrite(String name, String value) {
        this.currentRequest().setAttribute(name, (Object)value);
    }

    private HttpServletRequest currentRequest() {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        if (!(attrs instanceof ServletRequestAttributes)) {
            throw new UnsupportedOperationException("StorageContext.currentRequest(): not ServletRequestAttributes");
        }
        return ((ServletRequestAttributes)attrs).getRequest();
    }
}

