/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.aspect;

import com.jxdinfo.hussar.formdesign.common.annotation.ExceptionCatcher;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;

public class ExceptionAspect {
    @Resource
    private FormDesignProperties formDesignProperties;
    private static final String TIME_PATTERN = "yyyy-MM-dd hh:mm:ss";

    @AfterThrowing(value="execution( * *(..))&&@annotation(catcher))", throwing="e", argNames="joinPoint,catcher,e")
    public FormDesignResponse<Void> afterThrowing(JoinPoint joinPoint, ExceptionCatcher catcher, Exception e) throws IOException, ParseException {
        if (e instanceof LcdpException) {
            LcdpException lcdpException = (LcdpException)e;
            if (lcdpException.getE() != null) {
                this.printServerLog(lcdpException.getE(), null, lcdpException.getDetail(), lcdpException.getPageInfoPath());
            } else {
                this.printServerLog(lcdpException, lcdpException.getLcdpExceptionEnum().getCode(), lcdpException.getLcdpExceptionEnum().getMsg() + "\n" + lcdpException.getDetail(), lcdpException.getPageInfoPath());
            }
        } else {
            this.printServerLog(e, null, e.toString(), "");
        }
        FormDesignResponse<Void> formDesignResponse = new FormDesignResponse<Void>();
        formDesignResponse.setErrorCode(500);
        return formDesignResponse;
    }

    private void printServerLog(Exception e, Integer errorCode, String errorMsg, String pageInfoPath) throws IOException, ParseException {
        File errorLog;
        String currentErrorTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern(TIME_PATTERN));
        String exceptionLogPath = this.formDesignProperties.getProjectPath() + "\\exception\\server";
        String logDirName = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        String logDirPath = exceptionLogPath + "\\" + logDirName;
        File logDir = new File(logDirPath);
        String pageName = "";
        if (!logDir.exists()) {
            FileUtils.forceMkdir((File)logDir);
        }
        if (!(errorLog = new File(logDirPath + "\\errorLog.txt")).exists()) {
            FileUtils.touch((File)errorLog);
        }
        if (ToolUtil.isNotEmpty(pageInfoPath)) {
            FileUtils.copyFileToDirectory((File)new File(pageInfoPath), (File)new File(logDirPath), (boolean)true);
            pageName = pageInfoPath.substring(pageInfoPath.lastIndexOf("\\") + 1);
            String reName = new SimpleDateFormat(TIME_PATTERN).parse(currentErrorTime).getTime() + pageName;
            File wpdFile = new File(logDirPath + "\\" + pageName);
            if (wpdFile.exists()) {
                wpdFile.renameTo(new File(logDirPath + "\\" + reName));
            }
            pageName = "\u5f02\u5e38\u9875\u9762\u6587\u4ef6\uff1a" + reName + "\n";
        }
        ArrayList<String> logS = new ArrayList<String>();
        logS.add(FileUtils.readFileToString((File)errorLog, (String)"utf-8"));
        String errorTime = "\u5f02\u5e38\u53d1\u751f\u65f6\u95f4\uff1a" + currentErrorTime + "\n";
        String errorCodeStr = "";
        if (errorCode != null) {
            errorCodeStr = "\u9519\u8bef\u7801\uff1a" + errorCode.toString() + "\n";
        }
        StringBuilder stackTrace = new StringBuilder();
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            if (!stackTraceElement.getClassName().contains("com.jxdinfo")) continue;
            stackTrace.append("   ").append(stackTraceElement.toString()).append("\n");
        }
        String logs = errorTime + errorCodeStr + pageName + errorMsg + "\n" + stackTrace.toString();
        logS.add(logs);
        e.printStackTrace();
        Collections.reverse(logS);
        FileUtils.writeLines((File)errorLog, logS);
    }
}

