/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.properties;

import com.jxdinfo.hussar.formdesign.common.scenes.model.FormDesignScenes;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar-formdesign")
public class FormDesignProperties {
    public static final String PREFIX = "hussar-formdesign";
    public static final String views = "views";
    public static final String pages = "pages";
    private boolean checkedCode = false;
    private boolean localCodeFormatter = false;
    private String api = "api";
    private FormDesignScenes scenes = FormDesignScenes.OFFLINE;
    private boolean lockEnabled = true;
    private boolean format = true;
    private boolean syncMenu = true;
    private boolean multiSource = false;
    private String projectRootPath = "/.project-store";
    private String backProjectPath = "hussar-web";
    private String javaCodePath = "/src/main/java";
    private String frontProjectPath = "hussar-front";
    private String mobileFrontProjectPath = "hussar-mobile";
    private String pageSuffix = ".vue";
    private String jsSuffix = ".js";
    private String vueCodePath = "/src/pages/index";
    private String mobileVueCodePath = "/src/views";
    private String commonStylePath = "/src/assets/css";
    private String defaultStyleFileName = "/default_value.css";
    private String cssCodePath = "/src/assets/css";
    private String projectCodePath = "/code";
    private String projectCustomComponentsPath = "/customComponents";
    private String projectCoverPath = "/cover";
    private String projectPageTemplatePath = "/PageTemplate";
    private String datasourceStorePath = "/datasource/db.json";
    private String datasourceTypeStorePath = "/datasource/dataSourceType.json";
    private String javaPath = "/com/jxdinfo/hussar";
    private String staticPath = "/static/speedcode";
    private String frontApiPath = "/src/pages/index";
    private String mobileFrontApiPath = "/src/api";
    private String workflowListenerPath = "/bpm/listener";
    private String workflowPath = "/bpm/workflow";
    private String styleSchemeSpace = "/style-scheme";
    private String webUrl = "http://localhost:8081";
    private String mobileUrl = "http://localhost:8380";
    private String mobileIp = "http://localhost";
    private String frontCompilePath = "c:/tmp/hussar-compile";
    private String frontCompileHtmlPath = "/src/pages/index/index.html";
    private String mobileCompilePath = "c:/tmp/hussar-compile";
    private String mobileCompileServer = "http://localhost:8989/buildEntry";
    private String codeFormatAddress = "http://localhost:8820/codeFormat";
    private String mobileCompileHtmlPath = "/public/index.html";
    private String frontCompileServer = "http://localhost:8989/buildEntry";
    private String workspace = "c:/";
    private boolean developerMode = false;
    private boolean localUnReset = false;
    private boolean localUnResetNoCompile = false;
    private boolean offlineLr = false;
    private String modules = "modules";
    private List<String> mode = new ArrayList<String>(Arrays.asList("web", "mobile"));
    private String restart = "false";

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public boolean isLockEnabled() {
        return this.lockEnabled;
    }

    public void setLockEnabled(boolean lockEnabled) {
        this.lockEnabled = lockEnabled;
    }

    public String getModules() {
        return this.modules;
    }

    public void setModules(String modules) {
        this.modules = modules;
    }

    public boolean isOfflineLr() {
        return this.offlineLr;
    }

    public void setOfflineLr(boolean offlineLr) {
        this.offlineLr = offlineLr;
    }

    public boolean isLocalUnReset() {
        return this.localUnReset;
    }

    public void setLocalUnReset(boolean localUnReset) {
        this.localUnReset = localUnReset;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        if (workspace.length() > 0 && !workspace.endsWith(File.separator)) {
            workspace = workspace + File.separator;
        }
        this.workspace = workspace;
    }

    public FormDesignScenes getScenes() {
        return this.scenes;
    }

    public void setScenes(String scenes) {
        try {
            if (ToolUtil.isNotEmpty(scenes)) {
                this.scenes = FormDesignScenes.valueOf(scenes.toUpperCase());
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.err.println("\u573a\u666f\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u9ed8\u8ba4\u4f7f\u7528 OFFLINE \u573a\u666f\uff1a" + scenes);
        }
    }

    public String getRestart() {
        return this.restart;
    }

    public void setRestart(String restart) {
        this.restart = restart;
    }

    public String getProjectPath() {
        return this.getBackProjectPath();
    }

    public String getProjectRootPath() {
        return this.projectRootPath;
    }

    public void setProjectRootPath(String projectRootPath) {
        this.projectRootPath = projectRootPath;
    }

    public String getBackProjectPath() {
        return ToolUtil.pathFomatterByOS(this.workspace + this.backProjectPath);
    }

    public void setBackProjectPath(String backProjectPath) {
        this.backProjectPath = backProjectPath;
    }

    public String getFrontProjectPath() {
        return ToolUtil.pathFomatterByOS(this.workspace + this.frontProjectPath);
    }

    public void setFrontProjectPath(String frontProjectPath) {
        this.frontProjectPath = frontProjectPath;
    }

    public String getMobProjectPath() {
        return this.mobileFrontProjectPath;
    }

    public String getMobileFrontProjectPath() {
        return ToolUtil.pathFomatterByOS(this.workspace + this.mobileFrontProjectPath);
    }

    public void setMobileFrontProjectPath(String mobileFrontProjectPath) {
        this.mobileFrontProjectPath = mobileFrontProjectPath;
    }

    public String getDefaultStyleFileName() {
        return this.defaultStyleFileName;
    }

    public void setDefaultStyleFileName(String defaultStyleFileName) {
        this.defaultStyleFileName = defaultStyleFileName;
    }

    public String getStaticPath() {
        return this.staticPath;
    }

    public void setStaticPath(String staticPath) {
        this.staticPath = staticPath;
    }

    public String getJavaCodePath() {
        return ToolUtil.pathFomatterByOS(this.javaCodePath);
    }

    public void setJavaCodePath(String javaCodePath) {
        this.javaCodePath = javaCodePath;
    }

    public String getVueCodePath() {
        return ToolUtil.pathFomatterByOS(FileUtil.systemPath(this.vueCodePath, AppContextUtil.posixFilePathPrefix(), views));
    }

    public String getVueCodePath(Integer strategy) {
        if (null != strategy) {
            return ToolUtil.pathFomatterByOS(FileUtil.systemPath(this.vueCodePath, AppContextUtil.posixFilePathPrefix(), pages));
        }
        return ToolUtil.pathFomatterByOS(FileUtil.systemPath(this.vueCodePath, AppContextUtil.posixFilePathPrefix(), views));
    }

    public void setVueCodePath(String vueCodePath) {
        this.vueCodePath = vueCodePath;
    }

    public String getMobileVueCodePath() {
        return this.mobileVueCodePath;
    }

    public void setMobileVueCodePath(String mobileVueCodePath) {
        this.mobileVueCodePath = mobileVueCodePath;
    }

    public String getCssCodePath() {
        return ToolUtil.pathFomatterByOS(this.cssCodePath);
    }

    public void setCssCodePath(String cssCodePath) {
        this.cssCodePath = cssCodePath;
    }

    public String getProjectCodePath() {
        return ToolUtil.pathFomatterByOS(this.projectCodePath);
    }

    public void setProjectCodePath(String projectCodePath) {
        this.projectCodePath = projectCodePath;
    }

    public String getJavaPath() {
        return ToolUtil.pathFomatterByOS(this.javaPath);
    }

    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }

    public String getFrontApiPath() {
        return ToolUtil.pathFomatterByOS(FileUtil.systemPath(this.frontApiPath, AppContextUtil.posixFilePathPrefix(), this.api));
    }

    public void setFrontApiPath(String frontApiPath) {
        this.frontApiPath = frontApiPath;
    }

    public String getMobileFrontApiPath() {
        return this.mobileFrontApiPath;
    }

    public void setMobileFrontApiPath(String mobileFrontApiPath) {
        this.mobileFrontApiPath = mobileFrontApiPath;
    }

    public String getPageSuffix() {
        return this.pageSuffix;
    }

    public void setPageSuffix(String pageSuffix) {
        this.pageSuffix = pageSuffix;
    }

    public String getJsSuffix() {
        return this.jsSuffix;
    }

    public void setJsSuffix(String jsSuffix) {
        this.jsSuffix = jsSuffix;
    }

    public String getWorkflowListenerPath() {
        return ToolUtil.pathFomatterByOS(this.workflowListenerPath);
    }

    public void setWorkflowListenerPath(String workflowListenerPath) {
        this.workflowListenerPath = workflowListenerPath;
    }

    public String getWorkflowPath() {
        return ToolUtil.pathFomatterByOS(this.workflowPath);
    }

    public void setWorkflowPath(String workflowPath) {
        this.workflowPath = workflowPath;
    }

    public String getJavaGeneratePath() {
        return ToolUtil.pathFomatterByOS(this.getBackProjectPath() + this.javaCodePath + this.javaPath);
    }

    public String getProjectAndCodePath() {
        return ToolUtil.pathFomatterByOS(this.getBackProjectPath() + this.projectRootPath + this.projectCodePath);
    }

    public String getProjectAndCustomComponentsPath() {
        return ToolUtil.pathFomatterByOS(this.getBackProjectPath() + this.projectRootPath + this.projectCustomComponentsPath);
    }

    public String getProjectAndCustomComponentCoverPath() {
        return ToolUtil.pathFomatterByOS(this.getBackProjectPath() + this.projectRootPath + this.projectCustomComponentsPath + this.projectCoverPath);
    }

    public String getProjectAndPageTemplatePath() {
        return ToolUtil.pathFomatterByOS(this.getBackProjectPath() + this.projectRootPath + this.projectPageTemplatePath);
    }

    public String getProjectAndPageTemplateCoverPath() {
        return ToolUtil.pathFomatterByOS(this.getBackProjectPath() + this.projectRootPath + this.projectPageTemplatePath + this.projectCoverPath);
    }

    public String getFrontApiAbPath() {
        return ToolUtil.pathFomatterByOS(this.getFrontProjectPath() + this.frontApiPath);
    }

    public String getDatasourceStorePath() {
        return ToolUtil.pathFomatterByOS(this.getBackProjectPath() + this.projectRootPath + this.datasourceStorePath);
    }

    public String getWebProjectSettingPath() {
        String webProjectSettingPath = "/setting/webProSetInfo.json";
        return ToolUtil.pathFomatterByOS(this.getBackProjectPath() + this.projectRootPath + webProjectSettingPath);
    }

    public void setDatasourceStorePath(String datasourceStorePath) {
        this.datasourceStorePath = datasourceStorePath;
    }

    public String getBpmListenerPath() {
        return ToolUtil.pathFomatterByOS(this.getBackProjectPath() + this.javaCodePath + this.javaPath + this.workflowListenerPath);
    }

    public String getDatasourceTypeStorePath() {
        return ToolUtil.pathFomatterByOS(this.getBackProjectPath() + this.projectRootPath + this.datasourceTypeStorePath);
    }

    public void setDatasourceTypeStorePath(String datasourceTypeStorePath) {
        this.datasourceTypeStorePath = datasourceTypeStorePath;
    }

    public String getCommonStylePath() {
        return ToolUtil.pathFomatterByOS(this.commonStylePath);
    }

    public String getWebDefaultStyleFilePath() {
        return ToolUtil.pathFomatterByOS(this.getFrontProjectPath() + this.cssCodePath + this.defaultStyleFileName);
    }

    public String getWebCommonStylePath() {
        return ToolUtil.pathFomatterByOS(this.getFrontProjectPath() + this.commonStylePath);
    }

    public void setCommonStylePath(String commonStylePath) {
        this.commonStylePath = commonStylePath;
    }

    public void setStyleSchemeSpace(String styleSchemeSpace) {
        this.styleSchemeSpace = styleSchemeSpace;
    }

    public String getStyleSchemeSpace() {
        return ToolUtil.pathFomatterByOS(this.getBackProjectPath() + this.projectRootPath + this.styleSchemeSpace);
    }

    public List<String> getMode() {
        return this.mode;
    }

    public void setMode(List<String> mode) {
        this.mode = mode;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String webIPPort) {
        this.webUrl = webIPPort;
    }

    public String getMobileUrl() {
        return this.mobileUrl;
    }

    public void setMobileUrl(String mobileUrl) {
        this.mobileUrl = mobileUrl;
    }

    public String getMobileIp() {
        return this.mobileIp;
    }

    public void setMobileIp(String mobileIp) {
        this.mobileIp = mobileIp;
    }

    public boolean isCertainMode(String modeStr) {
        if (ToolUtil.isNotEmpty(this.mode)) {
            for (String mode : this.mode) {
                if (!mode.equals(modeStr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFormat() {
        return this.format;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public boolean isMultiSource() {
        return this.multiSource;
    }

    public void setMultiSource(boolean multiSource) {
        this.multiSource = multiSource;
    }

    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    public void setDeveloperMode(boolean developerMode) {
        this.developerMode = developerMode;
    }

    public boolean isSyncMenu() {
        return this.syncMenu;
    }

    public void setSyncMenu(boolean syncMenu) {
        this.syncMenu = syncMenu;
    }

    public String getFrontCompilePath() {
        return this.frontCompilePath;
    }

    public void setFrontCompilePath(String frontCompilePath) {
        this.frontCompilePath = frontCompilePath;
    }

    public String getFrontCompileHtmlPath() {
        return this.frontCompileHtmlPath;
    }

    public void setFrontCompileHtmlPath(String frontCompileHtmlPath) {
        this.frontCompileHtmlPath = frontCompileHtmlPath;
    }

    public String getFrontCompileServer() {
        return this.frontCompileServer;
    }

    public void setFrontCompileServer(String frontCompileServer) {
        this.frontCompileServer = frontCompileServer;
    }

    public String getMobileCompileHtmlPath() {
        return this.mobileCompileHtmlPath;
    }

    public void setMobileCompileHtmlPath(String mobileCompileHtmlPath) {
        this.mobileCompileHtmlPath = mobileCompileHtmlPath;
    }

    public String getMobileCompilePath() {
        return this.mobileCompilePath;
    }

    public void setMobileCompilePath(String mobileCompilePath) {
        this.mobileCompilePath = mobileCompilePath;
    }

    public String getMobileCompileServer() {
        return this.mobileCompileServer;
    }

    public void setMobileCompileServer(String mobileCompileServer) {
        this.mobileCompileServer = mobileCompileServer;
    }

    public boolean backUnReset() {
        return this.localUnReset || this.offlineLr;
    }

    public boolean isLocalUnResetNoCompile() {
        return this.localUnResetNoCompile;
    }

    public void setLocalUnResetNoCompile(boolean localUnResetNoCompile) {
        this.localUnResetNoCompile = localUnResetNoCompile;
    }

    public String getCodeFormatAddress() {
        return this.codeFormatAddress;
    }

    public void setCodeFormatAddress(String codeFormatAddress) {
        this.codeFormatAddress = codeFormatAddress;
    }

    public boolean isCheckedCode() {
        return this.checkedCode;
    }

    public void setCheckedCode(boolean checkedCode) {
        this.checkedCode = checkedCode;
    }

    public boolean isLocalCodeFormatter() {
        return this.localCodeFormatter;
    }

    public void setLocalCodeFormatter(boolean localCodeFormatter) {
        this.localCodeFormatter = localCodeFormatter;
    }
}

