/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl;

import com.jxdinfo.hussar.formdesign.common.constant.ExportResourceConstant;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.ResourcePath;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourcePathServiceImpl
implements ResourcePathService {
    private static final String MERGE_BASE = ".merge-base";
    private static final String REMOTE_NOT_USED = "not-used";
    private static final String REMOTE_PREVIEW = "preview";
    @Autowired
    private FormDesignProperties formDesignProperties;

    private String localProjectStore() {
        return FileUtil.systemPath(this.formDesignProperties.getBackProjectPath(), this.formDesignProperties.getProjectRootPath());
    }

    private String convertToRemoteProjectStore(String localProjectStore) {
        return FileUtil.removePathPrefixAndConvertPosix(this.formDesignProperties.getBackProjectPath(), localProjectStore);
    }

    @Override
    public ResourcePath projectStore(String ... pathSegments) {
        String localPrefix = this.localProjectStore();
        String remotePrefix = StringUtils.removeStart((String)FileUtil.posixPath(this.formDesignProperties.getProjectRootPath()), (String)"/");
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStoreCode(String ... pathSegments) {
        String localPrefix = this.formDesignProperties.getProjectAndCodePath();
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStoreDatasourceFile() {
        String datasourceStorePath = FileUtil.removePathPrefixAndConvertPosix(this.localProjectStore(), this.formDesignProperties.getDatasourceStorePath());
        return this.projectStore(datasourceStorePath);
    }

    @Override
    public ResourcePath projectStoreDatasourceTypeFile() {
        String datasourceTypeStorePath = FileUtil.removePathPrefixAndConvertPosix(this.localProjectStore(), this.formDesignProperties.getDatasourceTypeStorePath());
        return this.projectStore(datasourceTypeStorePath);
    }

    @Override
    public ResourcePath projectStoreSettingFile() {
        String webProjectSettingPath = FileUtil.removePathPrefixAndConvertPosix(this.localProjectStore(), this.formDesignProperties.getWebProjectSettingPath());
        return this.projectStore(webProjectSettingPath);
    }

    @Override
    public ResourcePath projectStorePageTemplate(String ... pathSegments) {
        String localPrefix = this.formDesignProperties.getProjectAndPageTemplatePath();
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStorePageTemplateCover(String ... pathSegments) {
        String localPrefix = this.formDesignProperties.getProjectAndPageTemplateCoverPath();
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStoreCustomComponents(String ... pathSegments) {
        String localPrefix = this.formDesignProperties.getProjectAndCustomComponentsPath();
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStoreCustomComponentsCover(String ... pathSegments) {
        String localPrefix = this.formDesignProperties.getProjectAndCustomComponentCoverPath();
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath projectStoreStyleScheme(String ... pathSegments) {
        String localPrefix = this.formDesignProperties.getStyleSchemeSpace();
        String remotePrefix = this.convertToRemoteProjectStore(localPrefix);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath mergeBaseStore(String ... pathSegments) {
        String localPrefix = FileUtil.systemPath(this.formDesignProperties.getBackProjectPath(), MERGE_BASE);
        String remotePrefix = FileUtil.posixPath(REMOTE_NOT_USED, MERGE_BASE);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath backProject(String ... pathSegments) {
        String localPrefix = this.formDesignProperties.getBackProjectPath();
        String remotePrefix = FileUtil.posixPath(REMOTE_NOT_USED, "hussar-web");
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath backProjectJava(String ... pathSegments) {
        String localPrefix = this.formDesignProperties.getJavaGeneratePath();
        String remotePrefix = FileUtil.posixPath(REMOTE_NOT_USED, "hussar-web", FileUtil.removePathPrefixAndConvertPosix(this.formDesignProperties.getBackProjectPath(), localPrefix));
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath webProject(String ... pathSegments) {
        String localPrefix = this.formDesignProperties.getFrontProjectPath();
        String remotePrefix = FileUtil.posixPath(REMOTE_PREVIEW, "web");
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath webProjectApi(String ... pathSegments) {
        String localPrefix = FileUtil.systemPath(this.formDesignProperties.getFrontProjectPath(), this.formDesignProperties.getFrontApiPath());
        String remotePrefix = FileUtil.posixPath(REMOTE_PREVIEW, "web", this.formDesignProperties.getFrontApiPath());
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath publishCodeTempPath(String ... pathSegments) {
        String localPrefix = FileUtil.systemPath(this.formDesignProperties.getWorkspace(), ExportResourceConstant.PUBLISH_CACHE);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, "");
    }

    @Override
    public ResourcePath webProjectVue(Integer strategy, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath(this.formDesignProperties.getFrontProjectPath(), this.formDesignProperties.getVueCodePath(strategy));
        String remotePrefix = FileUtil.posixPath(REMOTE_PREVIEW, "web", this.formDesignProperties.getVueCodePath(strategy));
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath mobileProject(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath(this.formDesignProperties.getWorkspace(), name);
        String remotePrefix = FileUtil.posixPath(REMOTE_PREVIEW, name);
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath mobileProjectApi(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath(this.formDesignProperties.getWorkspace(), name, this.formDesignProperties.getMobileFrontApiPath());
        String remotePrefix = FileUtil.posixPath(REMOTE_PREVIEW, name, this.formDesignProperties.getMobileFrontApiPath());
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }

    @Override
    public ResourcePath mobileProjectVue(String name, String ... pathSegments) {
        String localPrefix = FileUtil.systemPath(this.formDesignProperties.getWorkspace(), name, this.formDesignProperties.getMobileVueCodePath());
        String remotePrefix = FileUtil.posixPath(REMOTE_PREVIEW, name, this.formDesignProperties.getMobileVueCodePath());
        return ResourcePath.of(FileUtil.posixPath(pathSegments), localPrefix, remotePrefix);
    }
}

