/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl;

import com.jxdinfo.hussar.formdesign.common.constant.ExportResourceConstant;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.PublishCache;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.publish.model.PublishDTO;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilePublishServiceImpl
implements FilePublishService {
    private static final Pattern REGEXP_LINE_SEPARATOR = Pattern.compile("\\n|\\r\\n?", 8);
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    ResourcePathService resourcePathService;
    private static final String PUBLISHCACHENAME = "PublishCacheName";
    private static final String PUBLISHCACHEKEY = "PublishCacheKey";

    @Override
    public void writeVueCode(String fileContent, String modulePath, String pageName, Integer strategy, String pageId) throws IOException {
        String filePath = this.resourcePathService.webProjectVue(strategy, modulePath, pageName + this.formDesignProperties.getPageSuffix()).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS(filePath);
        this.writeStringToFile(fileContent, filePath, pageId);
    }

    @Override
    public void writeMobileCode(String fileContent, String modulePath, String pageName, String vueRootPath, String pageId) throws IOException {
        vueRootPath = this.formDesignProperties.isLocalUnReset() ? vueRootPath + File.separator + "src" + File.separator + "pages" : vueRootPath + File.separator + "src" + File.separator + "views";
        vueRootPath = FilePublishServiceImpl.complementFilePath(vueRootPath);
        modulePath = FilePublishServiceImpl.complementFilePath(modulePath);
        String filePath = vueRootPath + modulePath + pageName + this.formDesignProperties.getPageSuffix();
        filePath = ToolUtil.pathFomatterByOS(filePath);
        this.writeStringToFile(fileContent, filePath, pageId);
    }

    @Override
    public void writeMobileRouterCode(String fileContent, String modulePath, String pageName, String vueRootPath, String pageId) throws IOException {
        vueRootPath = FilePublishServiceImpl.complementFilePath(vueRootPath);
        modulePath = FilePublishServiceImpl.complementFilePath(modulePath);
        String filePath = vueRootPath + "/src/router/" + modulePath + pageName + ".js";
        filePath = ToolUtil.pathFomatterByOS(filePath);
        this.writeStringToFile(fileContent, filePath, pageId);
    }

    private static String complementFilePath(String path) {
        boolean isModulePathEndWithSeparator = path.endsWith(File.separator);
        if (!isModulePathEndWithSeparator) {
            path = path + File.separator;
        }
        return path;
    }

    @Override
    public String writeMVCCode(String fileContent, String modulePath, String pageId) throws IOException {
        String filePath = this.resourcePathService.backProjectJava(AppContextUtil.getAppBackCodePrefix(), modulePath).getLocalPath();
        return this.writeStringToFile(fileContent, filePath, pageId);
    }

    @Override
    public void writeDatasourceCode(String fileContent) throws IOException {
        String filePath = this.formDesignProperties.getDatasourceStorePath();
        filePath = ToolUtil.pathFomatterByOS(filePath);
        this.writeStringToFile(fileContent, filePath);
    }

    @Override
    public String writeWebApiCode(String fileContent, String modulePath, String pageId) {
        String filePath = this.resourcePathService.webProjectApi(modulePath).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS(filePath);
        return this.writeStringToFile(fileContent, filePath, pageId);
    }

    @Override
    public String publishApiTempPath(String fileContent, String modulePath, String appId, String pageId) {
        String filePath = this.resourcePathService.publishCodeTempPath(ExportResourceConstant.API, AppContextUtil.getGeneratorFilePathPrefixByAppId(appId), modulePath).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS(filePath);
        return this.writeStringToFile(fileContent, filePath, pageId);
    }

    @Override
    public String publishVueTempPath(String fileContent, String modulePath, String appId, String pageId) {
        String filePath = this.resourcePathService.publishCodeTempPath(ExportResourceConstant.VUE, AppContextUtil.getGeneratorFilePathPrefixByAppId(appId), modulePath).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS(filePath);
        return this.writeStringToFile(fileContent, filePath, pageId);
    }

    @Override
    public String publishJavaTempPath(String fileContent, String modulePath, String appId, String pageId) {
        String filePath = this.resourcePathService.publishCodeTempPath(ExportResourceConstant.JAVA, this.formDesignProperties.getJavaPath(), AppContextUtil.getAppBackCodePrefixByAppId(appId), modulePath).getLocalPath();
        filePath = ToolUtil.pathFomatterByOS(filePath);
        return this.writeStringToFile(fileContent, filePath, pageId);
    }

    @Override
    public String writeIonicApiCode(String fileContent, String apiPath, String pageId) {
        apiPath = ToolUtil.pathFomatterByOS(apiPath);
        return this.writeStringToFile(fileContent, apiPath, pageId);
    }

    @Override
    public void writeWorkListener(String fileContent, String modulePath, String pageId) {
        String filePath = this.formDesignProperties.getBpmListenerPath() + modulePath;
        filePath = ToolUtil.pathFomatterByOS(filePath);
        this.writeStringToFile(fileContent, filePath, pageId);
    }

    @Override
    public void writeWebDefaultStyle(String fileContent) {
        String filePath = this.formDesignProperties.getWebDefaultStyleFilePath();
        filePath = ToolUtil.pathFomatterByOS(filePath);
        this.writeStringToFileIfRequired(fileContent, filePath);
    }

    @Override
    public void writeMobileDefaultStyle(String fileContent, String projectPath) {
        String filePath = this.formDesignProperties.getWorkspace() + projectPath + "\\src\\assets\\css\\default_value.css";
        filePath = ToolUtil.pathFomatterByOS(filePath);
        this.writeStringToFileIfRequired(fileContent, filePath);
    }

    @Override
    public String writeStringToFile(String content, String filePath) {
        filePath = ToolUtil.pathFomatterByOS(filePath);
        try {
            FileUtils.writeStringToFile((File)new File(filePath), (String)content, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filePath;
    }

    @Override
    public String writeStringToFile(String content, String filePath, String pageId) {
        PublishCache publishCache = this.getCacheById(pageId);
        Map<Object, Object> fileList = HussarUtils.isEmpty(publishCache.getFileList()) ? new HashMap() : publishCache.getFileList();
        filePath = ToolUtil.pathFomatterByOS(filePath);
        String path = FilenameUtils.normalize((String)filePath);
        fileList.put(path, content);
        publishCache.setFileList(fileList);
        this.setPublishCache(pageId, publishCache);
        return filePath;
    }

    @Override
    public String readCurrentPublishedFile(String filePath) throws IOException {
        File currentFile = new File(filePath);
        if (currentFile.exists()) {
            return FileUtils.readFileToString((File)currentFile, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public void submitDeferredTasks(Map<String, String> fileList) throws IOException, LcdpException {
        for (Map.Entry<String, String> entry : fileList.entrySet()) {
            File docFile;
            String path = entry.getKey();
            if (path.contains("BPM") && !(docFile = new File(path = path.substring(0, path.length() - 3))).getParentFile().exists()) {
                docFile.getParentFile().mkdirs();
            }
            this.writeStringToFile(entry.getValue(), path);
        }
    }

    @Override
    public void writeStringToFileIfRequired(String content, String filePath) {
        filePath = ToolUtil.pathFomatterByOS(filePath);
        try {
            File file = new File(filePath);
            if (this.isWriteRequired(file, content)) {
                FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isWriteRequired(File file, String content) {
        if (!file.isFile()) {
            return true;
        }
        try {
            String old = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            String[] oldLines = REGEXP_LINE_SEPARATOR.split(old, -1);
            String[] newLines = REGEXP_LINE_SEPARATOR.split(content, -1);
            if (oldLines.length != newLines.length) {
                return true;
            }
            for (int i = 0; i < oldLines.length; ++i) {
                if (Objects.equals(oldLines[i], newLines[i])) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
    }

    @Override
    public PublishCache getCacheById(String id) {
        String cacheKey;
        String cacheName = id + PUBLISHCACHENAME;
        PublishCache publishCache = HussarCacheUtil.containKey((String)cacheName, (Object)(cacheKey = id + PUBLISHCACHEKEY)) ? (PublishCache)HussarCacheUtil.get((String)cacheName, (Object)cacheKey) : new PublishCache();
        return publishCache;
    }

    @Override
    public void setPublishCache(String id, PublishCache publishCache) {
        String cacheName = id + PUBLISHCACHENAME;
        String cacheKey = id + PUBLISHCACHEKEY;
        HussarCacheUtil.evict((String)cacheName, (Object)cacheKey);
        HussarCacheUtil.put((String)cacheName, (Object)cacheKey, (Object)publishCache);
    }

    @Override
    public void writePublishSourceToCache(String id, String publishSource) {
        PublishCache publishCache = this.getCacheById(id);
        publishCache.setPublishSource(publishSource);
        this.setPublishCache(id, publishCache);
    }

    @Override
    public void writePublishResourceToCache(String id, PageInfo pageInfo, PublishDTO publishDTO) {
        PublishCache publishCache = this.getCacheById(id);
        publishCache.setPageInfo(pageInfo);
        publishCache.setPublishDTO(publishDTO);
        this.setPublishCache(id, publishCache);
    }

    @Override
    public void deleteCacheById(String id) {
        String cacheName = id + PUBLISHCACHENAME;
        String cacheKey = id + PUBLISHCACHEKEY;
        HussarCacheUtil.evict((String)cacheName, (Object)cacheKey);
    }
}

