/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.DataFileService;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingCache;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="FileMappingServiceOnLineImpl")
@Conditional(value={ConditionUseSharedStorage.class})
public class FileMappingServiceOnLineImpl
implements FileMappingService {
    @Autowired
    @Qualifier(value="DataFileServiceOnLineImpl")
    private DataFileService dataFileService;
    @Autowired
    private FormDesignProperties formDesignProperties;
    @Autowired
    private StorageService storageService;
    @Autowired
    private ResourcePathService resourcePathService;

    @Override
    public Map<String, String> fileMappingCache() throws LcdpException {
        Map<String, String> fileMappingCache = FileMappingCache.getFileMappingCache();
        if (ToolUtil.isEmpty(fileMappingCache)) {
            fileMappingCache = this.dataFileService.getFileMapping();
            FileMappingCache.updateFileMappingCache(fileMappingCache);
        }
        return fileMappingCache;
    }

    @Override
    public boolean isFileExist(String fileId) {
        if (fileId != null) {
            return (Boolean)this.storageService.existsByUuid(CategoryEnum.META, fileId).getData();
        }
        return false;
    }

    @Override
    public void fileMappingCacheEvict() {
        FileMappingCache.fileMappingCacheEvict();
    }

    @Override
    public String getFilePathById(String id) {
        if ("#".equals(id)) {
            return this.resourcePathService.projectStoreCode(new String[0]).getRemotePath();
        }
        return (String)this.storageService.getFilePathByUuid(CategoryEnum.META, id).getData();
    }

    @Override
    public String getMetaPath(String id) {
        if ("#".equals(id)) {
            return ToolUtil.pathFomatterByOS(this.resourcePathService.projectStoreCode(new String[0]).getRemotePath());
        }
        return ToolUtil.pathFomatterByOS((String)this.storageService.getFilePathByUuid(CategoryEnum.META, id).getData());
    }

    @Override
    public String getDataPath(String id) {
        if ("#".equals(id)) {
            return ToolUtil.pathFomatterByOS(this.resourcePathService.projectStoreCode(new String[0]).getRemotePath());
        }
        String metaPath = this.getMetaPath(id);
        return metaPath.substring(0, metaPath.lastIndexOf(".meta"));
    }

    @Override
    public String getFormatPath(String id) {
        String dataPath = this.getMetaPath(id);
        String remotePrefix = "dict".equalsIgnoreCase(id) ? this.resourcePathService.projectStore(new String[0]).getRemotePath() : this.resourcePathService.projectStoreCode(new String[0]).getRemotePath();
        dataPath = "#".equals(id) ? "/" : FileUtil.posixPath("/", FileUtil.removePathPrefix(remotePrefix, dataPath));
        int location = (dataPath = dataPath.replace(".meta", "")).lastIndexOf("/");
        if (location != -1) {
            String name = dataPath.substring(location);
            int suffix = name.lastIndexOf(".");
            if (suffix != -1) {
                name = name.substring(0, suffix);
            }
            dataPath = dataPath.substring(0, location) + name;
        }
        return dataPath;
    }

    @Override
    public String getFormatParentPath(String id) {
        String fileFormatPath = this.getFormatPath(id);
        int location = fileFormatPath.lastIndexOf("/");
        if (location != -1) {
            fileFormatPath = fileFormatPath.substring(0, location);
        }
        return fileFormatPath;
    }

    @Override
    public String getImportPath(String id) {
        String fileFormatPath = this.getFormatPath(id);
        if (ToolUtil.isNotEmpty(fileFormatPath)) {
            fileFormatPath = FileUtil.posixPath(this.formDesignProperties.getFrontApiPath(), fileFormatPath.toLowerCase()).replace("/src", "@");
        }
        return this.dealPath(fileFormatPath);
    }

    @Override
    public String getMobileImportPath(String id) {
        String fileFormatPath = this.getFormatPath(id);
        if (ToolUtil.isNotEmpty(fileFormatPath)) {
            fileFormatPath = FileUtil.posixPath(this.formDesignProperties.getMobileFrontApiPath(), fileFormatPath.toLowerCase()).replace("/src", "@");
        }
        return this.dealPath(fileFormatPath);
    }

    private String dealPath(String path) {
        if (path.indexOf("api") > -1) {
            path = "#" + path.substring(path.indexOf("/api"));
        } else if (path.indexOf("pages") > -1) {
            path = "#" + path.substring(path.indexOf("/pages"));
        } else if (path.indexOf("views") > -1) {
            path = "#" + path.substring(path.indexOf("/views"));
        }
        return path;
    }

    @Override
    public String getFileName(String id) {
        String fileFormatPath = this.getFormatPath(id);
        int location = fileFormatPath.lastIndexOf("/");
        if (location != -1) {
            fileFormatPath = fileFormatPath.substring(location + 1);
        }
        return fileFormatPath;
    }

    @Override
    public String getCamelFileNameWithModule(String id) {
        String pagePath = this.getFormatPath(id);
        String[] paths = pagePath.split("[/\\\\]");
        StringBuilder pageNameWithModuleBuilder = new StringBuilder();
        for (String path : paths) {
            if ("".equals(path)) continue;
            pageNameWithModuleBuilder.append(ToolUtil.firstLetterToUpper(path));
        }
        return pageNameWithModuleBuilder.toString();
    }

    @Override
    public BaseFile getPageInfoById(String id) throws LcdpException {
        byte[] bytes;
        String metaPath = this.getMetaPath(id);
        if (ToolUtil.isNotEmpty(metaPath) && ToolUtil.isNotEmpty(bytes = (byte[])this.storageService.downloadByUuid(CategoryEnum.META, id).getData())) {
            return (BaseFile)JSON.parseObject((String)new String(bytes, StandardCharsets.UTF_8), BaseFile.class);
        }
        throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, metaPath);
    }

    @Override
    public JSONObject getJsonObjectById(String id) throws LcdpException {
        byte[] bytes;
        String metaPath = this.getMetaPath(id);
        if (ToolUtil.isNotEmpty(metaPath) && ToolUtil.isNotEmpty(bytes = (byte[])this.storageService.downloadByUuid(CategoryEnum.META, id).getData())) {
            return JSON.parseObject((String)new String(bytes, StandardCharsets.UTF_8));
        }
        throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, metaPath);
    }
}

