/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.constant.CommonModelMetaInfo;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.DataFileService;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingCache;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="FileMappingServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class FileMappingServiceImpl
implements FileMappingService {
    @Autowired
    @Qualifier(value="DataFileServiceImpl")
    private DataFileService dataFileService;
    @Autowired
    private ResourcePathService resourcePathService;
    @Autowired
    private FormDesignProperties formDesignProperties;

    @Override
    public Map<String, String> fileMappingCache() throws LcdpException {
        Map<String, String> fileMappingCache = FileMappingCache.getFileMappingCache();
        if (ToolUtil.isEmpty(fileMappingCache)) {
            fileMappingCache = this.dataFileService.getFileMapping();
            FileMappingCache.updateFileMappingCache(fileMappingCache);
        }
        return fileMappingCache;
    }

    @Override
    public boolean isFileExist(String fileId) throws LcdpException {
        Map<String, String> fileMapping = this.fileMappingCache();
        if (ToolUtil.isNotEmpty(fileMapping)) {
            return fileMapping.containsKey(fileId);
        }
        return false;
    }

    @Override
    public void fileMappingCacheEvict() {
        FileMappingCache.fileMappingCacheEvict();
    }

    @Override
    public String getFilePathById(String id) throws LcdpException {
        Map<String, String> fileMapping = this.fileMappingCache();
        String filePath = "";
        if (fileMapping != null) {
            filePath = fileMapping.get(id);
        }
        return filePath;
    }

    @Override
    public String getMetaPath(String id) throws LcdpException {
        if ("#".equals(id)) {
            return "";
        }
        String path = this.fileMappingCache().get(id);
        if (ToolUtil.isEmpty(id) || ToolUtil.isEmpty(path)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return path;
    }

    @Override
    public String getDataPath(String id) throws LcdpException {
        if ("#".equals(id)) {
            return "";
        }
        String path = this.getMetaPath(id).replace(".meta", "");
        if (ToolUtil.isEmpty(id) || ToolUtil.isEmpty(path)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return path;
    }

    @Override
    public String getFormatPath(String id) throws LcdpException {
        String dataPath = this.getDataPath(id);
        int location = (dataPath = dataPath.replace(File.separator, "/")).lastIndexOf("/");
        if (location != -1) {
            String name = dataPath.substring(location);
            int suffix = name.lastIndexOf(".");
            if (suffix != -1) {
                name = name.substring(0, suffix);
            }
            dataPath = dataPath.substring(0, location) + name;
        }
        return dataPath;
    }

    @Override
    public String getFormatParentPath(String id) throws LcdpException {
        String fileFormatPath = this.getFormatPath(id);
        int location = fileFormatPath.lastIndexOf("/");
        if (location != -1) {
            fileFormatPath = fileFormatPath.substring(0, location);
        }
        return fileFormatPath;
    }

    @Override
    public String getImportPath(String id) throws LcdpException {
        String fileFormatPath = this.getFormatPath(id);
        if (ToolUtil.isNotEmpty(fileFormatPath)) {
            fileFormatPath = FileUtil.posixPath(this.formDesignProperties.getFrontApiPath(), fileFormatPath.toLowerCase()).replace("/src", "@");
        }
        return this.dealPath(fileFormatPath);
    }

    @Override
    public String getMobileImportPath(String id) throws LcdpException {
        String fileFormatPath = this.getFormatPath(id);
        if (ToolUtil.isNotEmpty(fileFormatPath)) {
            fileFormatPath = FileUtil.posixPath(this.formDesignProperties.getMobileFrontApiPath(), fileFormatPath.toLowerCase()).replace("/src", "@");
        }
        return this.dealPath(fileFormatPath);
    }

    private String dealPath(String path) {
        if (path.indexOf("api") > -1) {
            path = "#" + path.substring(path.indexOf("/api"));
        } else if (path.indexOf("pages") > -1) {
            path = "#" + path.substring(path.indexOf("/pages"));
        } else if (path.indexOf("views") > -1) {
            path = "#" + path.substring(path.indexOf("/views"));
        }
        return path;
    }

    @Override
    public String getFileName(String id) throws LcdpException {
        String fileFormatPath = this.getFormatPath(id);
        int location = fileFormatPath.lastIndexOf("/");
        if (location != -1) {
            fileFormatPath = fileFormatPath.substring(location + 1);
        }
        return fileFormatPath;
    }

    @Override
    public String getCamelFileNameWithModule(String id) throws LcdpException {
        String pagePath = this.getFormatPath(id);
        String[] paths = pagePath.split("/");
        StringBuilder pageNameWithModuleBuilder = new StringBuilder();
        for (String path : paths) {
            if ("".equals(path)) continue;
            pageNameWithModuleBuilder.append(ToolUtil.firstLetterToUpper(path));
        }
        return pageNameWithModuleBuilder.toString();
    }

    @Override
    public BaseFile getPageInfoById(String id) throws LcdpException, IOException {
        File metaFile;
        String metaPath = this.getMetaPath(id);
        if (ToolUtil.isNotEmpty(metaPath) && (metaFile = new File(ToolUtil.pathFomatterByOS(this.formDesignProperties.getProjectAndCodePath() + metaPath))).exists()) {
            return (BaseFile)JSON.parseObject((String)FileUtils.readFileToString((File)metaFile, (String)"UTF-8"), BaseFile.class);
        }
        return null;
    }

    @Override
    public JSONObject getJsonObjectById(String id) throws LcdpException, IOException {
        File metaFile;
        String metaPath = this.getMetaPath(id);
        String parentPath = "";
        parentPath = CommonModelMetaInfo.isCommonModelTable(id) ? this.resourcePathService.projectStore(new String[0]).getLocalPath() : this.resourcePathService.projectStoreCode(new String[0]).getLocalPath();
        if (ToolUtil.isNotEmpty(metaPath) && (metaFile = new File(ToolUtil.pathFomatterByOS(parentPath + metaPath))).exists()) {
            return JSON.parseObject((String)FileUtils.readFileToString((File)metaFile, (String)"UTF-8"));
        }
        return null;
    }
}

