/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.annotation.ExceptionCatcher;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.DataFileService;
import com.jxdinfo.hussar.formdesign.common.file.ResourcePathService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="DataFileServiceImpl")
@Conditional(value={ConditionNotSharedStorage.class})
public class DataFileServiceImpl
implements DataFileService {
    private final ResourcePathService resourcePathService;
    private static final String cache = "speedFileMappingCache";

    public DataFileServiceImpl(ResourcePathService resourcePathService) {
        this.resourcePathService = resourcePathService;
    }

    @Override
    @ExceptionCatcher
    public Map<String, String> getFileMapping() throws LcdpException {
        HashMap<String, String> map = new HashMap<String, String>();
        File file = new File(this.resourcePathService.projectStoreCode(new String[0]).getLocalPath());
        File commonModelFile = new File(this.resourcePathService.projectStore(new String[0]).getLocalPath() + "/common_model");
        this.iteratorFile(file, map, file);
        this.iteratorFile(commonModelFile, map, commonModelFile);
        return map;
    }

    @Override
    public void fileMappingEvict() {
    }

    private void iteratorFile(File file, Map<String, String> fileMappingMap, File rootFile) throws LcdpException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File childFile : files) {
                        this.iteratorFile(childFile, fileMappingMap, rootFile);
                    }
                }
            } else if (file.getName().endsWith(".meta")) {
                BaseFile baseFile;
                String id = "";
                try {
                    baseFile = (BaseFile)JSONObject.parseObject((String)FileUtils.readFileToString((File)file, (String)"UTF-8"), BaseFile.class);
                    id = baseFile.getId();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new LcdpException(LcdpExceptionEnum.FILE_READ_FAIL, file.getAbsolutePath());
                }
                if (ToolUtil.isNotEmpty(id)) {
                    String relativePath = "common_model".equalsIgnoreCase(baseFile.getParentId()) ? "/common_model" + file.getAbsolutePath().replace(rootFile.getAbsolutePath(), "") : file.getAbsolutePath().replace(rootFile.getAbsolutePath(), "");
                    if (ToolUtil.isNotEmpty(fileMappingMap.get(id))) {
                        throw new LcdpException(LcdpExceptionEnum.SAME_FILE_ID, fileMappingMap.get(id) + "\n" + relativePath);
                    }
                    fileMappingMap.put(id, FileUtil.posixPath(relativePath));
                }
            }
        }
    }
}

