/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.file;

import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileMappingCache {
    private static final Map<String, String> fileMappingCache = new ConcurrentHashMap<String, String>();

    private FileMappingCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileMappingCacheEvict() {
        Map<String, String> map = fileMappingCache;
        synchronized (map) {
            fileMappingCache.clear();
        }
    }

    public static boolean isCacheEmpty() {
        return ToolUtil.isEmpty(fileMappingCache);
    }

    public static Map<String, String> getFileMappingCache() {
        HashMap<String, String> map = new HashMap<String, String>();
        FileMappingCache.deepClone(fileMappingCache, map);
        return map;
    }

    public static void updateFileMappingCache(Map<String, String> map) {
        FileMappingCache.deepClone(map, fileMappingCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deepClone(Map<String, String> fromMap, Map<String, String> toMap) {
        Map<String, String> map = fileMappingCache;
        synchronized (map) {
            toMap.clear();
            for (Map.Entry<String, String> entry : fromMap.entrySet()) {
                String key = entry.getKey();
                if (key == null || fromMap.get(key) == null) continue;
                toMap.put(key.toString(), fromMap.get(key));
            }
        }
    }
}

