/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.common.aspect;

import com.jxdinfo.hussar.formdesign.app.FormDesignAppInfo;
import com.jxdinfo.hussar.formdesign.common.annotation.StorageEnvironment;
import com.jxdinfo.hussar.formdesign.common.config.StorageContext;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignStorageProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.tenant.FormDesignTenantInfo;
import com.jxdinfo.hussar.formdesign.tenant.ITenant;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.expression.EnvironmentAccessor;
import org.springframework.core.env.Environment;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
public class StorageEnvironmentHelper
implements EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(StorageEnvironmentHelper.class);
    private static final TemplateParserContext PARSER_CONTEXT = new TemplateParserContext("${", "}");
    public static final int ASPECT_ORDER_CLASS = 0;
    public static final int ASPECT_ORDER_METHOD = 1;
    private final StorageContext storageContext;
    private final FormDesignStorageProperties storageProperties;
    private final StorageExpressionRoot rootObject;

    @Autowired
    public StorageEnvironmentHelper(StorageContext storageContext, FormDesignStorageProperties storageProperties) {
        this.storageContext = storageContext;
        this.storageProperties = storageProperties;
        this.rootObject = new StorageExpressionRoot(storageProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object wrapTarget(ProceedingJoinPoint joinPoint, StorageEnvironment annotation) throws Throwable {
        Object object;
        String from;
        block4: {
            String method = joinPoint.getTarget().getClass().getSimpleName() + "." + joinPoint.getSignature().getName();
            from = this.storageContext.getOverwrite("storageWorkspace");
            String to = this.resolveWorkspace(annotation);
            try {
                if (this.storageProperties.isDebug()) {
                    logger.info("==> enter storage: {} (@{} from {})", new Object[]{to, method, from});
                }
                this.storageContext.setWorkspace(to);
                object = joinPoint.proceed();
                if (!this.storageProperties.isDebug()) break block4;
            }
            catch (Throwable throwable) {
                if (this.storageProperties.isDebug()) {
                    logger.info("<== leave storage: {} (@{} back to {})", new Object[]{to, method, from});
                }
                this.storageContext.setOverwrite("storageWorkspace", from);
                throw throwable;
            }
            logger.info("<== leave storage: {} (@{} back to {})", new Object[]{to, method, from});
        }
        this.storageContext.setOverwrite("storageWorkspace", from);
        return object;
    }

    private String resolveWorkspace(StorageEnvironment annotation) {
        String expression = StringUtils.defaultString((String)annotation.value(), (String)"${appId}");
        return this.evaluate(expression);
    }

    private String evaluate(String expression) {
        Expression el = new SpelExpressionParser().parseExpression(expression, (ParserContext)PARSER_CONTEXT);
        StandardEvaluationContext context = new StandardEvaluationContext((Object)this.rootObject);
        context.addPropertyAccessor((PropertyAccessor)new EnvironmentAccessor());
        return (String)el.getValue((EvaluationContext)context, String.class);
    }

    public void setEnvironment(Environment environment) {
        this.rootObject.setEnvironment(environment);
    }

    private static class StorageExpressionRoot {
        private Environment environment;
        private FormDesignStorageProperties properties;

        public StorageExpressionRoot(FormDesignStorageProperties properties) {
            this.properties = properties;
        }

        public String getAppId() {
            return AppContextUtil.getAppId();
        }

        public String getAppTenantCode() {
            return Optional.ofNullable(AppContextUtil.getAppInfo()).map(FormDesignAppInfo::getTenantId).orElse(null);
        }

        public FormDesignAppInfo getApp() {
            return AppContextUtil.getAppInfo();
        }

        public FormDesignTenantInfo getAppTenant() {
            String tenantCode = this.getAppTenantCode();
            if (tenantCode == null) {
                return null;
            }
            ITenant tenantService = SpringUtil.getBean(ITenant.class);
            return tenantService.getTenantInfoByCode(tenantCode);
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public Environment getEnvironment() {
            return this.environment;
        }

        public FormDesignStorageProperties getProperties() {
            return this.properties;
        }

        public void setProperties(FormDesignStorageProperties properties) {
            this.properties = properties;
        }
    }
}

