/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.collaboration.lock.service.impl;

import com.jxdinfo.hussar.formdesign.collaboration.lock.model.EditorInformationPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.EditorInformationService;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.storage.client.service.RecordService;
import com.jxdinfo.hussar.formdesign.storage.common.model.RecordQuery;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EditorInformationServiceImpl
implements EditorInformationService {
    private final RecordService recordService;

    @Autowired
    public EditorInformationServiceImpl(RecordService recordService) {
        this.recordService = recordService;
    }

    @Override
    public StorageResult<String> add(EditorInformationPO editorPO) {
        return this.recordService.put(EditorInformationPO.class, (Object)editorPO);
    }

    @Override
    public StorageResult<EditorInformationPO> get(String id) {
        return this.recordService.get(EditorInformationPO.class, id);
    }

    @Override
    public StorageResult<List<String>> delAll(Long userId) {
        RecordQuery query = RecordQuery.builder().equal("editorId", (Object)userId).build();
        return this.recordService.deleteMatches(EditorInformationPO.class, query);
    }

    @Override
    public StorageResult<List<String>> delList(List<String> list, Long userId) {
        StorageResult listStorageResult = this.recordService.get(EditorInformationPO.class, list);
        List data = (List)listStorageResult.getData();
        ArrayList<String> delIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)data)) {
            for (EditorInformationPO datum : data) {
                if (!userId.equals(datum.getEditorId())) continue;
                delIds.add(datum.getId());
            }
        }
        return this.recordService.delete(EditorInformationPO.class, delIds);
    }
}

