/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.collaboration.lock.controller;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/IndexStorage"})
public class IndexStorageLockController {
    @Autowired
    IndexStorageLockService indexStorageLockService;

    @GetMapping(value={"/locks"})
    @ResponseBody
    public FormDesignResponse<List<StorageLockPO>> getLocksByProjectID() {
        FormDesignResponse response = new FormDesignResponse();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isEmpty((Object)user)) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return response;
        }
        StorageResult<List<StorageLockPO>> result = this.indexStorageLockService.getLocksByUserID(user.getId());
        this.setResponseByResult(result, response);
        return response;
    }

    @PostMapping(value={"/lock"})
    public FormDesignResponse<String> addLock(@RequestBody StorageLockPO lockPO) {
        FormDesignResponse response = new FormDesignResponse();
        boolean paramIsComplete = lockPO == null || ToolUtil.isEmpty((Object)lockPO.getId());
        SecurityUser user = BaseSecurityUtil.getUser();
        if (paramIsComplete) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570");
            return response;
        }
        if (ToolUtil.isEmpty((Object)user)) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return response;
        }
        StorageResult<StorageLockPO> oldLock = this.indexStorageLockService.getOneLockByResource(String.valueOf(user.getId()));
        response.setErrorMsg("\u52a0\u9501\u6210\u529f\uff01");
        if (oldLock.getCode() == 200 && ToolUtil.isEmpty((Object)oldLock.getData())) {
            StorageResult<String> result = this.indexStorageLockService.addLock(lockPO);
            return this.setResponseByResult(result, response);
        }
        if (lockPO.getUserId().equals(((StorageLockPO)oldLock.getData()).getUserId())) {
            response.setData((Object)lockPO.getId());
            return response;
        }
        response.setErrorMsg(((StorageLockPO)oldLock.getData()).getUserName() + "\u6b63\u5728\u5360\u7528");
        response.setData((Object)((StorageLockPO)oldLock.getData()).getUserName());
        response.setErrorCode(403);
        return response;
    }

    @PostMapping(value={"/unLock"})
    public FormDesignResponse<Boolean> deleteLock(@RequestBody StorageLockPO lockPO) {
        FormDesignResponse response = new FormDesignResponse();
        boolean paramsAreComplete = ToolUtil.isEmpty((Object)lockPO.getId());
        SecurityUser user = BaseSecurityUtil.getUser();
        if (paramsAreComplete) {
            response.setErrorCode(400);
            response.setData((Object)false);
            response.setErrorMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570");
            return response;
        }
        if (ToolUtil.isEmpty((Object)user)) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return response;
        }
        lockPO.setUserId(user.getId());
        lockPO.setUserName(user.getName());
        StorageResult<List<String>> result = this.indexStorageLockService.deleteLock(lockPO.getId());
        response.setErrorMsg("\u89e3\u9501\u6210\u529f\uff01");
        this.setResponseByResult(result, response);
        return response;
    }

    @GetMapping(value={"/getLock"})
    public FormDesignResponse<StorageLockPO> getOneLockByResource(@RequestParam(value="id") Long id) {
        FormDesignResponse response = new FormDesignResponse();
        boolean paramsAreComplete = ToolUtil.isEmpty((Object)id);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (paramsAreComplete) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570");
            return response;
        }
        if (ToolUtil.isEmpty((Object)user)) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return response;
        }
        StorageResult<StorageLockPO> result = this.indexStorageLockService.getOneLockByResource(String.valueOf(id));
        if (result.getCode() == 200) {
            StorageLockPO lockPO = (StorageLockPO)result.getData();
            if (ToolUtil.isNotEmpty((Object)lockPO) && !user.getId().equals(((StorageLockPO)result.getData()).getUserId())) {
                response.setErrorCode(400);
                response.setErrorMsg(((StorageLockPO)result.getData()).getUserName() + "\u6b63\u5728\u5360\u7528\uff01");
            }
            response.setData(result.getData());
        } else {
            response.setErrorCode(result.getCode());
            response.setErrorMsg(result.getMsg());
        }
        return response;
    }

    private FormDesignResponse setResponseByResult(StorageResult result, FormDesignResponse response) {
        if (result.getCode() == 200) {
            response.setData(result.getData());
        } else {
            response.setErrorCode(result.getCode());
            response.setErrorMsg(result.getMsg());
        }
        return response;
    }
}

