/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.collaboration.lock.controller;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.collaboration.lock.model.EditorInformationPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.EditorInformationService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formdesign/EditorInfo"})
public class EditorInformationController {
    @Autowired
    EditorInformationService editorInformationService;

    @PostMapping(value={"/add"})
    public FormDesignResponse<String> add(@RequestBody EditorInformationPO editorPO) {
        FormDesignResponse response = new FormDesignResponse();
        boolean paramIsComplete = editorPO == null || ToolUtil.isEmpty((Object)editorPO.getId());
        SecurityUser user = BaseSecurityUtil.getUser();
        if (paramIsComplete) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570");
            return response;
        }
        if (ToolUtil.isEmpty((Object)user)) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return response;
        }
        editorPO.setEditorId(user.getId());
        editorPO.setEditorName(user.getName());
        StorageResult<String> result = this.editorInformationService.add(editorPO);
        this.setResponseByResult(result, response);
        return response;
    }

    @GetMapping(value={"/get"})
    public FormDesignResponse<EditorInformationPO> get(@RequestParam(value="id") String id) {
        FormDesignResponse response = new FormDesignResponse();
        boolean paramsAreComplete = ToolUtil.isEmpty((Object)id);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (paramsAreComplete) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570");
            return response;
        }
        if (ToolUtil.isEmpty((Object)user)) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return response;
        }
        StorageResult<EditorInformationPO> result = this.editorInformationService.get(id);
        if (result.getCode() == 200) {
            EditorInformationPO po = (EditorInformationPO)result.getData();
            if (!ToolUtil.isNotEmpty((Object)po)) {
                return response;
            }
            response.setData((Object)po);
            if (!user.getId().equals(((EditorInformationPO)result.getData()).getEditorId())) {
                response.setErrorCode(405);
                response.setErrorMsg(((EditorInformationPO)result.getData()).getEditorName() + "\u6b63\u5728\u7f16\u8f91\uff0c\u8bf7\u7ebf\u4e0b\u6c9f\u901a\u540e\u786e\u8ba4\u7f16\u8f91");
                return response;
            }
        }
        return response;
    }

    @GetMapping(value={"/delAll"})
    public FormDesignResponse<Boolean> delAll() {
        FormDesignResponse response = new FormDesignResponse();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isEmpty((Object)user)) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return response;
        }
        StorageResult<List<String>> result = this.editorInformationService.delAll(user.getId());
        this.setResponseByResult(result, response);
        return response;
    }

    @PostMapping(value={"/delList"})
    public FormDesignResponse<Boolean> delList(@RequestBody String[] ids) {
        FormDesignResponse response = new FormDesignResponse();
        boolean paramsAreComplete = ToolUtil.isEmpty((Object)ids);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (paramsAreComplete) {
            response.setErrorCode(400);
            response.setData((Object)false);
            response.setErrorMsg("\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570");
            return response;
        }
        if (ToolUtil.isEmpty((Object)user)) {
            response.setErrorCode(400);
            response.setData(null);
            response.setErrorMsg("\u8bf7\u5148\u767b\u5f55");
            return response;
        }
        StorageResult<List<String>> result = this.editorInformationService.delList(Arrays.asList(ids), user.getId());
        this.setResponseByResult(result, response);
        return response;
    }

    private void setResponseByResult(StorageResult result, FormDesignResponse response) {
        if (result.getCode() == 200) {
            response.setData(result.getData());
        } else {
            response.setErrorCode(result.getCode());
            response.setErrorMsg(result.getMsg());
        }
    }
}

