/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.collaboration.lock.service.impl;

import com.jxdinfo.hussar.formdesign.collaboration.lock.model.StorageLockPO;
import com.jxdinfo.hussar.formdesign.collaboration.lock.service.IndexStorageLockService;
import com.jxdinfo.hussar.formdesign.storage.client.service.RecordService;
import com.jxdinfo.hussar.formdesign.storage.common.model.RecordQuery;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IndexStorageLockServiceImpl
implements IndexStorageLockService {
    private final RecordService recordService;

    @Autowired
    public IndexStorageLockServiceImpl(RecordService recordService) {
        this.recordService = recordService;
    }

    @Override
    public StorageResult<List<StorageLockPO>> getLocksByProjectID(String projectId, String userId) {
        RecordQuery query = RecordQuery.builder().equal("projectId", (Object)projectId).equal("userId", (Object)userId).build();
        return this.recordService.getMatches(StorageLockPO.class, query);
    }

    @Override
    public StorageResult<List<StorageLockPO>> getLocksByUserID(Long userId) {
        RecordQuery query = RecordQuery.builder().equal("userId", (Object)userId).build();
        return this.recordService.getMatches(StorageLockPO.class, query);
    }

    @Override
    public StorageResult<String> addLock(StorageLockPO lockPO) {
        return this.recordService.put(StorageLockPO.class, (Object)lockPO);
    }

    @Override
    public StorageResult<List<String>> deleteLock(String lockID) {
        return this.recordService.delete(StorageLockPO.class, Collections.singletonList(lockID));
    }

    @Override
    public StorageResult<StorageLockPO> getOneLockByResource(String id) {
        return this.recordService.get(StorageLockPO.class, id);
    }
}

