/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.dbimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixBoService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.ModelBeanUtil;
import com.jxdinfo.hussar.formdesign.back.provider.DataModelProvider;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileCode;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.service.SysMidFileCodeService;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.PublishLogUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.helper.FileDataBaseHelper;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.WorkflowService;
import com.jxdinfo.hussar.formdesign.publish.model.WorkGenCodeResult;
import com.jxdinfo.hussar.formdesign.publish.service.BackPublishService;
import com.jxdinfo.hussar.formdesign.publish.service.WorkFlowPublishService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.WorkFlow;
import com.jxdinfo.hussar.workflow.engine.flowmodel.BpmNodeTypeUtil;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowAssignment;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowFunctionConfig;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowModel;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowObject;
import com.jxdinfo.hussar.workflow.engine.flowmodel.FlowRecipients;
import com.jxdinfo.hussar.workflow.engine.flowmodel.JudgeBackCondition;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import com.jxdinfo.hussar.workflow.manage.engine.service.PublicProcessApiService;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service(value="WorkFlowPublishServiceDBImpl")
@Conditional(value={ConditionDataBaseStorage.class})
public class WorkFlowPublishServiceDBImpl
implements WorkFlowPublishService {
    @Resource
    private WorkflowService workflowService;
    @Resource
    private FileMappingService fileMappingService;
    @Resource
    private GodAxeModelService godAxeModelService;
    @Resource
    private BackPublishService backPublishService;
    @Resource
    protected FormDesignProperties formDesignProperties;
    @Autowired
    private PublicProcessApiService publicProcessApiService;
    @Resource
    private PathStrategyService pathStrategy;
    @Autowired(required=false)
    private IHussarBaseAppMixBoService hussarBaseAppMixBoService;
    @Resource
    private SysMidFileCodeService sysMidFileCodeService;
    protected FileDataBaseHelper fileDataBaseHelper = (FileDataBaseHelper)SpringContextHolder.getBean(FileDataBaseHelper.class);
    private static final Pattern REGEX = Pattern.compile("@\\{(?:[^}]+|}(?!@))*}@");

    @Override
    public FormDesignResponse<Object> publish(String id, boolean isOverride) throws IOException, LcdpException, CloneNotSupportedException {
        if (VfgModeTool.isRemote()) {
            PublishLogUtil.writePublishToEnvStartLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41");
        }
        WorkflowInfo workflowInfo = (WorkflowInfo)this.workflowService.get(id);
        Map environmentType = (Map)this.publicProcessApiService.getEnvironmentType().getData();
        if (!"dev".equals(environmentType.get("environmentType")) && !this.formDesignProperties.isOfflineLr() && this.needGenerateCode(workflowInfo)) {
            FormDesignResponse speedCodeResponse = new FormDesignResponse();
            speedCodeResponse.setErrorMsg("\u53d1\u5e03\u65b0\u7248\u672c\u5931\u8d25\uff0c\u672c\u6b21\u53d1\u5e03\u65b0\u7248\u672c\u9700\u8981\u751f\u6210\u4ee3\u7801\uff0c\u975e\u5f00\u53d1\u73af\u5883\u7981\u6b62\u751f\u6210\u4ee3\u7801\u3002");
            speedCodeResponse.setErrorCode(-1);
            if (VfgModeTool.isRemote()) {
                PublishLogUtil.writePublishErrorLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u53d1\u5e03\u65b0\u7248\u672c\u5931\u8d25\uff0c\u672c\u6b21\u53d1\u5e03\u65b0\u7248\u672c\u9700\u8981\u751f\u6210\u4ee3\u7801\uff0c\u975e\u5f00\u53d1\u73af\u5883\u7981\u6b62\u751f\u6210\u4ee3\u7801\u3002");
                PublishLogUtil.writePublishFailLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41");
            }
            return speedCodeResponse;
        }
        if (HussarUtils.isNotEmpty((Object)workflowInfo.getProcessTag())) {
            ApiResponse response = this.godAxeModelService.checkOrganProcessPublishState(workflowInfo.getIdentity(), null);
            if (!response.isSuccess()) {
                return FormDesignResponse.fail(null, (String)response.getMsg());
            }
            if (response.getData() != null && response.getData() instanceof Integer && (14162 == (Integer)response.getData() || 14161 == (Integer)response.getData())) {
                return FormDesignResponse.fail(null, (String)response.getMsg());
            }
        }
        this.bindWorkFlowDataModel(workflowInfo);
        String modelId = "";
        if (ToolUtil.isNotEmpty((Object)workflowInfo.getRelateFiles())) {
            for (Map.Entry set : workflowInfo.getRelateFiles().entrySet()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", set.getKey());
                params.put("publishIds", "WebPage");
                params.put("identity", workflowInfo.getIdentity());
                params.put("isCompile", Boolean.FALSE);
                modelId = (String)set.getKey();
                this.backPublishService.sync(params);
                this.backPublishService.publishBackCode(params);
            }
        }
        String tenantId = BaseSecurityUtil.getUser().getStringTenantId();
        if (HussarUtils.isNotEmpty((Object)workflowInfo.getProcessTag())) {
            return this.publishDeptProcess(id, tenantId, workflowInfo, modelId, workflowInfo.getProcessTag(), workflowInfo.getProcessTagName(), workflowInfo.getId());
        }
        return this.publish(id, tenantId, workflowInfo, modelId, isOverride);
    }

    @Override
    public FormDesignResponse<Object> publishDeptProcess(String newId, String organId, String organName, String sourceWorkflowId) throws IOException, LcdpException, CloneNotSupportedException {
        WorkflowInfo workflowInfo = (WorkflowInfo)this.workflowService.get(newId);
        Map environmentType = (Map)this.publicProcessApiService.getEnvironmentType().getData();
        if (!"dev".equals(environmentType.get("environmentType")) && !this.formDesignProperties.isOfflineLr() && this.needGenerateCode(workflowInfo)) {
            FormDesignResponse speedCodeResponse = new FormDesignResponse();
            speedCodeResponse.setErrorMsg("\u53d1\u5e03\u65b0\u7248\u672c\u5931\u8d25\uff0c\u672c\u6b21\u53d1\u5e03\u65b0\u7248\u672c\u9700\u8981\u751f\u6210\u4ee3\u7801\uff0c\u975e\u5f00\u53d1\u73af\u5883\u7981\u6b62\u751f\u6210\u4ee3\u7801\u3002");
            speedCodeResponse.setErrorCode(-1);
            return speedCodeResponse;
        }
        this.bindWorkFlowDataModel(workflowInfo);
        String modelId = "";
        if (ToolUtil.isNotEmpty((Object)workflowInfo.getRelateFiles())) {
            for (Map.Entry set : workflowInfo.getRelateFiles().entrySet()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", set.getKey());
                params.put("publishIds", "WebPage");
                params.put("identity", workflowInfo.getIdentity());
                modelId = (String)set.getKey();
                this.backPublishService.sync(params);
                this.backPublishService.publishBackCode(params);
            }
        }
        String tenantId = BaseSecurityUtil.getUser().getStringTenantId();
        return this.publishDeptProcess(newId, tenantId, workflowInfo, modelId, organId, organName, sourceWorkflowId);
    }

    private boolean needGenerateCode(WorkflowInfo workflowInfo) {
        FlowModel flowModel = (FlowModel)JSON.parseObject((String)workflowInfo.getData(), FlowModel.class);
        if (HussarUtils.isNotEmpty((Object)flowModel.getProps().getUseVariables())) {
            return true;
        }
        for (FlowObject flowObject : flowModel.getSlots().getElement()) {
            if (BpmNodeTypeUtil.isCallActivity((String)flowObject.getName()) && flowObject.getProps().getCallActivityTable() != null && HussarUtils.isNotEmpty((Object)flowObject.getProps().getCallActivityTable().getTableId())) {
                return true;
            }
            if (BpmNodeTypeUtil.isUserTask((String)flowObject.getName())) {
                FlowRecipients flowRecipients;
                if (HussarUtils.isNotEmpty((Object)flowObject.getProps().getUseVariables())) {
                    return true;
                }
                HashSet<String> functionIds = new HashSet<String>();
                FlowAssignment flowAssignment = flowObject.getProps().getFlowAssignment();
                if (ToolUtil.isNotEmpty((Object)flowAssignment)) {
                    this.getFunctionIds(flowAssignment.getDefaultBackCondtion(), functionIds);
                    if (ToolUtil.isNotEmpty((Object)flowAssignment.getJudgeBackCondition())) {
                        for (Object judgeBackCondition : flowAssignment.getJudgeBackCondition()) {
                            this.getFunctionIds(judgeBackCondition.getJudgeSpellCondition(), functionIds);
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)(flowRecipients = flowObject.getProps().getFlowRecipients()))) {
                    this.getFunctionIds(flowRecipients.getDefaultCcCondtion(), functionIds);
                    if (ToolUtil.isNotEmpty((Object)flowRecipients.getJudgeCcCondition())) {
                        Object judgeBackCondition;
                        judgeBackCondition = flowRecipients.getJudgeCcCondition().iterator();
                        while (judgeBackCondition.hasNext()) {
                            JudgeBackCondition judgeBackCondition2 = (JudgeBackCondition)judgeBackCondition.next();
                            this.getFunctionIds(judgeBackCondition2.getJudgeSpellCondition(), functionIds);
                        }
                    }
                }
                List flowFunctionConfigs = flowObject.getProps().getFlowFunctionConfig();
                ArrayList functionUserVariables = new ArrayList();
                if (ToolUtil.isNotEmpty((Object)flowFunctionConfigs)) {
                    for (FlowFunctionConfig flowFunctionConfig : flowFunctionConfigs) {
                        if (!functionIds.contains(flowFunctionConfig.getId()) || !ToolUtil.isNotEmpty((Object)flowFunctionConfig.getUseVariables())) continue;
                        functionUserVariables.addAll(flowFunctionConfig.getUseVariables());
                    }
                }
                if (!functionUserVariables.isEmpty()) {
                    return true;
                }
            }
            if (!BpmNodeTypeUtil.isSubProcess((String)flowObject.getName())) continue;
            List subFlowObjects = flowObject.getSlots().getElement();
            for (FlowObject object : subFlowObjects) {
                FlowRecipients flowRecipients;
                if (!BpmNodeTypeUtil.isUserTask((String)object.getName())) continue;
                if (HussarUtils.isNotEmpty((Object)object.getProps().getUseVariables())) {
                    return true;
                }
                HashSet<String> functionIds = new HashSet<String>();
                FlowAssignment flowAssignment = object.getProps().getFlowAssignment();
                if (ToolUtil.isNotEmpty((Object)flowAssignment)) {
                    this.getFunctionIds(flowAssignment.getDefaultBackCondtion(), functionIds);
                    if (ToolUtil.isNotEmpty((Object)flowAssignment.getJudgeBackCondition())) {
                        for (Object judgeBackCondition : flowAssignment.getJudgeBackCondition()) {
                            this.getFunctionIds(judgeBackCondition.getJudgeSpellCondition(), functionIds);
                        }
                    }
                }
                if (ToolUtil.isNotEmpty((Object)(flowRecipients = object.getProps().getFlowRecipients()))) {
                    this.getFunctionIds(flowRecipients.getDefaultCcCondtion(), functionIds);
                    if (ToolUtil.isNotEmpty((Object)flowRecipients.getJudgeCcCondition())) {
                        Object judgeBackCondition;
                        judgeBackCondition = flowRecipients.getJudgeCcCondition().iterator();
                        while (judgeBackCondition.hasNext()) {
                            JudgeBackCondition judgeBackCondition3 = (JudgeBackCondition)judgeBackCondition.next();
                            this.getFunctionIds(judgeBackCondition3.getJudgeSpellCondition(), functionIds);
                        }
                    }
                }
                List flowFunctionConfigs = object.getProps().getFlowFunctionConfig();
                ArrayList functionUserVariables = new ArrayList();
                if (ToolUtil.isNotEmpty((Object)flowFunctionConfigs)) {
                    for (FlowFunctionConfig flowFunctionConfig : flowFunctionConfigs) {
                        if (!functionIds.contains(flowFunctionConfig.getId()) || !ToolUtil.isNotEmpty((Object)flowFunctionConfig.getUseVariables())) continue;
                        functionUserVariables.addAll(flowFunctionConfig.getUseVariables());
                    }
                }
                if (functionUserVariables.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void getFunctionIds(String assignee, Set<String> functionsIds) {
        if (HussarUtils.isNotEmpty((Object)assignee) && assignee.contains("@")) {
            Matcher matcher = REGEX.matcher(assignee);
            while (matcher.find()) {
                functionsIds.add(matcher.group().substring(2, matcher.group().length() - 2));
            }
        }
    }

    private FormDesignResponse<Object> publish(String id, String tenantId, WorkflowInfo workflowInfo, String modelId, boolean isOverride) throws IOException, LcdpException {
        List result;
        DataModelProvider dataModelProvider;
        String processDefKey;
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        String oldVersion = null;
        WorkflowInfo oldWorkflowInfo = (WorkflowInfo)this.workflowService.get(workflowInfo.getId());
        if (oldWorkflowInfo != null) {
            oldVersion = oldWorkflowInfo.getVersion();
        }
        workflowInfo.setVersion(oldVersion);
        ApiResponse obj = this.godAxeModelService.saveAndPublish(this.dealData(workflowInfo), tenantId, isOverride);
        if (obj.isSuccess()) {
            processDefKey = obj.getMsg();
            String version = processDefKey.split(":")[1];
            workflowInfo.setVersion(version);
            String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
            String path = this.getDataPath(workflowInfo.getId());
            SysMidFileCode sysMidFileCode = this.sysMidFileCodeService.getMainFile(workflowInfo.getId());
            if (HussarUtils.isEmpty((Object)sysMidFileCode)) {
                SysMidFileCode mainResource = new SysMidFileCode();
                mainResource.setFileId(workflowInfo.getId());
                mainResource.setParentId(workflowInfo.getParentId());
                mainResource.setType(workflowInfo.getType());
                mainResource.setName(FileDataBaseHelper.getName((BaseFile)workflowInfo));
                mainResource.setMetaFlag("0");
                String fileData = HussarUtils.isEmpty((Object)workflowInfo.getData()) ? "" : workflowInfo.getData();
                mainResource.setData(fileData);
                SysMidFileCode metaResource = new SysMidFileCode();
                metaResource.setFileId(workflowInfo.getId());
                metaResource.setParentId(workflowInfo.getParentId());
                metaResource.setType(workflowInfo.getType());
                metaResource.setName(FileDataBaseHelper.getName((BaseFile)workflowInfo));
                metaResource.setMetaFlag("1");
                workflowInfo.setData(null);
                metaResource.setData(JSON.toJSONString((Object)workflowInfo));
                this.sysMidFileCodeService.save((Object)mainResource);
                if (!workflowInfo.getIsPublished()) {
                    workflowInfo.setIsPublished(true);
                }
                this.sysMidFileCodeService.save((Object)metaResource);
            } else {
                SysMidFileCode mainFile = this.sysMidFileCodeService.getMainFile(workflowInfo.getId());
                SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(workflowInfo.getId());
                if (HussarUtils.isEmpty((Object)mainFile)) {
                    throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
                }
                boolean needRename = this.checkRename(workflowInfo, (WorkflowInfo)JSON.parseObject((String)metaFile.getData(), WorkflowInfo.class));
                mainFile.setData(workflowInfo.getData());
                workflowInfo.setData(null);
                metaFile.setData(JSON.toJSONString((Object)workflowInfo));
                if (needRename) {
                    mainFile.setName(FileDataBaseHelper.getName((BaseFile)workflowInfo));
                    metaFile.setName(FileDataBaseHelper.getName((BaseFile)workflowInfo));
                }
                this.sysMidFileCodeService.updateById((Object)mainFile);
                this.sysMidFileCodeService.updateById((Object)metaFile);
            }
        } else {
            if (obj.getCode() == 10010) {
                speedCodeResponse.setErrorMsg(obj.getMsg());
                speedCodeResponse.setErrorCode(obj.getCode());
            } else {
                speedCodeResponse.setErrorMsg("\u4fdd\u5b58\u5e76\u53d1\u5e03\u65f6\u51fa\u9519\uff1a" + obj.getMsg());
                speedCodeResponse.setErrorCode(500);
            }
            if (VfgModeTool.isRemote()) {
                PublishLogUtil.writePublishErrorLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)speedCodeResponse.getErrorMsg());
                PublishLogUtil.writePublishFailLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41");
            }
            return speedCodeResponse;
        }
        if (ToolUtil.isNotEmpty((Object)modelId)) {
            dataModelProvider = ModelProvideAdapter.adaptor((String)modelId);
        } else if (!((FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class)).isLocalUnReset() && !((FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class)).isOfflineLr()) {
            dataModelProvider = ModelBeanUtil.getModelProviderBean((String)"MYSQL");
        } else {
            if (VfgModeTool.isRemote()) {
                PublishLogUtil.writePublishErrorLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u89e3\u6790\u5f15\u64ce\u6682\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u53d8\u91cf");
                PublishLogUtil.writePublishFailLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41");
            }
            return speedCodeResponse;
        }
        try {
            result = dataModelProvider.visitorGeneration(processDefKey, workflowInfo.geteName(), this.fileMappingService.getFormatPath(workflowInfo.getParentId()), modelId, workflowInfo.getId(), oldVersion, workflowInfo.getProcessTag(), workflowInfo.getProcessTag());
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        if (result == null) {
            if (VfgModeTool.isRemote()) {
                PublishLogUtil.writePublishErrorLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41\u751f\u6210\u4ee3\u7801\u65f6\u51fa\u9519\uff1a\u5b58\u5728\u53d8\u91cf\u5173\u8054\u5f02\u5e38\u7684\u6570\u636e\u6e90");
                PublishLogUtil.writePublishFailLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41");
            }
            speedCodeResponse.setErrorMsg("\u5de5\u4f5c\u6d41\u751f\u6210\u4ee3\u7801\u65f6\u51fa\u9519\uff1a\u5b58\u5728\u53d8\u91cf\u5173\u8054\u5f02\u5e38\u7684\u6570\u636e\u6e90");
            speedCodeResponse.setErrorCode(500);
            return speedCodeResponse;
        }
        List<WorkGenCodeResult> genCodeResult = this.backPublishService.publishBpmActivityVisitorCode(result, workflowInfo, workflowInfo.getId());
        speedCodeResponse.setData(genCodeResult);
        if (VfgModeTool.isRemote()) {
            PublishLogUtil.writePublishSuccessLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41", (String)"2");
        }
        return speedCodeResponse;
    }

    private FormDesignResponse<Object> publishDeptProcess(String id, String tenantId, WorkflowInfo workflowInfo, String modelId, String organId, String organName, String sourceWorkflowId) throws IOException, LcdpException {
        List result;
        DataModelProvider dataModelProvider;
        String processDefKey;
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        String oldVersion = null;
        WorkflowInfo sourceWorkflowInfo = (WorkflowInfo)this.workflowService.get(sourceWorkflowId);
        if (sourceWorkflowInfo != null) {
            oldVersion = sourceWorkflowInfo.getVersion();
        }
        workflowInfo.setProcessTag(organId);
        workflowInfo.setProcessTagName(organName);
        ApiResponse obj = this.godAxeModelService.saveWorkflowAboutOrgan(this.dealData(workflowInfo), null, null, null, null, true);
        if (obj.isSuccess()) {
            processDefKey = obj.getMsg();
            String version = processDefKey.split(":")[1];
            workflowInfo.setVersion(version);
            String rootPath = this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath();
            String path = this.getDataPath(workflowInfo.getId());
            SysMidFileCode sysMidFileCode = this.sysMidFileCodeService.getMainFile(workflowInfo.getId());
            if (HussarUtils.isEmpty((Object)sysMidFileCode)) {
                SysMidFileCode mainResource = new SysMidFileCode();
                mainResource.setFileId(workflowInfo.getId());
                mainResource.setParentId(workflowInfo.getParentId());
                mainResource.setType(workflowInfo.getType());
                mainResource.setName(FileDataBaseHelper.getName((BaseFile)workflowInfo));
                mainResource.setMetaFlag("0");
                String fileData = HussarUtils.isEmpty((Object)workflowInfo.getData()) ? "" : workflowInfo.getData();
                mainResource.setData(fileData);
                SysMidFileCode metaResource = new SysMidFileCode();
                metaResource.setFileId(workflowInfo.getId());
                metaResource.setParentId(workflowInfo.getParentId());
                metaResource.setType(workflowInfo.getType());
                metaResource.setName(FileDataBaseHelper.getName((BaseFile)workflowInfo));
                metaResource.setMetaFlag("1");
                workflowInfo.setData(null);
                metaResource.setData(JSON.toJSONString((Object)workflowInfo));
                this.sysMidFileCodeService.save((Object)mainResource);
                this.sysMidFileCodeService.save((Object)metaResource);
                if (!workflowInfo.getIsPublished()) {
                    workflowInfo.setIsPublished(true);
                }
            } else {
                SysMidFileCode mainFile = this.sysMidFileCodeService.getMainFile(workflowInfo.getId());
                SysMidFileCode metaFile = this.sysMidFileCodeService.getMetaFile(workflowInfo.getId());
                if (HussarUtils.isEmpty((Object)mainFile)) {
                    throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, workflowInfo.getId());
                }
                boolean needRename = this.checkRename(workflowInfo, (WorkflowInfo)JSON.parseObject((String)metaFile.getData(), WorkflowInfo.class));
                mainFile.setData(workflowInfo.getData());
                workflowInfo.setData(null);
                metaFile.setData(JSON.toJSONString((Object)workflowInfo));
                if (needRename) {
                    mainFile.setName(FileDataBaseHelper.getName((BaseFile)workflowInfo));
                    metaFile.setName(FileDataBaseHelper.getName((BaseFile)workflowInfo));
                }
                this.sysMidFileCodeService.updateById((Object)mainFile);
                this.sysMidFileCodeService.updateById((Object)metaFile);
            }
        } else {
            if (obj.getCode() == 10010) {
                speedCodeResponse.setErrorMsg(obj.getMsg());
                speedCodeResponse.setErrorCode(obj.getCode());
            } else {
                speedCodeResponse.setErrorMsg("\u4fdd\u5b58\u5e76\u53d1\u5e03\u65f6\u51fa\u9519\uff1a" + obj.getMsg());
                speedCodeResponse.setErrorCode(500);
            }
            if (VfgModeTool.isRemote()) {
                PublishLogUtil.writePublishErrorLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)speedCodeResponse.getErrorMsg());
                PublishLogUtil.writePublishFailLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41");
            }
            return speedCodeResponse;
        }
        if (ToolUtil.isNotEmpty((Object)modelId)) {
            dataModelProvider = ModelProvideAdapter.adaptor((String)modelId);
        } else if (!((FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class)).isLocalUnReset() && !((FormDesignProperties)SpringUtil.getBean(FormDesignProperties.class)).isOfflineLr()) {
            dataModelProvider = ModelBeanUtil.getModelProviderBean((String)"MYSQL");
        } else {
            if (VfgModeTool.isRemote()) {
                PublishLogUtil.writePublishErrorLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u89e3\u6790\u5f15\u64ce\u6682\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u53d8\u91cf");
                PublishLogUtil.writePublishFailLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41");
            }
            return speedCodeResponse;
        }
        try {
            assert (sourceWorkflowInfo != null);
            result = dataModelProvider.visitorGeneration(processDefKey, workflowInfo.geteName(), this.fileMappingService.getFormatPath(workflowInfo.getParentId()), modelId, workflowInfo.getId(), oldVersion, sourceWorkflowInfo.getProcessTag(), workflowInfo.getProcessTag());
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        if (result == null) {
            if (VfgModeTool.isRemote()) {
                PublishLogUtil.writePublishErrorLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41\u751f\u6210\u4ee3\u7801\u65f6\u51fa\u9519\uff1a\u5b58\u5728\u53d8\u91cf\u5173\u8054\u5f02\u5e38\u7684\u6570\u636e\u6e90");
                PublishLogUtil.writePublishFailLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41");
            }
            speedCodeResponse.setErrorMsg("\u5de5\u4f5c\u6d41\u751f\u6210\u4ee3\u7801\u65f6\u51fa\u9519\uff1a\u5b58\u5728\u53d8\u91cf\u5173\u8054\u5f02\u5e38\u7684\u6570\u636e\u6e90");
            speedCodeResponse.setErrorCode(500);
            return speedCodeResponse;
        }
        List<WorkGenCodeResult> genCodeResult = this.backPublishService.publishBpmActivityVisitorCode(result, workflowInfo, modelId);
        speedCodeResponse.setData(genCodeResult);
        if (VfgModeTool.isRemote()) {
            PublishLogUtil.writePublishSuccessLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u5de5\u4f5c\u6d41", (String)"2");
        }
        return speedCodeResponse;
    }

    private void bindWorkFlowDataModel(WorkflowInfo workflowInfo) {
        JSONObject processBinding;
        JSONObject props;
        JSONObject workFlowData = JSON.parseObject((String)workflowInfo.getData());
        if (ToolUtil.isNotEmpty((Object)workFlowData) && ToolUtil.isNotEmpty((Object)workFlowData.get((Object)"props")) && ToolUtil.isNotEmpty((Object)(props = workFlowData.getJSONObject("props"))) && ToolUtil.isNotEmpty((Object)props.get((Object)"processBinding")) && ToolUtil.isNotEmpty((Object)(processBinding = props.getJSONObject("processBinding")).getString("id"))) {
            HashMap<String, Integer> relateFiles = new HashMap<String, Integer>();
            relateFiles.put(processBinding.getString("id"), 1);
            workflowInfo.setRelateFiles(relateFiles);
        }
    }

    private void renameTwoWorkflowFile(WorkflowInfo workflowInfo, File file, File metaFile, String rootPath) throws LcdpException {
        File newFile;
        String parentPath = "";
        if (!ToolUtil.isEmpty((Object)workflowInfo.getParentId()) && !"#".equals(workflowInfo.getParentId())) {
            parentPath = this.getDataPath(workflowInfo.getParentId());
        }
        if (FileUtils.exists((File)(newFile = new File(rootPath + parentPath + File.separator + workflowInfo.geteName() + FileUtil.transFileSuffix((String)workflowInfo.getType()))))) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newFile.getAbsolutePath());
        }
        File newMetaFile = new File(newFile.getAbsolutePath() + ".meta");
        if (FileUtils.exists((File)newMetaFile)) {
            throw new LcdpException(LcdpExceptionEnum.FILE_ALREADY_EXIST, newMetaFile.getAbsolutePath());
        }
        this.fixName(file, newFile);
        this.fixName(metaFile, newMetaFile);
    }

    protected boolean fixName(File oldFile, File newFile) {
        return oldFile.renameTo(newFile);
    }

    String getDataPath(String id) throws LcdpException {
        return this.getMetaPath(id).replace(".meta", "");
    }

    private String getMetaPath(String id) throws LcdpException {
        if (ToolUtil.isEmpty((Object)id) || "#".equals(id)) {
            return "";
        }
        String parentPath = (String)this.fileMappingService.fileMappingCache().get(id);
        if (ToolUtil.isEmpty((Object)parentPath)) {
            throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_ID_FILE, id);
        }
        return ToolUtil.pathFomatterByOS((String)parentPath);
    }

    String relativeToAbsolute(String relativePath, String rootPath) {
        return (rootPath + File.separator + relativePath).replace("/", File.separator).replace("\\", File.separator).replace("//", File.separator).replace("\\\\", File.separator);
    }

    String addMeta(String absolutePath) {
        String real = absolutePath.replace("/", File.separator).replace("\\", File.separator);
        return real + ".meta";
    }

    private boolean checkRename(WorkflowInfo file, WorkflowInfo metaFile) throws LcdpException {
        boolean needRename;
        boolean bl = needRename = !HussarUtils.equals((Object)file.getName(), (Object)metaFile.getName());
        if (file instanceof WorkflowInfo) {
            WorkflowInfo workflowFile = file;
            WorkflowInfo workflowMetaFile = (WorkflowInfo)JSON.parseObject((String)JSON.toJSONString((Object)metaFile), WorkflowInfo.class);
            boolean bl2 = needRename = !HussarUtils.equals((Object)workflowFile.geteName(), (Object)workflowMetaFile.geteName());
            if (needRename) {
                this.godAxeModelService.updateWorkflowProcessKey(workflowFile.geteName(), workflowMetaFile.geteName());
            }
            file.setVersion(metaFile.getVersion());
        }
        return needRename;
    }

    void writeSingleFile(File file, JSONObject jsonObject) throws LcdpException {
        try {
            if (!FileUtils.exists((File)file)) {
                throw new LcdpException(LcdpExceptionEnum.NOT_FOUND_FILE, file.getAbsolutePath());
            }
            if (ToolUtil.isEmpty((Object)jsonObject)) {
                FileUtils.writeStringToFile((File)file, (String)"", (Charset)StandardCharsets.UTF_8);
            } else {
                FileUtils.writeStringToFile((File)file, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonObject), (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new LcdpException(LcdpExceptionEnum.FILE_WRITE_FAIL, file.getAbsolutePath());
        }
    }

    private WorkFlow dealData(WorkflowInfo workflowService) {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(workflowService.getId());
        workFlow.setData(workflowService.getData());
        workFlow.setDesc(workflowService.getDesc());
        workFlow.setName(workflowService.getName());
        workFlow.setType(workflowService.getType());
        workFlow.setModelId(workflowService.getModelId());
        workFlow.setIdentity(workflowService.getIdentity());
        workFlow.setProcDefId(workflowService.getProcDefId());
        workFlow.setVersion(workflowService.getVersion());
        workFlow.setCategory(AppContextUtil.getServiceName());
        workFlow.setWorkflowStyle(workflowService.getWorkflowStyle());
        workFlow.setProcessTag(workflowService.getProcessTag());
        workFlow.setProcessTagName(workflowService.getProcessTagName());
        workFlow.setAppId(workflowService.getAppId());
        if (HussarUtils.isNotEmpty((Object)workflowService.getAppId()) && this.hussarBaseAppMixBoService != null) {
            MixAppInfoVo mixAppInfoVo = this.hussarBaseAppMixBoService.getMixAppInfo(Long.valueOf(workflowService.getAppId()));
            workFlow.setAppCode(mixAppInfoVo.getAppEnglishName());
        }
        return workFlow;
    }
}

