/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.dbimpl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.formdesign.common.annotation.StorageEnvironment;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.SysMidFileInfo;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.service.ISysMidFileInfoService;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.ThemeVars;
import com.jxdinfo.hussar.formdesign.publish.service.ThemeVarsService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CodeEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionDataBaseStorage.class})
@StorageEnvironment(value="${properties.workspace > '' ? properties.workspace : 'default'}")
public class ThemeVarsServiceDBImpl
implements ThemeVarsService {
    private static final String THEME_VARS_FOLDER = "theme-vars";
    private static final String CURRENT_APPLIED = ".current";
    private static final String SUFFIX = ".vars";
    private final FormDesignProperties speedCodeProperties;
    private final StorageService storageService;
    private final PathStrategyService pathStrategy;
    @Resource
    private ISysMidFileInfoService sysMidFileInfoService;

    @Autowired
    public ThemeVarsServiceDBImpl(FormDesignProperties speedCodeProperties, StorageService storageService, PathStrategyService pathStrategy) {
        this.speedCodeProperties = speedCodeProperties;
        this.pathStrategy = pathStrategy;
        this.storageService = storageService;
    }

    @Override
    public ThemeVars get() throws IOException {
        return this.get(CURRENT_APPLIED);
    }

    @Override
    public ThemeVars get(String name) throws IOException {
        if (this.speedCodeProperties.getScenes().isSharedStorage()) {
            return this.getRemote(name);
        }
        return this.getLocal(name);
    }

    private ThemeVars getLocal(String name) throws IOException {
        String filePath = File.separator + THEME_VARS_FOLDER + File.separator + name;
        SysMidFileInfo sysMidFileInfo = this.sysMidFileInfoService.getByPath(filePath);
        if (HussarUtils.isNotEmpty((Object)sysMidFileInfo)) {
            return (ThemeVars)JSON.parseObject((String)sysMidFileInfo.getMidFileInfoData(), ThemeVars.class);
        }
        return new ThemeVars();
    }

    private ThemeVars getRemote(String name) throws IOException {
        String path = this.pathStrategy.resourcePathService().projectStore(new String[]{THEME_VARS_FOLDER, name}).getRemotePath();
        StorageResult result = this.storageService.downloadByPath(path);
        if (result.isSuccess()) {
            String themeVarsJson = new String((byte[])result.getData(), StandardCharsets.UTF_8);
            return (ThemeVars)JSON.parseObject((String)themeVarsJson, ThemeVars.class);
        }
        if (result.getCode() == CodeEnum.CODE_NOT_FILE_FOUND.getCode().intValue()) {
            return null;
        }
        throw new IOException(result.getMsg());
    }

    @Override
    public void saveOrUpdate(ThemeVars themeVars) throws IOException {
        this.saveOrUpdate(CURRENT_APPLIED, themeVars);
    }

    @Override
    public void saveOrUpdate(String name, ThemeVars themeVars) throws IOException {
        if (this.speedCodeProperties.getScenes().isSharedStorage()) {
            this.saveOrUpdateRemote(name, themeVars);
        } else {
            this.saveOrUpdateLocal(name, themeVars);
        }
    }

    private void saveOrUpdateLocal(String name, ThemeVars themeVars) throws IOException {
        String filePath = File.separator + THEME_VARS_FOLDER + File.separator + name;
        String themeVarsJson = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)themeVars);
        SysMidFileInfo sysMidFileInfo = new SysMidFileInfo();
        sysMidFileInfo.setMidFileInfoPath(filePath);
        sysMidFileInfo.setMidFileInfoName(name);
        sysMidFileInfo.setMidFileInfoData(themeVarsJson);
        this.sysMidFileInfoService.saveOrUpdateMore(sysMidFileInfo, filePath);
    }

    private void saveOrUpdateRemote(String name, ThemeVars themeVars) throws IOException {
        String themeVarsJson;
        byte[] content;
        String path = this.pathStrategy.resourcePathService().projectStore(new String[]{THEME_VARS_FOLDER, name}).getRemotePath();
        StorageResult result = this.storageService.uploadByPath(path, content = (themeVarsJson = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)themeVars)).getBytes(StandardCharsets.UTF_8), true);
        if (!result.isSuccess()) {
            throw new IOException(result.getMsg());
        }
    }

    @Override
    public void delete() throws IOException {
        this.delete(CURRENT_APPLIED);
    }

    @Override
    public void delete(String name) throws IOException {
        if (this.speedCodeProperties.getScenes().isSharedStorage()) {
            this.deleteRemote(name);
        } else {
            this.deleteLocal(name);
        }
    }

    private void deleteLocal(String name) throws IOException {
        String filePath = File.separator + THEME_VARS_FOLDER + File.separator + name;
        this.sysMidFileInfoService.removeByPath(filePath);
    }

    private void deleteRemote(String name) throws IOException {
        String path = this.pathStrategy.resourcePathService().projectStore(new String[]{THEME_VARS_FOLDER, name}).getRemotePath();
        StorageResult result = this.storageService.deleteByPath(path, true);
        if (!result.isSuccess() && result.getCode() != CodeEnum.CODE_NOT_FILE_FOUND.getCode().intValue()) {
            throw new IOException(result.getMsg());
        }
    }
}

