/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.adapter;

import com.jxdinfo.hussar.formdesign.back.adapter.ModelSyncProvideAdapter;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.publish.service.ExtendPublishService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ExtendPublishAdapter {
    private static FileMappingService fileMappingService = (FileMappingService)SpringUtil.getBean(FileMappingService.class);
    private static PageInfoService pageInfoService = (PageInfoService)SpringUtil.getBean(PageInfoService.class);
    private static ExtendPublishService extendPublishService = (ExtendPublishService)SpringUtil.getBean(ExtendPublishService.class);

    public static void generator(PublishCtx<CodeResult> publishCtx, String pageType) throws LcdpException, IOException {
        switch (pageType) {
            case "WebPage": {
                ExtendPublishAdapter.getExtendInfo(publishCtx, "JsScript", "CssScript", "VueScript");
                break;
            }
            case "UniPage": {
                ExtendPublishAdapter.getExtendInfo(publishCtx, "UniJsScript", "UniCssScript", "UniVueScript");
                break;
            }
            case "MobilePage": {
                ExtendPublishAdapter.getExtendInfo(publishCtx, "MobileJsScript", "MobileCssScript", "MobileVueScript");
                break;
            }
        }
    }

    public static void getExtendInfo(PublishCtx<CodeResult> publishCtx, Object ... useType) throws LcdpException, IOException {
        Map refMap = ModelSyncProvideAdapter.refMap((String)publishCtx.getBaseFile().getId());
        ArrayList referenceIdList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)refMap)) {
            for (Object s : useType) {
                if (!ToolUtil.isNotEmpty(refMap.get(String.valueOf(s)))) continue;
                referenceIdList.addAll((Collection)refMap.get(String.valueOf(s)));
            }
        }
        if (ToolUtil.isNotEmpty(referenceIdList)) {
            for (String jsId : referenceIdList) {
                if (!fileMappingService.isFileExist(jsId)) continue;
                extendPublishService.publishScript(jsId);
            }
        }
    }
}

