/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.application.properties.UserEvnProperties;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelPublishAdapter;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.CodePublishTool;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.result.VueCodeResult;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.constant.ExtendEnum;
import com.jxdinfo.hussar.formdesign.common.constant.StrategyType;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.model.BaseFile;
import com.jxdinfo.hussar.formdesign.common.model.page.PageInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.project.PrefixEntry;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.service.DefaultStyleCacheService;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FrontClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.VfgModeTool;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.PublishLogUtil;
import com.jxdinfo.hussar.formdesign.external.facade.theme.dto.DefaultStyleDTO;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.ViewResourceManagementService;
import com.jxdinfo.hussar.formdesign.printTemplate.service.PrintTemplateService;
import com.jxdinfo.hussar.formdesign.publish.adapter.ExtendPublishAdapter;
import com.jxdinfo.hussar.formdesign.publish.model.MergeResultDto;
import com.jxdinfo.hussar.formdesign.publish.service.PublishService;
import com.jxdinfo.hussar.formdesign.publish.service.ThemeVarsService;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.merge.util.StructuralMerger;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PublishServiceImpl
implements PublishService {
    private final PageInfoService pageInfoService;
    private static final Logger logger = LoggerFactory.getLogger(PublishServiceImpl.class);
    private final DefaultStyleCacheService defaultStyleCacheService;
    private final ThemeVarsService themeVarsService;
    private final CodePublishTool codePublishTool;
    private final FilePublishService filePublishService;
    private final PrintTemplateService printTemplateService;
    private final ViewResourceManagementService viewResourceManagementService;
    private final CodeMergeService codeMergeService;
    private final UserEvnProperties userEvnProperties;
    private final ISysTemplatePrintInfoService sysTemplatePrintInfoService;

    @Autowired
    public PublishServiceImpl(PageInfoService pageInfoService, DefaultStyleCacheService defaultStyleCacheService, ThemeVarsService themeVarsService, CodePublishTool codePublishTool, FilePublishService filePublishService, PrintTemplateService printTemplateService, ViewResourceManagementService viewResourceManagementService, CodeMergeService codeMergeService, UserEvnProperties userEvnProperties, ISysTemplatePrintInfoService sysTemplatePrintInfoService) {
        this.pageInfoService = pageInfoService;
        this.defaultStyleCacheService = defaultStyleCacheService;
        this.themeVarsService = themeVarsService;
        this.codePublishTool = codePublishTool;
        this.filePublishService = filePublishService;
        this.printTemplateService = printTemplateService;
        this.viewResourceManagementService = viewResourceManagementService;
        this.codeMergeService = codeMergeService;
        this.userEvnProperties = userEvnProperties;
        this.sysTemplatePrintInfoService = sysTemplatePrintInfoService;
    }

    @Override
    public List<CodeResult> publish(String id, Boolean isPublishModel) throws IOException, LcdpException, RuntimeException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        if (VfgModeTool.isRemote()) {
            PublishLogUtil.writePublishToEnvStartLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u9875\u9762");
        }
        PageInfo pageInfo = (PageInfo)this.pageInfoService.get(id);
        PublishCtx publishCtx = new PublishCtx();
        publishCtx.setBaseFile((BaseFile)pageInfo);
        publishCtx.setStrategy(StrategyType.analyse());
        boolean startAuto = this.userEvnProperties.getStartAuto();
        if (HussarUtils.isEmpty((Object)isPublishModel) || Boolean.TRUE.equals(isPublishModel)) {
            if (VfgModeTool.startAutoNotActive((boolean)startAuto, (String)id, (String)"\u4e2a\u4eba\u73af\u5883", null, (String)"\u4e2a\u4eba\u670d\u52a1\u5b9e\u4f8b\u672a\u542f\u52a8\u6216\u6b63\u5728\u542f\u52a8\u4e2d\uff0c\u8bf7\u7a0d\u5019\u2026\u2026\uff01", (String)"3")) {
                return new ArrayList<CodeResult>();
            }
            if (VfgModeTool.isRemote()) {
                PublishLogUtil.writePublishingLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u6a21\u578b", (String)"\u5f00\u59cb\u53d1\u5e03\u6a21\u578b...");
            }
            ModelPublishAdapter.generator((PublishCtx)publishCtx);
            if (VfgModeTool.isRemote()) {
                PublishLogUtil.writePublishingLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u6a21\u578b", (String)"\u6a21\u578b\u53d1\u5e03\u6210\u529f\uff01");
            }
        }
        ExtendPublishAdapter.generator((PublishCtx<CodeResult>)publishCtx, pageInfo.getType());
        if (AppContextUtil.isExtension()) {
            JSONObject jsonObjectExtend = this.pageInfoService.getExtend(id);
            this.deleteExtenPagedHandle(jsonObjectExtend, pageInfo);
            if (HussarUtils.isNotEmpty((Object)jsonObjectExtend)) {
                ArrayList extendDefault = Lists.newArrayListWithCapacity((int)5);
                JSONObject hussar0JSONObject = new JSONObject();
                PageInfo pageCurrent = (PageInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)pageInfo), PageInfo.class);
                for (String key : jsonObjectExtend.keySet()) {
                    JSONObject valueExtend = (JSONObject)jsonObjectExtend.get((Object)key);
                    if ("hussar_0".equals(key)) {
                        hussar0JSONObject = valueExtend;
                        continue;
                    }
                    JSONObject jsonObjectDefault = (JSONObject)valueExtend.getJSONObject("slots").getJSONArray("default").get(0);
                    extendDefault.add(jsonObjectDefault);
                    if (ExtendEnum.JXDELXFORMEXTEND.getExtendType().equals(jsonObjectDefault.get((Object)"name"))) continue;
                    pageCurrent.setData(JSONObject.toJSONString((Object)valueExtend));
                    pageCurrent.setName(key);
                    publishCtx.setBaseFile((BaseFile)pageCurrent);
                    publishCtx.setExtendFlag(true);
                    logger.info("===============================\u53d1\u5e03\u6269\u5c55\u9875\u9762\uff1a{}", (Object)key);
                    FrontClientConverter.getPublisher((String)ClientKindEnum.CLIENT_PUBLISH.kind(pageCurrent.getType())).publish(publishCtx, this.themeVarsService.get());
                }
                this.getCommonJsData(extendDefault, pageCurrent, (PublishCtx<CodeResult>)publishCtx, hussar0JSONObject);
                logger.info("===============================\u53d1\u5e03\u9875\u9762\u516c\u7528page-mixin");
                FrontClientConverter.getPublisher((String)ClientKindEnum.CLIENT_PUBLISH.kind(pageCurrent.getType())).publish(publishCtx, this.themeVarsService.get());
            }
        } else {
            FrontClientConverter.getPublisher((String)ClientKindEnum.CLIENT_PUBLISH.kind(pageInfo.getType())).publish(publishCtx, this.themeVarsService.get());
        }
        boolean isConflict = false;
        if (HussarUtils.isNotEmpty((Object)publishCtx.getGenCodeResults())) {
            for (Object genCodeResult : publishCtx.getGenCodeResults()) {
                if (!genCodeResult.isExistConflict()) continue;
                isConflict = true;
                break;
            }
        }
        if (!isConflict) {
            this.codePublishTool.delayWrite(id);
        }
        this.printTemplateService.publishPrintTemplate(publishCtx, id);
        List allModelIds = ModelPublishAdapter.allReferModelId((String)id);
        for (String modelId : allModelIds) {
            PublishTemplateDto publishTemplateDto = (PublishTemplateDto)publishCtx.getParams().get(String.format("publishTemplateDto_%s", modelId));
            if (HussarUtils.isEmpty((Object)publishTemplateDto)) continue;
            this.sysTemplatePrintInfoService.processTemplates(publishTemplateDto);
        }
        if (!pageInfo.getIsPublished()) {
            pageInfo.setIsPublished(true);
            this.pageInfoService.update((BaseFile)pageInfo);
        }
        if ((HussarUtils.isEmpty((Object)isPublishModel) || Boolean.TRUE.equals(isPublishModel)) && Boolean.TRUE.equals(VfgModeTool.isActive().getData())) {
            ModelPublishAdapter.compileAndPush((String)id);
        }
        VfgModeTool.start((boolean)startAuto, (String)id, (String)"\u542f\u52a8", (String)"\u5f00\u59cb\u542f\u52a8\u670d\u52a1...", (String)"", (String)"1");
        if (VfgModeTool.isRemote()) {
            PublishLogUtil.writePublishSuccessLog((String)id, (String)((PrefixEntry)SpringContextHolder.getBean(PrefixEntry.class)).getPrefix(), (String)"\u9875\u9762", (String)"1");
        }
        String useTime = ToolUtil.logTime((long)start);
        logger.info("{}\u53d1\u5e03\u603b\u8017\u65f6({})", (Object)pageInfo.getType(), (Object)useTime);
        return publishCtx.getGenCodeResults();
    }

    private void deleteExtenPagedHandle(JSONObject jsonObjectExtend, PageInfo pageInfo) throws LcdpException, IOException {
        FrontClientConverter.getPublisher((String)ClientKindEnum.CLIENT_PUBLISH.kind(pageInfo.getType())).deleteExtend(jsonObjectExtend, pageInfo);
    }

    private void getCommonJsData(List<JSONObject> extendDefault, PageInfo pageInfo, PublishCtx<CodeResult> publishCtx, JSONObject hussar0JSONObject) {
        JSONObject valueExtendTempJs = new JSONObject();
        valueExtendTempJs.put("name", (Object)"Base.WebPage");
        valueExtendTempJs.put("instanceKey", (Object)"hussar_0");
        HashMap defaultMap = Maps.newHashMapWithExpectedSize((int)5);
        defaultMap.put("default", extendDefault);
        valueExtendTempJs.put("slots", (Object)defaultMap);
        if (HussarUtils.isNotEmpty((Object)hussar0JSONObject) && hussar0JSONObject.containsKey((Object)"events") && HussarUtils.isNotEmpty((Object)hussar0JSONObject.get((Object)"events"))) {
            valueExtendTempJs.put("events", hussar0JSONObject.get((Object)"events"));
        }
        pageInfo.setData(JSONObject.toJSONString((Object)valueExtendTempJs));
        publishCtx.setBaseFile((BaseFile)pageInfo);
        publishCtx.setCommonFlag(true);
        publishCtx.setExtendFlag(false);
    }

    @Override
    public void defaultStyleGenerate(DefaultStyleDTO defaultStyleDTO) {
        this.defaultStyleCacheService.del(defaultStyleDTO);
        this.defaultStyleCacheService.update(defaultStyleDTO);
    }

    @Override
    public void writeMergeCode(MergeResultDto mergeResultDto) throws IOException, LcdpException {
        this.codePublishTool.delayWrite(mergeResultDto.getId());
        List<CodeResult> results = mergeResultDto.getCodeResults();
        if (HussarUtils.isEmpty(results)) {
            return;
        }
        for (CodeResult result : results) {
            if (HussarUtils.isEmpty((Object)result.getResultType())) continue;
            com.jxdinfo.hussar.formdesign.common.service.CodeMergeService codeMergeService = null;
            try {
                codeMergeService = (com.jxdinfo.hussar.formdesign.common.service.CodeMergeService)SpringUtil.getBean((String)result.getResultType().getBean());
            }
            catch (Exception e) {
                logger.error("\u5199\u5165\u51b2\u7a81\u6587\u4ef6\u65f6\u83b7\u53d6({})\u5b9e\u4f8b\u5931\u8d25", (Object)result.getResultType().getBean());
            }
            if (ObjectUtils.isEmpty((Object)codeMergeService)) {
                return;
            }
            codeMergeService.writeMergeCode(codeMergeService.parseData(result.getData()));
        }
    }

    @Override
    public List<VueCodeResult> acceptLeftNoConflictCode(List<VueCodeResult> vueCodeResults) {
        String path = vueCodeResults.get(0).getFilePath();
        String type = vueCodeResults.get(0).getType();
        ExtractFileType extractFileType = ExtractFileType.valueOf((String)type.toUpperCase());
        String lastPublish = vueCodeResults.get(0).getLastPublish();
        String currentFile = vueCodeResults.get(0).getCurrentFile();
        String currentPublish = vueCodeResults.get(0).getCurrentPublish();
        StructuralMerger.Result result = StructuralMerger.hybridMerge((String)path, (ExtractFileType)extractFileType, (String)currentFile, (String)lastPublish, (String)currentPublish, null);
        vueCodeResults.get(0).setCurrentFile(result.getMerged());
        return vueCodeResults;
    }

    @Override
    public List<VueCodeResult> acceptRightNoConflictCode(List<VueCodeResult> vueCodeResults) {
        String path = vueCodeResults.get(0).getFilePath();
        String type = vueCodeResults.get(0).getType();
        ExtractFileType extractFileType = ExtractFileType.valueOf((String)type.toUpperCase());
        String lastPublish = vueCodeResults.get(0).getLastPublish();
        String currentFile = vueCodeResults.get(0).getCurrentFile();
        String currentPublish = vueCodeResults.get(0).getCurrentPublish();
        StructuralMerger.Result result = StructuralMerger.hybridMerge((String)path, (ExtractFileType)extractFileType, (String)currentFile, (String)lastPublish, (String)currentPublish, null);
        vueCodeResults.get(0).setCurrentFile(result.getConflicts());
        return vueCodeResults;
    }

    @Override
    public VueCodeResult applyLeftCode(VueCodeResult vueCodeResult) {
        String currentFile;
        String path = vueCodeResult.getFilePath();
        String type = vueCodeResult.getType();
        ExtractFileType extractFileType = ExtractFileType.valueOf((String)type.toUpperCase());
        if (vueCodeResult.isExistUpgradeOperator()) {
            try {
                currentFile = this.filePublishService.readCurrentPublishedFile(vueCodeResult.getFilePath());
            }
            catch (IOException e) {
                throw new HussarException("\u83b7\u53d6\u672c\u5730\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        } else {
            currentFile = vueCodeResult.getCurrentFile();
        }
        String currentPublish = vueCodeResult.getCurrentPublish();
        StructuralMerger.Result result = StructuralMerger.hybridMerge((String)path, (ExtractFileType)extractFileType, (String)currentFile, (String)currentFile, (String)currentPublish, null);
        vueCodeResult.setLastPublish(currentFile);
        vueCodeResult.setMergeInfo(result.getMergeInfo());
        return vueCodeResult;
    }

    @Override
    public VueCodeResult applyRightCode(VueCodeResult vueCodeResult) {
        String path = vueCodeResult.getFilePath();
        String type = vueCodeResult.getType();
        ExtractFileType extractFileType = ExtractFileType.valueOf((String)type.toUpperCase());
        String currentFile = vueCodeResult.getCurrentFile();
        String currentPublish = vueCodeResult.getCurrentPublish();
        StructuralMerger.Result result = StructuralMerger.hybridMerge((String)path, (ExtractFileType)extractFileType, (String)currentPublish, (String)currentFile, (String)currentPublish, null);
        vueCodeResult.setLastPublish(currentPublish);
        vueCodeResult.setMergeInfo(result.getMergeInfo());
        return vueCodeResult;
    }

    @Override
    public CodeResult dealMerge(String id, String dataId) throws IOException {
        CodeResult codeResult = (CodeResult)this.filePublishService.getPublishResult(id, dataId);
        com.jxdinfo.hussar.formdesign.common.service.CodeMergeService codeMergeService = null;
        try {
            codeMergeService = (com.jxdinfo.hussar.formdesign.common.service.CodeMergeService)SpringUtil.getBean((String)codeResult.getResultType().getBean());
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u51b2\u7a81\u6587\u4ef6\u65f6\u83b7\u53d6({})\u5b9e\u4f8b\u5931\u8d25", (Object)codeResult.getResultType().getBean());
        }
        if (ObjectUtils.isEmpty((Object)codeMergeService)) {
            return codeResult;
        }
        return codeMergeService.dealMerge(codeResult);
    }

    @Override
    public boolean isCodeConflict(List<VueCodeResult> vueCodeResults) {
        String lastPublish = vueCodeResults.get(0).getLastPublish();
        String currentFile = vueCodeResults.get(0).getCurrentFile();
        String currentPublish = vueCodeResults.get(0).getCurrentPublish();
        return this.codeMergeService.textMerge(lastPublish, currentFile, currentPublish, null, false).isConflict();
    }

    @Override
    public FormDesignResponse<String> deleteCacheByIdStopPublish(String id) throws LcdpException {
        FormDesignResponse response = new FormDesignResponse();
        if (HussarUtils.isNotEmpty((Object)id)) {
            this.filePublishService.deleteCacheById(id);
            response.setErrorCode(200);
            response.setErrorMsg("\u5df2\u7ec8\u6b62\u53d1\u5e03");
        } else {
            response.setErrorCode(10001);
            response.setErrorMsg("\u53d1\u5e03\u6807\u8bc6\u4e3a\u7a7a\uff0c\u7ec8\u6b62\u53d1\u5e03\u5931\u8d25");
        }
        return response;
    }

    @Override
    public void deleteCacheByIdBeforePublish(String id) {
        this.filePublishService.deleteCacheById(id);
    }
}

