/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelPublishAdapter;
import com.jxdinfo.hussar.formdesign.codegenerator.core.generate.front.CodePublishTool;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotDataBaseStorage;
import com.jxdinfo.hussar.formdesign.common.constant.ResultBeanEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.PublishCtx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.model.WorkflowInfo;
import com.jxdinfo.hussar.formdesign.common.model.publish.CodeResult;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtils;
import com.jxdinfo.hussar.formdesign.common.util.ToolCacheUtile;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.publish.model.PublishDTO;
import com.jxdinfo.hussar.formdesign.publish.model.WorkGenCodeResult;
import com.jxdinfo.hussar.formdesign.publish.service.BackPublishService;
import com.jxdinfo.hussar.formdesign.publish.service.ResourcePublishService;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.template.print.dto.PublishTemplateDto;
import com.jxdinfo.hussar.template.print.service.ISysTemplatePrintInfoService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionNotDataBaseStorage.class})
public class BackPublishServiceImpl
implements BackPublishService {
    private final FilePublishService filePublishService;
    private final FileMappingService fileMappingService;
    private final VersionManageService versionManageService;
    private final FormDesignProperties formDesignProperties;
    private final CodeMergeService codeMergeService;
    private final CodePublishTool codePublishTool;
    @Autowired(required=false)
    private ResourcePublishService resourcePublishService;
    private static final Logger logger = LoggerFactory.getLogger(BackPublishServiceImpl.class);
    private PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
    private ISysTemplatePrintInfoService sysTemplatePrintInfoService;

    @Autowired
    public BackPublishServiceImpl(CodeMergeService codeMergeService, FilePublishService filePublishService, FileMappingService fileMappingService, VersionManageService versionManageService, FormDesignProperties formDesignProperties, CodePublishTool codePublishTool, ISysTemplatePrintInfoService sysTemplatePrintInfoService) {
        this.codeMergeService = codeMergeService;
        this.filePublishService = filePublishService;
        this.fileMappingService = fileMappingService;
        this.versionManageService = versionManageService;
        this.formDesignProperties = formDesignProperties;
        this.codePublishTool = codePublishTool;
        this.sysTemplatePrintInfoService = sysTemplatePrintInfoService;
    }

    @Override
    public void sync(Map<String, Object> param) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        Object id = param.get("id");
        if (ToolUtil.isNotEmpty(param) && ToolUtil.isNotEmpty((Object)id)) {
            PublishCtx publishCtx = new PublishCtx();
            publishCtx.setBaseFile(null);
            publishCtx.addParams(param);
            ModelPublishAdapter.sync((String)id.toString());
        }
        long end = System.currentTimeMillis();
        String useTime = ToolUtil.timeBetween((long)start, (long)end);
        logger.info("\u540c\u6b65\u66f4\u65b0\u6570\u636e\u5e93\u540e\u7aef\u4ee3\u7801\u603b\u8017\u65f6\uff1a{}", (Object)useTime);
    }

    @Override
    public List<CodeResult> publishBackCode(Map<String, Object> param) throws IOException, LcdpException, CloneNotSupportedException {
        long start = System.currentTimeMillis();
        ArrayList<CodeResult> codeResults = new ArrayList<CodeResult>();
        String id = param.get("id").toString();
        HashSet<String> modelIds = new HashSet<String>();
        modelIds.add(id);
        String path = this.fileMappingService.getDataPath(id);
        if (ToolUtil.isNotEmpty((Object)path)) {
            JSONArray translates;
            File metaFile = new File(FileUtil.posixPath((String[])new String[]{((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).resourcePathService().projectStoreCode(new String[0]).getLocalPath(), path}));
            JSONObject modelObject = null;
            if (FileUtils.exists((File)metaFile) && ToolUtil.isNotEmpty((Object)(translates = (modelObject = JSON.parseObject((String)FileUtils.readFileToString((File)metaFile, (String)"UTF-8"))).getJSONArray("translate")))) {
                for (Object object : translates) {
                    JSONObject translate = (JSONObject)object;
                    if (!ToolUtil.isNotEmpty((Object)translate.getJSONArray("dataModelCondition"))) continue;
                    modelIds.add(translate.getString("sourceId"));
                }
            }
        }
        for (String modelId : modelIds) {
            String metaPath;
            PublishCtx publishCtx = new PublishCtx();
            String publishIds = "WebPage";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", modelId);
            params.put("publishIds", publishIds);
            if (ToolUtil.isNotEmpty((Object)param.get("identity"))) {
                params.put("identity", param.get("identity"));
            }
            if (!ToolUtil.isNotEmpty(params) || !ToolUtil.isNotEmpty((Object)modelId)) continue;
            publishCtx.setBaseFile(null);
            publishCtx.addParams(params);
            ModelPublishAdapter.adaptor((String)modelId, (PublishCtx)publishCtx);
            this.codePublishTool.generatePrefixCommon(modelId);
            Object extPublish = publishCtx.getParam("extPublish");
            if (HussarUtils.isNotEmpty((Object)extPublish) && Boolean.parseBoolean(String.valueOf(extPublish))) {
                this.codePublishTool.delayWrite(modelId);
                return new ArrayList<CodeResult>();
            }
            List results = publishCtx.getGenCodeResults();
            ArrayList codeResultList = new ArrayList(results);
            codeResults.addAll(codeResultList);
            PublishDTO publishDTO = ToolUtil.isEmpty((Object)publishCtx.getPublishDTO()) ? new PublishDTO() : publishCtx.getPublishDTO();
            publishDTO.setExtensionId(AppContextUtil.getUnionPrefix());
            boolean isConflict = false;
            for (int i = 0; i < codeResultList.size(); ++i) {
                if (!((CodeResult)codeResultList.get(i)).isExistConflict()) continue;
                isConflict = true;
                break;
            }
            if (!isConflict) {
                this.codePublishTool.delayWrite(modelId);
                this.resourcePublishService.publishResource(publishDTO);
                PublishTemplateDto publishTemplateDto = (PublishTemplateDto)publishCtx.getParams().get(String.format("publishTemplateDto_%s", modelId));
                if (HussarUtils.isNotEmpty((Object)publishTemplateDto)) {
                    this.sysTemplatePrintInfoService.processTemplates(publishTemplateDto);
                }
            } else {
                this.filePublishService.writePublishResourceToCache(modelId, null, publishDTO);
                this.filePublishService.writePublishSourceToCache(modelId, "dataModel");
            }
            if (!ToolUtil.isNotEmpty((Object)(metaPath = this.fileMappingService.getMetaPath(id)))) continue;
            File metaFile = new File(this.pathStrategy.resourcePathService().projectStoreCode(new String[0]).getLocalPath() + metaPath);
            JSONObject modelObject = null;
            if (!metaFile.exists()) continue;
            modelObject = JSON.parseObject((String)FileUtils.readFileToString((File)metaFile, (String)"UTF-8"));
            modelObject.put("isPublished", (Object)true);
            if (ToolUtil.isEmpty((Object)modelObject)) {
                FileUtils.writeStringToFile((File)metaFile, (String)"", (String)"UTF-8", (boolean)false);
                continue;
            }
            FileUtils.writeStringToFile((File)metaFile, (String)new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)modelObject), (String)"UTF-8", (boolean)false);
        }
        Object isCompile = param.get("isCompile");
        if (ToolUtil.isEmpty((Object)isCompile)) {
            ModelPublishAdapter.compileAndPush(new ArrayList(modelIds), (String)"");
        }
        long end = System.currentTimeMillis();
        String useTime = ToolUtil.timeBetween((long)start, (long)end);
        logger.info("\u53d1\u5e03\u540e\u7aef\u4ee3\u7801\u603b\u8017\u65f6\uff1a{}", (Object)useTime);
        return codeResults;
    }

    @Override
    public List<WorkGenCodeResult> publishBpmActivityVisitorCode(List<Map<String, String>> fileMessages, WorkflowInfo workflowInfo, String modelId) throws IOException, LcdpException {
        ArrayList<WorkGenCodeResult> results = new ArrayList<WorkGenCodeResult>();
        ArrayList<String> conflictFilesPath = new ArrayList<String>();
        HashMap<String, String> writeNewFileLastPublish = new HashMap<String, String>();
        HashMap<String, String> writeNewFileCurrentFile = new HashMap<String, String>();
        HashMap<String, String> delayWriteLastPublish = new HashMap<String, String>();
        boolean isConflict = false;
        boolean codeChanges = false;
        String workflowId = workflowInfo.getId();
        for (Map<String, String> map : fileMessages) {
            MergeResult mergeResult;
            Iterator dataId = map.get("dataId");
            String newDataId = map.get("newDataId");
            String newFilePath = map.get("newFilePath");
            String oldFilePath = map.get("oldFilePath");
            String newFile = map.get("fileContent");
            if (ToolUtil.isEmpty((Object)oldFilePath)) {
                writeNewFileLastPublish.put(newDataId, newFile);
                writeNewFileCurrentFile.put(newFilePath, newFile);
                continue;
            }
            WorkGenCodeResult genCodeResult = new WorkGenCodeResult();
            String oldFile = this.filePublishService.readCurrentPublishedFile(oldFilePath);
            String versionCode = this.versionManageService.getAncestorCodeById(dataId);
            String lastFile = this.versionManageService.getLastFileCode(dataId);
            if (versionCode == null) {
                versionCode = oldFile;
            }
            if ((mergeResult = this.codeMergeService.textMerge(versionCode, oldFile, newFile, lastFile, false)).isConflict()) {
                isConflict = true;
                if (conflictFilesPath.contains(newFilePath)) continue;
                conflictFilesPath.add(newFilePath);
                genCodeResult.setDataId((String)((Object)dataId));
                genCodeResult.setId(workflowId);
                genCodeResult.setExistConflict(true);
                genCodeResult.setMergeCode(mergeResult.getMergedCode());
                genCodeResult.setConflictCode(mergeResult.getConflictsCode());
                genCodeResult.setLastPublish(mergeResult.getLastPublish());
                genCodeResult.setCurrentFile(mergeResult.getCurrentFile());
                genCodeResult.setCurrentPublish(mergeResult.getCurrentPublish());
                genCodeResult.setMergeInfo(mergeResult.getMergeInfo());
                genCodeResult.setOriginCode(oldFile);
                genCodeResult.setNewCode(newFile);
                genCodeResult.setType("java");
                genCodeResult.setFilePath(newFilePath);
                genCodeResult.setResultType(ResultBeanEnum.MYSQL_RESULT);
                if (genCodeResult.isExistConflict()) {
                    this.filePublishService.writePublishResult((CodeResult)genCodeResult);
                    genCodeResult = genCodeResult.reduceCodeResult();
                }
                results.add(genCodeResult);
                continue;
            }
            this.filePublishService.writeStringToFile(mergeResult.getMergedCode(), newFilePath + "BPM", workflowId);
            delayWriteLastPublish.put(newDataId, newFile);
        }
        if (!isConflict) {
            String cacheKey;
            for (Map.Entry entry : delayWriteLastPublish.entrySet()) {
                this.versionManageService.saveLastPublishCode((String)entry.getKey(), (String)entry.getValue());
            }
            String cacheName = workflowId + "PublishCacheName";
            if (ToolCacheUtile.containKey((String)cacheName, (String)(cacheKey = workflowId + "PublishCacheKey"))) {
                this.codePublishTool.delayWrite(workflowId);
            }
            for (Map.Entry entry : writeNewFileLastPublish.entrySet()) {
                this.versionManageService.saveLastPublishCode((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : writeNewFileCurrentFile.entrySet()) {
                this.filePublishService.writeStringToFile((String)entry.getValue(), (String)entry.getKey());
            }
        } else {
            String lastPublishFilePath;
            for (Map.Entry entry : delayWriteLastPublish.entrySet()) {
                lastPublishFilePath = this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath() + "/publish/version/ancestor/" + ((String)entry.getKey()).replace("_", "/") + "/last_publish.version";
                this.filePublishService.writeStringToFile((String)entry.getValue(), lastPublishFilePath, workflowId);
            }
            for (Map.Entry entry : writeNewFileLastPublish.entrySet()) {
                lastPublishFilePath = this.pathStrategy.resourcePathService().projectStore(new String[0]).getLocalPath() + "/publish/version/ancestor/" + ((String)entry.getKey()).replace("_", "/") + "/last_publish.version";
                this.filePublishService.writeStringToFile((String)entry.getValue(), lastPublishFilePath, workflowId);
            }
        }
        String bpmvisitorPack = FileUtil.posixPath((String[])new String[]{"bpmvisitor", workflowInfo.getCategory(), workflowInfo.getIdentity()});
        ModelPublishAdapter.compileAndPush(Collections.singletonList(modelId), (String)bpmvisitorPack);
        return results;
    }

    private boolean canContinueCheck(boolean codeChanges) {
        return HussarUtils.equals((Object)"DEVTOOLS", (Object)this.formDesignProperties.getJavaCompile()) && !codeChanges;
    }
}

