/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.publish.controller;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.external.facade.theme.model.StyleScheme;
import com.jxdinfo.hussar.formdesign.publish.service.StyleSchemeService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/speedcode/styleScheme"})
public class StyleSchemeController {
    private final StyleSchemeService styleSchemeService;

    @Autowired
    public StyleSchemeController(StyleSchemeService styleSchemeService) {
        this.styleSchemeService = styleSchemeService;
    }

    @PostMapping(value={"/add"})
    public FormDesignResponse<Void> save(@RequestBody StyleScheme styleScheme) {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            this.styleSchemeService.saveOrUpdate(styleScheme);
            if (styleScheme.getIsApply()) {
                this.styleSchemeService.styleApply(styleScheme.getName(), "web");
                this.styleSchemeService.styleApply(styleScheme.getName(), "mobile");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/del/{name}"})
    public FormDesignResponse<Void> delete(@PathVariable String name) {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            this.styleSchemeService.delete(name);
        }
        catch (IOException e) {
            e.printStackTrace();
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_DELETE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_DELETE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @GetMapping(value={"/list"})
    public FormDesignResponse<List<JSONObject>> list() {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            List<JSONObject> styleSchemeDTOList = this.styleSchemeService.getList();
            speedCodeResponse.setData(styleSchemeDTOList);
        }
        catch (IOException e) {
            e.printStackTrace();
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_READ_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_READ_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/application/{name}"})
    public FormDesignResponse<Boolean> styleApply(@PathVariable String name) throws LcdpException, IOException {
        this.styleSchemeService.styleApply(name, "web");
        this.styleSchemeService.styleApply(name, "mobile");
        FormDesignResponse response = new FormDesignResponse();
        response.setData((Object)true);
        return response;
    }

    @PostMapping(value={"/web"})
    public FormDesignResponse<Void> saveWebPartially(@RequestBody StyleScheme styleScheme) {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            this.styleSchemeService.updateWebPartially(styleScheme);
            if (styleScheme.getIsApply()) {
                this.styleSchemeService.styleApply(styleScheme.getName(), "web");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }

    @PostMapping(value={"/mobile"})
    public FormDesignResponse<Void> saveMobilePartially(@RequestBody StyleScheme styleScheme) {
        FormDesignResponse speedCodeResponse = new FormDesignResponse();
        try {
            this.styleSchemeService.updateMobilePartially(styleScheme);
            if (styleScheme.getIsApply()) {
                this.styleSchemeService.styleApply(styleScheme.getName(), "mobile");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            speedCodeResponse.setErrorCode(LcdpExceptionEnum.FILE_WRITE_FAIL.getCode());
            speedCodeResponse.setErrorMsg(LcdpExceptionEnum.FILE_WRITE_FAIL.getMsg());
        }
        return speedCodeResponse;
    }
}

