/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.file.fileoperate.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.BaseFileOutService;
import com.jxdinfo.hussar.formdesign.file.fileoperate.service.PageInfoService;
import java.io.File;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BaseFileOutServiceImpl
implements BaseFileOutService {
    private Logger logger = LoggerFactory.getLogger(BaseFileOutServiceImpl.class);
    @Resource
    private PageInfoService pageInfoService;
    @Resource
    private FileMappingService fileMappingService;

    public JSONObject getCrossApp(String appId, String fileId) {
        JSONObject result = new JSONObject();
        try {
            result = this.pageInfoService.getCrossApp(appId, fileId);
        }
        catch (Exception e) {
            this.logger.error("getCrossApp error", (Throwable)e);
            e.printStackTrace();
        }
        return result;
    }

    public String getFormAddress(String formId) {
        try {
            String dataPath = this.fileMappingService.getDataPath(formId);
            String prefix = ((PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class)).vuePathService().prefix();
            return this.formatFilePath(FileUtil.systemPath((String[])new String[]{prefix, dataPath}));
        }
        catch (LcdpException e) {
            throw new RuntimeException(e);
        }
    }

    private String formatFilePath(String dataPath) {
        String formatPath = dataPath.replace(File.separator, "/");
        int location = formatPath.lastIndexOf("/");
        if (location != -1) {
            String name = formatPath.substring(location);
            int suffix = name.lastIndexOf(".");
            if (suffix != -1) {
                name = name.substring(0, suffix);
            }
            formatPath = formatPath.substring(0, location) + name;
        }
        return formatPath;
    }
}

