/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.version.service.impl;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionUseSharedStorage;
import com.jxdinfo.hussar.formdesign.common.file.PathStrategyService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionUseSharedStorage.class})
public class VersionManageServiceOnLineImpl
implements VersionManageService {
    private static String ANCESTOR_STORE_PATH;
    private final StorageService storageService;

    @Autowired
    public VersionManageServiceOnLineImpl(FormDesignProperties formDesignProperties, StorageService storageService) {
        this.storageService = storageService;
        PathStrategyService pathStrategy = (PathStrategyService)SpringContextHolder.getBean(PathStrategyService.class);
        ANCESTOR_STORE_PATH = pathStrategy.resourcePathService().projectStore(new String[]{"publish", "version", "ancestor"}).getRemotePath();
    }

    @Override
    public String getAncestorCodeById(String id) throws IOException {
        String filePath = this.getPublishVersionFilePathById(id);
        if (((Boolean)this.storageService.existsByPath(filePath).getData()).booleanValue()) {
            StorageResult result = this.storageService.downloadByPath(filePath);
            if (result.isSuccess()) {
                return new String((byte[])result.getData(), StandardCharsets.UTF_8);
            }
            return null;
        }
        return null;
    }

    @Override
    public void saveLastPublishCode(String id, String code) throws IOException {
        String filePath = this.getPublishVersionFilePathById(id);
        this.storageService.uploadByPath(filePath, code.getBytes(StandardCharsets.UTF_8), false);
    }

    @Override
    public void saveCacheLastPublishCode(String id, String code, String pageId) {
    }

    @Override
    public void saveCacheLastFileCode(String id, String code, String pageId) {
    }

    @Override
    public void saveLastFileCode(String id, String code) throws IOException {
        String filePath = this.getLastFileVersionFilePathById(id);
        this.storageService.uploadByPath(filePath, code.getBytes(StandardCharsets.UTF_8), false);
    }

    @Override
    public String getLastFileCode(String id) throws IOException {
        String filePath = this.getLastFileVersionFilePathById(id);
        if (((Boolean)this.storageService.existsByPath(filePath).getData()).booleanValue()) {
            StorageResult result = this.storageService.downloadByPath(filePath);
            if (result.isSuccess()) {
                return new String((byte[])result.getData(), StandardCharsets.UTF_8);
            }
            return null;
        }
        return null;
    }

    @Override
    public String getAncestorCodeExtendById(String id) {
        return "";
    }

    @Override
    public String getLastFileExtendCode(String id) {
        return "";
    }

    @Override
    public void saveLastPublishCodeExtendCache(String id, String newContent, String pageId) {
    }

    @Override
    public void saveLastFileCodeExtendCache(String id, String mergedCode, String pageId) {
    }

    @Override
    public void saveLastPublishCodeExtend(String id, String code) throws IOException {
    }

    @Override
    public void saveLastFileCodeExtend(String id, String code) throws IOException {
    }

    private String getPublishVersionFilePathById(String id) {
        String path = FileUtil.posixPath((String[])new String[]{ANCESTOR_STORE_PATH, id.replace("_", "/"), "last_publish"});
        return path + ".version";
    }

    private String getLastFileVersionFilePathById(String id) {
        String path = FileUtil.posixPath((String[])new String[]{ANCESTOR_STORE_PATH, id.replace("_", "/"), "last_file"});
        return path + ".version";
    }
}

