/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.upgrade.vue.dom.title;

import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfig;
import com.jxdinfo.hussar.formdesign.upgrade.factory.ParseCodeFactory;
import com.jxdinfo.hussar.formdesign.upgrade.model.PublishFileType;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.VueDomPropValues;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.parse.VueDomParse;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.title.model.UpgradeTitleAddDetail;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.title.model.UpgradeTitleDetail;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.formdesign.upgrade.title.dom.vue.VueDomTitleParse")
public class VueDomTitleParse
implements VueDomParse {
    private static final Logger logger = LoggerFactory.getLogger(VueDomTitleParse.class);
    private static final String LINE_SEPARATOR = "\n";
    public static final String UPGRADE_TYPE = "VUE-DOM-TITLE";
    private static final String WRAP_DIRECTION_OUTER = "outer";
    private static final String WRAP_DIRECTION_INNER = "inner";

    @PostConstruct
    public void register() {
        ParseCodeFactory.registerParseDetailTypeCode(UPGRADE_TYPE, VueDomTitleParse.class);
    }

    @Override
    public void parseCode(VueDomPropValues configDetail, List<String> domLines, UpgradeConfig upgradeConfig, VueDomPropValues currentPublishConfigDetail, PublishFileType publishFileType, Map<String, String> dynamicRemoveMap) {
        switch (upgradeConfig.getType()) {
            case 0: {
                this.replaceTitle(configDetail, domLines, upgradeConfig);
                break;
            }
            case 4: {
                this.wrapDomElement(configDetail, domLines, upgradeConfig);
            }
        }
    }

    public void replaceTitle(VueDomPropValues configDetail, List<String> domLines, UpgradeConfig upgradeConfig) {
        UpgradeTitleDetail upgradeTitleDetail = (UpgradeTitleDetail)upgradeConfig.getUpgradeDetail().toJavaObject(UpgradeTitleDetail.class);
        String upgradeFrom = upgradeTitleDetail.getUpgradeFrom();
        String upgradeTo = upgradeTitleDetail.getUpgradeTo();
        if (!StringUtil.equals((CharSequence)configDetail.getTitleName(), (CharSequence)upgradeConfig.getMatchTitle())) {
            return;
        }
        if (configDetail.isReplace()) {
            int indexPreStart = configDetail.getIndexPreStart();
            int indexPreEnd = configDetail.getIndexPreEnd();
            String linePre = domLines.get(configDetail.getIndexPre());
            StringBuilder sbPre = new StringBuilder(linePre);
            sbPre.replace(indexPreStart, indexPreEnd, upgradeTo);
            domLines.set(configDetail.getIndexPre(), sbPre.toString());
            int indexRefStart = configDetail.getIndexRefStart();
            int indexRefEnd = configDetail.getIndexRefEnd();
            String lineRef = domLines.get(configDetail.getIndexRef());
            StringBuilder sbRef = new StringBuilder(lineRef);
            int num = 0;
            if (configDetail.getIndexPre() == configDetail.getIndexRef()) {
                num = upgradeTo.length() - upgradeFrom.length();
            }
            sbRef.replace(indexRefStart + num, indexRefEnd + num, upgradeTo);
            domLines.set(configDetail.getIndexRef(), sbRef.toString());
            configDetail.replaced(upgradeTo.length());
        }
    }

    private void wrapDomElement(VueDomPropValues configDetail, List<String> domLines, UpgradeConfig upgradeConfig) {
        UpgradeTitleAddDetail upgradeTitleAddDetail = (UpgradeTitleAddDetail)upgradeConfig.getUpgradeDetail().toJavaObject(UpgradeTitleAddDetail.class);
        if (!StringUtil.equals((CharSequence)configDetail.getTitleName(), (CharSequence)upgradeConfig.getMatchTitle())) {
            return;
        }
        if (configDetail.isReplace()) {
            String addTitle = upgradeTitleAddDetail.getAddTitle();
            List<String> attributes = upgradeTitleAddDetail.getAttributes();
            String relation = upgradeTitleAddDetail.getWrapDirection();
            if (WRAP_DIRECTION_OUTER.equalsIgnoreCase(relation) && HussarUtils.isNotEmpty((Object)upgradeTitleAddDetail.getParentTitle()) && !upgradeTitleAddDetail.getParentTitle().equals(configDetail.getParentTitle())) {
                return;
            }
            if (WRAP_DIRECTION_OUTER.equalsIgnoreCase(relation) && addTitle.equals(configDetail.getParentTitle())) {
                return;
            }
            if (WRAP_DIRECTION_INNER.equalsIgnoreCase(relation) && configDetail.getState() == 1) {
                return;
            }
            if (WRAP_DIRECTION_OUTER.equalsIgnoreCase(relation) && configDetail.getState() == 1) {
                this.wrapOuterSelfClose(configDetail, domLines, addTitle, attributes);
                return;
            }
            if (WRAP_DIRECTION_OUTER.equalsIgnoreCase(relation)) {
                this.wrapOuter(configDetail, domLines, addTitle, attributes);
            } else if (WRAP_DIRECTION_INNER.equalsIgnoreCase(relation)) {
                this.wrapInner(configDetail, domLines, addTitle, attributes);
            } else {
                logger.warn("Unknown wrapDirection '{}' in upgrade config.", (Object)relation);
            }
        }
    }

    private void wrapOuterSelfClose(VueDomPropValues configDetail, List<String> domLines, String addTitle, List<String> attributes) {
        String finalLineContent;
        int addPosition = configDetail.getAddPosition();
        int indexPre = configDetail.getIndexPre();
        StringBuilder prefix = new StringBuilder("<" + addTitle);
        for (String attribute : attributes) {
            prefix.append(" ").append(attribute);
        }
        prefix.append(">");
        String suffix = "</" + addTitle + ">";
        String originalLine = domLines.get(indexPre);
        String indentPre = this.getIndent(originalLine);
        String content = originalLine.trim();
        switch (addPosition) {
            case 1: {
                finalLineContent = indentPre + prefix + content + LINE_SEPARATOR;
                break;
            }
            case 2: {
                finalLineContent = indentPre + content + suffix + LINE_SEPARATOR;
                break;
            }
            case 3: {
                finalLineContent = originalLine;
                break;
            }
            default: {
                finalLineContent = indentPre + prefix + content + suffix + LINE_SEPARATOR;
            }
        }
        domLines.set(indexPre, finalLineContent);
        if (addPosition == 0 || addPosition == 1) {
            int offset = prefix.length();
            configDetail.setIndexPreStart(offset + configDetail.getIndexPreStart());
            configDetail.setIndexPreEnd(offset + configDetail.getIndexPreEnd());
        }
    }

    private void wrapOuter(VueDomPropValues configDetail, List<String> domLines, String addTitle, List<String> attributes) {
        int addPosition = configDetail.getAddPosition();
        int indexPre = configDetail.getIndexPre();
        int indexRef = configDetail.getIndexRef();
        StringBuilder prefix = new StringBuilder("<" + addTitle);
        for (String attribute : attributes) {
            prefix.append(" ").append(attribute);
        }
        prefix.append(">");
        String suffix = "</" + addTitle + ">";
        if (addPosition == 0 || addPosition == 1) {
            String linePre = domLines.get(indexPre);
            String indentPre = this.getIndent(linePre);
            String contentPre = linePre.trim();
            domLines.set(indexPre, indentPre + prefix + contentPre + LINE_SEPARATOR);
        }
        if (addPosition == 0 || addPosition == 2) {
            if (indexPre != indexRef) {
                String lineRef = domLines.get(indexRef);
                String indentRef = this.getIndent(lineRef);
                String contentRef = lineRef.trim();
                domLines.set(indexRef, indentRef + contentRef + suffix + LINE_SEPARATOR);
            } else {
                String updatedLine = domLines.get(indexPre);
                int lastIndex = updatedLine.lastIndexOf(LINE_SEPARATOR);
                String lineWithoutSeparator = lastIndex != -1 ? updatedLine.substring(0, lastIndex) : updatedLine;
                domLines.set(indexPre, lineWithoutSeparator + suffix + LINE_SEPARATOR);
            }
        }
        int offset = addPosition == 0 || addPosition == 1 ? prefix.length() : 0;
        configDetail.setIndexPreStart(offset + configDetail.getIndexPreStart());
        configDetail.setIndexPreEnd(offset + configDetail.getIndexPreEnd());
        if (indexPre == indexRef) {
            configDetail.setIndexRefStart(offset + configDetail.getIndexRefStart());
            configDetail.setIndexRefEnd(offset + configDetail.getIndexRefEnd());
        }
    }

    private void wrapInner(VueDomPropValues configDetail, List<String> domLines, String addTitle, List<String> attributes) {
        int indexPre = configDetail.getIndexPre();
        int indexRef = configDetail.getIndexRef();
        int indexPreTagClose = configDetail.getIndexPreTagClose();
        StringBuilder prefix = new StringBuilder("<" + addTitle);
        for (String attribute : attributes) {
            prefix.append(" ").append(attribute);
        }
        prefix.append(">");
        String suffix = "</" + addTitle + ">";
        if (indexPre == indexPreTagClose) {
            String linePre = domLines.get(indexPre);
            String indentPre = this.getIndent(linePre);
            String contentPre = linePre.trim();
            if (indexPre != indexRef) {
                domLines.set(indexPre, indentPre + contentPre + prefix + LINE_SEPARATOR);
            }
        } else {
            String linePreTagClose = domLines.get(indexPreTagClose);
            String indentPreTagClose = this.getIndent(linePreTagClose);
            String contentPreTagClose = linePreTagClose.trim();
            domLines.set(indexPreTagClose, indentPreTagClose + contentPreTagClose + prefix + LINE_SEPARATOR);
        }
        if (indexPre == indexRef) {
            String updatedLine = domLines.get(indexPre);
            int endTagStartIndex = updatedLine.lastIndexOf("</");
            if (endTagStartIndex != -1) {
                String newLine = updatedLine.substring(0, endTagStartIndex) + prefix + suffix + updatedLine.substring(endTagStartIndex);
                domLines.set(indexPre, newLine);
            } else {
                logger.error("Failed to find end tag in single line for inner wrap: {}", (Object)updatedLine);
            }
        } else {
            String lineRef = domLines.get(indexRef);
            String indentRef = this.getIndent(lineRef);
            String contentRef = lineRef.trim();
            domLines.set(indexRef, indentRef + suffix + contentRef + LINE_SEPARATOR);
        }
        int prefixOffset = prefix.length();
        int suffixOffset = suffix.length();
        if (indexPre == indexRef) {
            configDetail.setIndexRefStart(prefixOffset + suffixOffset + configDetail.getIndexRefStart());
            configDetail.setIndexRefEnd(prefixOffset + suffixOffset + configDetail.getIndexRefEnd());
        } else {
            configDetail.setIndexRefStart(suffixOffset + configDetail.getIndexRefStart());
            configDetail.setIndexRefEnd(suffixOffset + configDetail.getIndexRefEnd());
        }
    }

    private String getIndent(String line) {
        int indentLength;
        for (indentLength = 0; indentLength < line.length() && Character.isWhitespace(line.charAt(indentLength)); ++indentLength) {
        }
        return line.substring(0, indentLength);
    }
}

