/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.upgrade.vue.dom;

import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfig;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.jgit.diff.Edit;
import com.jxdinfo.hussar.formdesign.jgit.diff.EditList;
import com.jxdinfo.hussar.formdesign.structural.merge.util.PlainMerger;
import com.jxdinfo.hussar.formdesign.upgrade.factory.ParseCodeFactory;
import com.jxdinfo.hussar.formdesign.upgrade.model.PublishFileType;
import com.jxdinfo.hussar.formdesign.upgrade.model.UpgradeResult;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.VueDomDetails;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.VueDomPropValues;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.title.model.UpgradeTitleAddDetail;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.title.model.UpgradeTitleDetail;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.util.VueDomParseCodeUtil;
import com.jxdinfo.hussar.formdesign.upgrade.vue.parse.VueCodeParse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.formdesign.upgrade.dom.vue.VueDomParse")
public class VueDomParse
implements VueCodeParse {
    private static final String TEMPLATE_PRE = "<template>";
    private static final String TEMPLATE_PRE2 = "<template ";
    private static final String TEMPLATE_SUF = "</template>";
    private static final String REGEX_PRE = "^\\s+<([\\w-]+)";
    private static final String REGEX_REF = "</([\\w-]+)>\\s+$";
    private static final String PUBLISH_FILE_TYPE = "VUE-DOM";

    @PostConstruct
    public void register() {
        ParseCodeFactory.registerParseTypeCode(PUBLISH_FILE_TYPE, VueDomParse.class);
    }

    @Override
    public void parseCode(UpgradeResult upgradeResult, Map<String, UpgradeConfig> configMap, Map<String, List<String>> refMap) {
        String currentFile = upgradeResult.getCurrentFile();
        String lastPublish = upgradeResult.getLastPublish();
        String currentPublish = upgradeResult.getCurrentPublish();
        List currentFileLines = CodeSplitUtil.linesOf((String)currentFile);
        List lastPublishLines = CodeSplitUtil.linesOf((String)lastPublish);
        List currentPublishLines = CodeSplitUtil.linesOf((String)currentPublish);
        ArrayList<String> currentFileDomLines = new ArrayList<String>();
        ArrayList<String> currentFileParsedLines = new ArrayList<String>();
        int currentFileDomIndex = this.parseVueDom(currentFileLines, currentFileParsedLines, currentFileDomLines);
        ArrayList<String> lastPublishDomLines = new ArrayList<String>();
        ArrayList<String> lastPublishParsedLines = new ArrayList<String>();
        int lastPublishDomIndex = this.parseVueDom(lastPublishLines, lastPublishParsedLines, lastPublishDomLines);
        ArrayList<String> currentPublishDomLines = new ArrayList<String>();
        this.parseVueDom(currentPublishLines, new ArrayList<String>(), currentPublishDomLines);
        HashMap<String, VueDomDetails> currentPublishConfigDetailMap = new HashMap<String, VueDomDetails>();
        this.parseTitle(0, currentPublishDomLines.size(), currentPublishDomLines, currentPublishConfigDetailMap, false);
        HashMap<String, VueDomDetails> currentFileConfigDetailMap = new HashMap<String, VueDomDetails>();
        HashMap<String, VueDomDetails> lastPublishConfigDetailMap = new HashMap<String, VueDomDetails>();
        if (HussarUtils.isNotEmpty(refMap)) {
            this.dealEditorDoms(lastPublish, currentFile, currentFileDomIndex, lastPublishDomIndex, currentFileDomLines, lastPublishDomLines, currentFileConfigDetailMap, lastPublishConfigDetailMap, lastPublishLines);
            this.upgradeByRef(refMap, configMap, currentPublishConfigDetailMap, lastPublishConfigDetailMap, currentFileConfigDetailMap, currentPublishLines, lastPublishDomLines, currentFileDomLines);
        } else if (HussarUtils.isNotEmpty(configMap)) {
            String lastFile = upgradeResult.getLastFile();
            List lastFileLines = CodeSplitUtil.linesOf((String)lastFile);
            ArrayList<String> lastFileDomLines = new ArrayList<String>();
            ArrayList<String> lastFileParsedLines = new ArrayList<String>();
            int lastFileDomIndex = this.parseVueDom(lastFileLines, lastFileParsedLines, lastFileDomLines);
            HashMap<String, VueDomDetails> lastFileConfigDetailMap = new HashMap<String, VueDomDetails>();
            this.parseTitle(0, lastPublishDomLines.size(), lastPublishDomLines, lastPublishConfigDetailMap, true);
            this.parseTitle(0, currentFileDomLines.size(), currentFileDomLines, currentFileConfigDetailMap, true);
            this.parseTitle(0, lastFileDomLines.size(), lastFileDomLines, lastFileConfigDetailMap, true);
            for (UpgradeConfig upgradeConfig : new ArrayList<UpgradeConfig>(configMap.values())) {
                upgradeResult.setLastPublishUpgraded(this.dealUpgradeDetail(lastPublishConfigDetailMap, lastPublishDomLines, upgradeConfig) || upgradeResult.isLastPublishUpgraded());
                upgradeResult.setCurrentFileUpgraded(this.dealUpgradeDetail(currentFileConfigDetailMap, currentFileDomLines, upgradeConfig) || upgradeResult.isCurrentFileUpgraded());
                upgradeResult.setLastFileUpgraded(this.dealUpgradeDetail(lastFileConfigDetailMap, lastFileDomLines, upgradeConfig) || upgradeResult.isLastFileUpgraded());
            }
            lastFileParsedLines.addAll(lastFileDomIndex, lastFileDomLines);
            StringBuilder lastFileSb = new StringBuilder();
            for (String currentFileParsedLine : lastFileParsedLines) {
                lastFileSb.append(currentFileParsedLine);
            }
            upgradeResult.setLastFile(lastFileSb.toString());
        }
        currentFileParsedLines.addAll(currentFileDomIndex, currentFileDomLines);
        StringBuilder currentFileSb = new StringBuilder();
        for (String currentFileParsedLine : currentFileParsedLines) {
            currentFileSb.append(currentFileParsedLine);
        }
        upgradeResult.setCurrentFile(currentFileSb.toString());
        lastPublishParsedLines.addAll(lastPublishDomIndex, lastPublishDomLines);
        StringBuilder lastPublishSb = new StringBuilder();
        for (String currentFileParsedLine : lastPublishParsedLines) {
            lastPublishSb.append(currentFileParsedLine);
        }
        upgradeResult.setLastPublish(lastPublishSb.toString());
    }

    private void upgradeByRef(Map<String, List<String>> refMap, Map<String, UpgradeConfig> configMap, Map<String, VueDomDetails> currentPublishConfigDetailMap, Map<String, VueDomDetails> lastPublishConfigDetailMap, Map<String, VueDomDetails> currentFileConfigDetailMap, List<String> currentPublishLines, List<String> lastPublishDomLines, List<String> currentFileDomLines) {
        for (Map.Entry<String, List<String>> ref : refMap.entrySet()) {
            List<String> configIds = ref.getValue();
            if (HussarUtils.isEmpty(configIds)) continue;
            HashMap<String, Set<String>> matchCurrentPublishTitleMap = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> matchCurrentTitleMap = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> matchLastTitleMap = new HashMap<String, Set<String>>();
            VueDomPropValues currentPublishConfigDetail = this.getConfigDetailByRef(currentPublishConfigDetailMap, currentPublishLines, ref, configMap, matchCurrentPublishTitleMap);
            VueDomPropValues lastConfigDetail = this.getConfigDetailByRef(lastPublishConfigDetailMap, lastPublishDomLines, ref, configMap, matchLastTitleMap);
            if (HussarUtils.isEmpty((Object)currentPublishConfigDetail) || HussarUtils.isEmpty((Object)lastConfigDetail)) continue;
            String currentPublishLine = currentPublishLines.get(currentPublishConfigDetail.getIndexPre());
            String lastLine = lastPublishDomLines.get(lastConfigDetail.getIndexPre());
            String lastLineEnd = lastPublishDomLines.get(lastConfigDetail.getIndexRef());
            List<UpgradeConfig> upgradeConfigs = ref.getValue().stream().map(configMap::get).collect(Collectors.toList());
            HashMap<String, String> dynamicRemoveMap = new HashMap<String, String>();
            this.parseUpgradeDetail(upgradeConfigs, lastConfigDetail, lastPublishDomLines, currentPublishConfigDetail, PublishFileType.LAST_PUBLISH, dynamicRemoveMap);
            String lastLineUpgrade = lastPublishDomLines.get(lastConfigDetail.getIndexPre());
            if (!StringUtil.equals((CharSequence)currentPublishLine, (CharSequence)lastLineUpgrade)) {
                lastPublishDomLines.set(lastConfigDetail.getIndexPre(), lastLine);
                lastPublishDomLines.set(lastConfigDetail.getIndexRef(), lastLineEnd);
                continue;
            }
            VueDomPropValues currentConfigDetail = this.getConfigDetailByRef(currentFileConfigDetailMap, currentFileDomLines, ref, configMap, matchCurrentTitleMap);
            if (HussarUtils.isEmpty((Object)currentConfigDetail)) continue;
            this.parseUpgradeDetail(upgradeConfigs, currentConfigDetail, currentFileDomLines, currentPublishConfigDetail, PublishFileType.LAST_PUBLISH, dynamicRemoveMap);
        }
    }

    private boolean dealUpgradeDetail(Map<String, VueDomDetails> configDetailMap, List<String> domLines, UpgradeConfig upgradeConfig) {
        UpgradeTitleAddDetail upgradeTitleAddDetail;
        String titleStr = upgradeConfig.getMatchTitle();
        if (HussarUtils.isEmpty((Object)configDetailMap.get(titleStr))) {
            return false;
        }
        List<VueDomPropValues> vueDomDetails = configDetailMap.get(titleStr).getConfigDetails();
        if (HussarUtils.isEmpty(vueDomDetails)) {
            return false;
        }
        if ("VUE-DOM-TITLE".equals(upgradeConfig.getUpgradeType()) && upgradeConfig.getType() == 4 && (upgradeTitleAddDetail = (UpgradeTitleAddDetail)upgradeConfig.getUpgradeDetail().toJavaObject(UpgradeTitleAddDetail.class)).getAddType() == 1) {
            this.markAdjacentGroups(vueDomDetails);
        }
        boolean flag = false;
        for (VueDomPropValues vueDomPropValues : vueDomDetails) {
            HashMap<String, String> dynamicRemoveMap;
            if (vueDomPropValues.isReplaced()) continue;
            if (HussarUtils.isEmpty((Object)vueDomPropValues.getDataValueInfo())) {
                boolean next;
                int indexPre = vueDomPropValues.getIndexPre();
                String line = domLines.get(indexPre);
                for (int i = vueDomPropValues.getIndexPreEnd(); i < line.length() && (next = vueDomPropValues.setChar(line.charAt(i), i)); ++i) {
                }
            }
            flag = this.parseUpgradeDetail(upgradeConfig, vueDomPropValues, domLines, PublishFileType.LAST_PUBLISH, dynamicRemoveMap = new HashMap<String, String>()) || flag;
        }
        return flag;
    }

    private void markAdjacentGroups(List<VueDomPropValues> details) {
        if (HussarUtils.isEmpty(details)) {
            return;
        }
        int groupStart = 0;
        int n = details.size();
        for (int i = 1; i <= n; ++i) {
            if (i != n && this.areAdjacent(details.get(i - 1), details.get(i))) continue;
            int groupEnd = i - 1;
            int groupSize = groupEnd - groupStart + 1;
            for (int j = groupStart; j <= groupEnd; ++j) {
                VueDomPropValues detail = details.get(j);
                if (groupSize == 1) {
                    detail.setAddPosition(0);
                    continue;
                }
                if (j == groupStart) {
                    detail.setAddPosition(1);
                    continue;
                }
                if (j == groupEnd) {
                    detail.setAddPosition(2);
                    continue;
                }
                detail.setAddPosition(3);
            }
            groupStart = i;
        }
    }

    private boolean areAdjacent(VueDomPropValues prev, VueDomPropValues curr) {
        if (prev.getState() == 1) {
            return prev.getIndexPre() + 1 == curr.getIndexPre();
        }
        return prev.getIndexRef() + 1 == curr.getIndexPre();
    }

    private void parseUpgradeDetail(List<UpgradeConfig> upgradeConfigs, VueDomPropValues configDetail, List<String> publishDomLines, VueDomPropValues publishConfigDetail, PublishFileType publishFileType, Map<String, String> dynamicRemoveMap) {
        List upgradeTitles = upgradeConfigs.stream().filter(upgradeConfig -> StringUtil.equals((CharSequence)configDetail.getTitleName(), (CharSequence)upgradeConfig.getMatchTitle())).filter(upgradeConfig -> StringUtil.equals((CharSequence)"VUE-DOM-TITLE", (CharSequence)upgradeConfig.getUpgradeType()) && upgradeConfig.getType() == 0).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(upgradeTitles)) {
            VueDomParseCodeUtil.parseCode(configDetail, publishDomLines, (UpgradeConfig)upgradeTitles.get(0), ((UpgradeConfig)upgradeTitles.get(0)).getUpgradeType(), publishConfigDetail, publishFileType, dynamicRemoveMap);
        }
        upgradeConfigs.stream().filter(upgradeConfig -> !upgradeTitles.contains(upgradeConfig)).forEach(upgradeConfig -> VueDomParseCodeUtil.parseCode(configDetail, publishDomLines, upgradeConfig, upgradeConfig.getUpgradeType(), publishConfigDetail, publishFileType, dynamicRemoveMap));
    }

    private boolean parseUpgradeDetail(UpgradeConfig upgradeConfig, VueDomPropValues configDetail, List<String> publishDomLines, PublishFileType publishFileType, Map<String, String> dynamicRemoveMap) {
        if (HussarUtils.isEmpty((Object)configDetail)) {
            return false;
        }
        VueDomParseCodeUtil.parseCode(configDetail, publishDomLines, upgradeConfig, upgradeConfig.getUpgradeType(), null, publishFileType, dynamicRemoveMap);
        return true;
    }

    private VueDomPropValues getConfigDetailByRef(Map<String, VueDomDetails> configDetailMap, List<String> domLines, Map.Entry<String, List<String>> ref, Map<String, UpgradeConfig> configMap, Map<String, Set<String>> matchTitleMap) {
        UpgradeConfig upgradeConfig = configMap.get(ref.getValue().get(0));
        if (HussarUtils.isEmpty((Object)upgradeConfig)) {
            return null;
        }
        Set<String> matchTitle = matchTitleMap.get(upgradeConfig.getComponentCode());
        if (HussarUtils.isEmpty(matchTitle)) {
            if (ref.getValue().size() == 1 && upgradeConfig.getType() == 0 && "VUE-DOM-TITLE".equals(upgradeConfig.getUpgradeType())) {
                UpgradeTitleDetail upgradeTitleDetail = (UpgradeTitleDetail)upgradeConfig.getUpgradeDetail().toJavaObject(UpgradeTitleDetail.class);
                matchTitle = new HashSet<String>();
                matchTitle.add(upgradeTitleDetail.getUpgradeFrom());
                matchTitle.add(upgradeTitleDetail.getUpgradeTo());
            } else {
                matchTitle = ref.getValue().stream().map(configMap::get).map(UpgradeConfig::getMatchTitle).collect(Collectors.toSet());
            }
            matchTitleMap.put(upgradeConfig.getComponentCode(), matchTitle);
        }
        for (String titleStr : matchTitle) {
            List<VueDomPropValues> vueDomDetails;
            if (HussarUtils.isEmpty((Object)configDetailMap.get(titleStr)) || HussarUtils.isEmpty(vueDomDetails = configDetailMap.get(titleStr).getConfigDetails())) continue;
            for (VueDomPropValues vueDomPropValues : vueDomDetails) {
                if (vueDomPropValues.isReplaced()) continue;
                if (HussarUtils.isEmpty((Object)vueDomPropValues.getDataValueInfo())) {
                    boolean next;
                    int indexPre = vueDomPropValues.getIndexPre();
                    String line = domLines.get(indexPre);
                    for (int i = vueDomPropValues.getIndexPreEnd(); i < line.length() && (next = vueDomPropValues.setChar(line.charAt(i), i)); ++i) {
                    }
                }
                if (!VueDomParseCodeUtil.identifyByRef(vueDomPropValues, ref.getKey(), upgradeConfig)) continue;
                vueDomPropValues.setReplaced(true);
                return vueDomPropValues;
            }
        }
        return null;
    }

    public void parseTitle(int begin, int end, List<String> domLines, Map<String, VueDomDetails> configDetailMap, boolean replace) {
        Stack<String> parentStack = new Stack<String>();
        for (int j = begin; j < end; ++j) {
            Pattern pattern_ref;
            Matcher matcher_ref;
            Pattern pattern_pre = Pattern.compile(REGEX_PRE);
            Matcher matcher_pre = pattern_pre.matcher(domLines.get(j));
            if (matcher_pre.find()) {
                String componentTileName = matcher_pre.group(1);
                VueDomDetails vueDomDetails = configDetailMap.get(componentTileName);
                if (HussarUtils.isEmpty((Object)vueDomDetails)) {
                    vueDomDetails = new VueDomDetails();
                    configDetailMap.put(componentTileName, vueDomDetails);
                }
                VueDomPropValues vueDomDetail = new VueDomPropValues(j, matcher_pre.start(1), matcher_pre.end(1), replace);
                vueDomDetail.setTitleName(componentTileName);
                if (!parentStack.isEmpty()) {
                    vueDomDetail.setParentTitle((String)parentStack.peek());
                }
                int tagCloseLine = j;
                String lineContent = domLines.get(j);
                int tagCloseIndex = lineContent.indexOf(">", matcher_pre.end());
                if (tagCloseIndex == -1) {
                    for (int searchLine = j + 1; searchLine < Math.min(j + 50, domLines.size()); ++searchLine) {
                        if (!domLines.get(searchLine).contains(">")) continue;
                        tagCloseLine = searchLine;
                        break;
                    }
                }
                vueDomDetail.setIndexPreTagClose(tagCloseLine);
                vueDomDetails.addConfigDetail(vueDomDetail);
                String tagContent = lineContent.substring(matcher_pre.start(), Math.min(matcher_pre.end() + 50, lineContent.length()));
                if (!tagContent.contains("/>")) {
                    parentStack.push(componentTileName);
                }
            }
            if (!(matcher_ref = (pattern_ref = Pattern.compile(REGEX_REF)).matcher(domLines.get(j))).find()) continue;
            String componentTileName = matcher_ref.group(1);
            VueDomDetails vueDomDetails = configDetailMap.get(componentTileName);
            if (HussarUtils.isNotEmpty((Object)vueDomDetails)) {
                vueDomDetails.setEnd(j, matcher_ref.start(1), matcher_ref.end(1));
            }
            if (parentStack.isEmpty() || !((String)parentStack.peek()).equals(componentTileName)) continue;
            parentStack.pop();
        }
    }

    private int parseVueDom(List<String> lines, List<String> parsedLines, List<String> domLines) {
        boolean domBegin = false;
        int domIndex = 0;
        int templateCount = 0;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!domBegin) {
                if (HussarUtils.isNotBlank((CharSequence)line.trim()) && (line.trim().startsWith(TEMPLATE_PRE) || line.trim().startsWith(TEMPLATE_PRE2))) {
                    domBegin = true;
                    domIndex = i;
                    ++templateCount;
                    domLines.add(line);
                    continue;
                }
                parsedLines.add(line);
                continue;
            }
            if (HussarUtils.isNotBlank((CharSequence)line.trim()) && (line.trim().startsWith(TEMPLATE_PRE) || line.trim().startsWith(TEMPLATE_PRE2))) {
                ++templateCount;
            }
            domLines.add(line);
            if (HussarUtils.equals((Object)line.trim(), (Object)TEMPLATE_SUF)) {
                --templateCount;
            }
            if (templateCount != 0 || i >= lines.size() - 1) continue;
            parsedLines.addAll(lines.subList(i + 1, lines.size()));
            break;
        }
        return domIndex;
    }

    private void dealEditorDoms(String lastPublish, String currentFile, int currentFileDomIndex, int lastPublishDomIndex, List<String> currentFileDomLines, List<String> lastPublishDomLines, Map<String, VueDomDetails> currentFileConfigDetailMap, Map<String, VueDomDetails> lastPublishConfigDetailMap, List<String> lastPublishLines) {
        EditList editList = PlainMerger.getEditList(lastPublish, currentFile);
        int currentFileIndex = 0;
        int lastPublishIndex = 0;
        for (Edit edit : editList) {
            int beginB = edit.getBeginB() - currentFileDomIndex;
            int endB = edit.getEndB() - currentFileDomIndex;
            int beginA = edit.getBeginA() - lastPublishDomIndex;
            int endA = edit.getEndA() - lastPublishDomIndex;
            int state = 0;
            if (edit.getType() == Edit.Type.INSERT) {
                state = 2;
            }
            if (edit.getType() == Edit.Type.REPLACE) {
                Map countMap2;
                ArrayList<String> currentFileTitles = new ArrayList<String>();
                for (int i = beginB; i < Math.min(endB, currentFileDomLines.size()); ++i) {
                    Pattern pattern_pre = Pattern.compile(REGEX_PRE);
                    Matcher matcher_pre = pattern_pre.matcher(currentFileDomLines.get(i));
                    if (!matcher_pre.find()) continue;
                    String componentTileName = matcher_pre.group(1);
                    currentFileTitles.add(componentTileName);
                }
                ArrayList<String> lastPublishTitles = new ArrayList<String>();
                for (int i = beginA; i < Math.min(endA, lastPublishDomLines.size()); ++i) {
                    Pattern pattern_pre = Pattern.compile(REGEX_PRE);
                    Matcher matcher_pre = pattern_pre.matcher(lastPublishDomLines.get(i));
                    if (!matcher_pre.find()) continue;
                    String componentTileName = matcher_pre.group(1);
                    lastPublishTitles.add(componentTileName);
                }
                Map countMap1 = currentFileTitles.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                int n = state = countMap1.equals(countMap2 = lastPublishTitles.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()))) ? 0 : 1;
            }
            if (currentFileIndex < currentFileDomLines.size()) {
                this.parseTitle(currentFileIndex, Math.min(beginB, currentFileDomLines.size()), currentFileDomLines, currentFileConfigDetailMap, true);
            }
            if (beginB < currentFileDomLines.size()) {
                this.parseTitle(beginB, Math.min(endB, currentFileDomLines.size()), currentFileDomLines, currentFileConfigDetailMap, state == 0);
            }
            currentFileIndex = endB;
            int n = state = state == 2 ? 0 : state;
            if (lastPublishIndex < lastPublishDomLines.size()) {
                this.parseTitle(lastPublishIndex, Math.min(beginA, lastPublishDomLines.size()), lastPublishDomLines, lastPublishConfigDetailMap, true);
            }
            if (beginA < lastPublishDomLines.size()) {
                this.parseTitle(beginA, Math.min(endA, lastPublishDomLines.size()), lastPublishDomLines, lastPublishConfigDetailMap, state == 0);
            }
            lastPublishIndex = endA;
            if (currentFileIndex < currentFileDomLines.size() || lastPublishDomIndex < lastPublishLines.size()) continue;
            break;
        }
        if (currentFileIndex < currentFileDomLines.size()) {
            this.parseTitle(currentFileIndex, currentFileDomLines.size(), currentFileDomLines, currentFileConfigDetailMap, true);
        }
        if (lastPublishIndex < lastPublishDomLines.size()) {
            this.parseTitle(lastPublishIndex, lastPublishDomLines.size(), lastPublishDomLines, lastPublishConfigDetailMap, true);
        }
    }
}

