/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.upgrade.vue.dom;

import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfig;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.jgit.diff.Edit;
import com.jxdinfo.hussar.formdesign.jgit.diff.EditList;
import com.jxdinfo.hussar.formdesign.structural.merge.util.PlainMerger;
import com.jxdinfo.hussar.formdesign.upgrade.factory.ParseCodeFactory;
import com.jxdinfo.hussar.formdesign.upgrade.model.PublishFileType;
import com.jxdinfo.hussar.formdesign.upgrade.model.UpgradeResult;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.VueDomDetails;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.VueDomPropValues;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.title.model.UpgradeTitleDetail;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.util.VueDomParseCodeUtil;
import com.jxdinfo.hussar.formdesign.upgrade.vue.parse.VueCodeParse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="com.jxdinfo.hussar.formdesign.upgrade.dom.vue.VueDomParse")
public class VueDomParse
implements VueCodeParse {
    private static final String TEMPLATE_PRE = "<template>";
    private static final String TEMPLATE_PRE2 = "<template ";
    private static final String TEMPLATE_SUF = "</template>";
    private static final String REGEX_PRE = "^\\s+<([\\w-]+)";
    private static final String REGEX_REF = "</([\\w-]+)>\\s+$";
    private static final String PUBLISH_FILE_TYPE = "VUE-DOM";

    @PostConstruct
    public void register() {
        ParseCodeFactory.registerParseTypeCode(PUBLISH_FILE_TYPE, VueDomParse.class);
    }

    @Override
    public void parseCode(UpgradeResult upgradeResult, Map<String, UpgradeConfig> configMap, Map<String, List<String>> refMap) {
        String currentFile = upgradeResult.getCurrentFile();
        String lastPublish = upgradeResult.getLastPublish();
        String currentPublish = upgradeResult.getCurrentPublish();
        List currentFileLines = CodeSplitUtil.linesOf((String)currentFile);
        List lastPublishLines = CodeSplitUtil.linesOf((String)lastPublish);
        List currentPublishLines = CodeSplitUtil.linesOf((String)currentPublish);
        ArrayList<String> currentFileDomLines = new ArrayList<String>();
        ArrayList<String> currentFileParsedLines = new ArrayList<String>();
        int currentFileDomIndex = this.parseVueDom(currentFileLines, currentFileParsedLines, currentFileDomLines);
        ArrayList<String> lastPublishDomLines = new ArrayList<String>();
        ArrayList<String> lastPublishParsedLines = new ArrayList<String>();
        int lastPublishDomIndex = this.parseVueDom(lastPublishLines, lastPublishParsedLines, lastPublishDomLines);
        ArrayList<String> currentPublishDomLines = new ArrayList<String>();
        this.parseVueDom(currentPublishLines, new ArrayList<String>(), currentPublishDomLines);
        HashMap<String, VueDomDetails> currentPublishConfigDetailMap = new HashMap<String, VueDomDetails>();
        this.parseTitle(0, currentPublishDomLines.size(), currentPublishDomLines, currentPublishConfigDetailMap, false);
        HashMap<String, VueDomDetails> currentFileConfigDetailMap = new HashMap<String, VueDomDetails>();
        HashMap<String, VueDomDetails> lastPublishConfigDetailMap = new HashMap<String, VueDomDetails>();
        this.dealEditorDoms(lastPublish, currentFile, currentFileDomIndex, lastPublishDomIndex, currentFileDomLines, lastPublishDomLines, currentFileConfigDetailMap, lastPublishConfigDetailMap, lastPublishLines);
        for (Map.Entry<String, List<String>> ref : refMap.entrySet()) {
            List<String> configIds = ref.getValue();
            if (HussarUtils.isEmpty(configIds)) continue;
            HashMap<String, Set<String>> matchCurrentPublishTitleMap = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> matchCurrentTitleMap = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> matchLastTitleMap = new HashMap<String, Set<String>>();
            VueDomPropValues currentPublishConfigDetail = this.getConfigDetailByRef(currentPublishConfigDetailMap, currentPublishLines, ref, configMap, matchCurrentPublishTitleMap);
            VueDomPropValues lastConfigDetail = this.getConfigDetailByRef(lastPublishConfigDetailMap, lastPublishDomLines, ref, configMap, matchLastTitleMap);
            if (HussarUtils.isEmpty((Object)currentPublishConfigDetail) || HussarUtils.isEmpty((Object)lastConfigDetail)) continue;
            String currentPublishLine = (String)currentPublishLines.get(currentPublishConfigDetail.getIndexPre());
            String lastLine = (String)lastPublishDomLines.get(lastConfigDetail.getIndexPre());
            String lastLineEnd = (String)lastPublishDomLines.get(lastConfigDetail.getIndexRef());
            List<UpgradeConfig> upgradeConfigs = ((List)ref.getValue()).stream().map(configMap::get).collect(Collectors.toList());
            HashMap<String, String> dynamicRemoveMap = new HashMap<String, String>();
            this.parseUpgradeDetail(upgradeConfigs, lastConfigDetail, lastPublishDomLines, currentPublishConfigDetail, PublishFileType.LAST_PUBLISH, dynamicRemoveMap);
            String lastLineUpgrade = (String)lastPublishDomLines.get(lastConfigDetail.getIndexPre());
            if (!StringUtil.equals((CharSequence)currentPublishLine, (CharSequence)lastLineUpgrade)) {
                lastPublishDomLines.set(lastConfigDetail.getIndexPre(), lastLine);
                lastPublishDomLines.set(lastConfigDetail.getIndexRef(), lastLineEnd);
                continue;
            }
            VueDomPropValues currentConfigDetail = this.getConfigDetailByRef(currentFileConfigDetailMap, currentFileDomLines, ref, configMap, matchCurrentTitleMap);
            if (HussarUtils.isEmpty((Object)currentConfigDetail)) continue;
            this.parseUpgradeDetail(upgradeConfigs, currentConfigDetail, currentFileDomLines, currentPublishConfigDetail, PublishFileType.LAST_PUBLISH, dynamicRemoveMap);
        }
        currentFileParsedLines.addAll(currentFileDomIndex, currentFileDomLines);
        StringBuilder currentFileSb = new StringBuilder();
        for (String currentFileParsedLine : currentFileParsedLines) {
            currentFileSb.append(currentFileParsedLine);
        }
        upgradeResult.setCurrentFile(currentFileSb.toString());
        lastPublishParsedLines.addAll(lastPublishDomIndex, lastPublishDomLines);
        StringBuilder lastPublishSb = new StringBuilder();
        for (String currentFileParsedLine : lastPublishParsedLines) {
            lastPublishSb.append(currentFileParsedLine);
        }
        upgradeResult.setLastPublish(lastPublishSb.toString());
    }

    private void parseUpgradeDetail(List<UpgradeConfig> upgradeConfigs, VueDomPropValues configDetail, List<String> publishDomLines, VueDomPropValues publishConfigDetail, PublishFileType publishFileType, Map<String, String> dynamicRemoveMap) {
        List upgradeTitles = upgradeConfigs.stream().filter(upgradeConfig -> StringUtil.equals((CharSequence)configDetail.getTitleName(), (CharSequence)upgradeConfig.getMatchTitle())).filter(upgradeConfig -> StringUtil.equals((CharSequence)"VUE-DOM-TITLE", (CharSequence)upgradeConfig.getUpgradeType()) && upgradeConfig.getType() == 0).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(upgradeTitles)) {
            VueDomParseCodeUtil.parseCode(configDetail, publishDomLines, (UpgradeConfig)upgradeTitles.get(0), ((UpgradeConfig)upgradeTitles.get(0)).getUpgradeType(), publishConfigDetail, publishFileType, dynamicRemoveMap);
        }
        upgradeConfigs.stream().filter(upgradeConfig -> !upgradeTitles.contains(upgradeConfig)).forEach(upgradeConfig -> VueDomParseCodeUtil.parseCode(configDetail, publishDomLines, upgradeConfig, upgradeConfig.getUpgradeType(), publishConfigDetail, publishFileType, dynamicRemoveMap));
    }

    private VueDomPropValues getConfigDetailByRef(Map<String, VueDomDetails> configDetailMap, List<String> domLines, Map.Entry<String, List<String>> ref, Map<String, UpgradeConfig> configMap, Map<String, Set<String>> matchTitleMap) {
        UpgradeConfig upgradeConfig = configMap.get(ref.getValue().get(0));
        if (HussarUtils.isEmpty((Object)upgradeConfig)) {
            return null;
        }
        Set<String> matchTitle = matchTitleMap.get(upgradeConfig.getComponentCode());
        if (HussarUtils.isEmpty(matchTitle)) {
            if (ref.getValue().size() == 1 && upgradeConfig.getType() == 0 && "VUE-DOM-TITLE".equals(upgradeConfig.getUpgradeType())) {
                UpgradeTitleDetail upgradeTitleDetail = (UpgradeTitleDetail)upgradeConfig.getUpgradeDetail().toJavaObject(UpgradeTitleDetail.class);
                matchTitle = new HashSet<String>();
                matchTitle.add(upgradeTitleDetail.getUpgradeFrom());
                matchTitle.add(upgradeTitleDetail.getUpgradeTo());
            } else {
                matchTitle = ref.getValue().stream().map(configMap::get).map(UpgradeConfig::getMatchTitle).collect(Collectors.toSet());
            }
            matchTitleMap.put(upgradeConfig.getComponentCode(), matchTitle);
        }
        for (String titleStr : matchTitle) {
            List<VueDomPropValues> vueDomDetails;
            if (HussarUtils.isEmpty((Object)configDetailMap.get(titleStr)) || HussarUtils.isEmpty(vueDomDetails = configDetailMap.get(titleStr).getConfigDetails())) continue;
            for (VueDomPropValues vueDomPropValues : vueDomDetails) {
                if (vueDomPropValues.isReplaced()) continue;
                if (HussarUtils.isEmpty((Object)vueDomPropValues.getDataValueInfo())) {
                    boolean next;
                    int indexPre = vueDomPropValues.getIndexPre();
                    String line = domLines.get(indexPre);
                    for (int i = vueDomPropValues.getIndexPreEnd(); i < line.length() && (next = vueDomPropValues.setChar(line.charAt(i), i)); ++i) {
                    }
                }
                if (!VueDomParseCodeUtil.identifyByRef(vueDomPropValues, ref.getKey(), upgradeConfig)) continue;
                vueDomPropValues.setReplaced(true);
                return vueDomPropValues;
            }
        }
        return null;
    }

    public void parseTitle(int begin, int end, List<String> domLines, Map<String, VueDomDetails> configDetailMap, boolean replace) {
        for (int j = begin; j < end; ++j) {
            String componentTileName;
            VueDomDetails vueDomDetails;
            Pattern pattern_ref;
            Matcher matcher_ref;
            Pattern pattern_pre = Pattern.compile(REGEX_PRE);
            Matcher matcher_pre = pattern_pre.matcher(domLines.get(j));
            if (matcher_pre.find()) {
                String componentTileName2 = matcher_pre.group(1);
                VueDomDetails vueDomDetails2 = configDetailMap.get(componentTileName2);
                if (HussarUtils.isEmpty((Object)vueDomDetails2)) {
                    vueDomDetails2 = new VueDomDetails();
                    configDetailMap.put(componentTileName2, vueDomDetails2);
                }
                VueDomPropValues vueDomDetail = new VueDomPropValues(j, matcher_pre.start(1), matcher_pre.end(1), replace);
                vueDomDetail.setTitleName(componentTileName2);
                vueDomDetails2.addConfigDetail(vueDomDetail);
            }
            if (!(matcher_ref = (pattern_ref = Pattern.compile(REGEX_REF)).matcher(domLines.get(j))).find() || !HussarUtils.isNotEmpty((Object)(vueDomDetails = configDetailMap.get(componentTileName = matcher_ref.group(1))))) continue;
            vueDomDetails.setEnd(j, matcher_ref.start(1), matcher_ref.end(1));
        }
    }

    private int parseVueDom(List<String> lines, List<String> parsedLines, List<String> domLines) {
        boolean domBegin = false;
        int domIndex = 0;
        int templateCount = 0;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!domBegin) {
                if (HussarUtils.isNotBlank((CharSequence)line.trim()) && (line.trim().startsWith(TEMPLATE_PRE) || line.trim().startsWith(TEMPLATE_PRE2))) {
                    domBegin = true;
                    domIndex = i;
                    ++templateCount;
                    domLines.add(line);
                    continue;
                }
                parsedLines.add(line);
                continue;
            }
            if (HussarUtils.isNotBlank((CharSequence)line.trim()) && (line.trim().startsWith(TEMPLATE_PRE) || line.trim().startsWith(TEMPLATE_PRE2))) {
                ++templateCount;
            }
            domLines.add(line);
            if (HussarUtils.equals((Object)line.trim(), (Object)TEMPLATE_SUF)) {
                --templateCount;
            }
            if (templateCount != 0 || i >= lines.size() - 1) continue;
            parsedLines.addAll(lines.subList(i + 1, lines.size()));
            break;
        }
        return domIndex;
    }

    private void dealEditorDoms(String lastPublish, String currentFile, int currentFileDomIndex, int lastPublishDomIndex, List<String> currentFileDomLines, List<String> lastPublishDomLines, Map<String, VueDomDetails> currentFileConfigDetailMap, Map<String, VueDomDetails> lastPublishConfigDetailMap, List<String> lastPublishLines) {
        EditList editList = PlainMerger.getEditList(lastPublish, currentFile);
        int currentFileIndex = 0;
        int lastPublishIndex = 0;
        for (Edit edit : editList) {
            int beginB = edit.getBeginB() - currentFileDomIndex;
            int endB = edit.getEndB() - currentFileDomIndex;
            int beginA = edit.getBeginA() - lastPublishDomIndex;
            int endA = edit.getEndA() - lastPublishDomIndex;
            int state = 0;
            if (edit.getType() == Edit.Type.INSERT) {
                state = 2;
            }
            if (edit.getType() == Edit.Type.REPLACE) {
                Map countMap2;
                ArrayList<String> currentFileTitles = new ArrayList<String>();
                for (int i = beginB; i < Math.min(endB, currentFileDomLines.size()); ++i) {
                    Pattern pattern_pre = Pattern.compile(REGEX_PRE);
                    Matcher matcher_pre = pattern_pre.matcher(currentFileDomLines.get(i));
                    if (!matcher_pre.find()) continue;
                    String componentTileName = matcher_pre.group(1);
                    currentFileTitles.add(componentTileName);
                }
                ArrayList<String> lastPublishTitles = new ArrayList<String>();
                for (int i = beginA; i < Math.min(endA, lastPublishDomLines.size()); ++i) {
                    Pattern pattern_pre = Pattern.compile(REGEX_PRE);
                    Matcher matcher_pre = pattern_pre.matcher(lastPublishDomLines.get(i));
                    if (!matcher_pre.find()) continue;
                    String componentTileName = matcher_pre.group(1);
                    lastPublishTitles.add(componentTileName);
                }
                Map countMap1 = currentFileTitles.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                int n = state = countMap1.equals(countMap2 = lastPublishTitles.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()))) ? 0 : 1;
            }
            if (currentFileIndex < currentFileDomLines.size()) {
                this.parseTitle(currentFileIndex, Math.min(beginB, currentFileDomLines.size()), currentFileDomLines, currentFileConfigDetailMap, true);
            }
            if (beginB < currentFileDomLines.size()) {
                this.parseTitle(beginB, Math.min(endB, currentFileDomLines.size()), currentFileDomLines, currentFileConfigDetailMap, state == 0);
            }
            currentFileIndex = endB;
            int n = state = state == 2 ? 0 : state;
            if (lastPublishIndex < lastPublishDomLines.size()) {
                this.parseTitle(lastPublishIndex, Math.min(beginA, lastPublishDomLines.size()), lastPublishDomLines, lastPublishConfigDetailMap, true);
            }
            if (beginA < lastPublishDomLines.size()) {
                this.parseTitle(beginA, Math.min(endA, lastPublishDomLines.size()), lastPublishDomLines, lastPublishConfigDetailMap, state == 0);
            }
            lastPublishIndex = endA;
            if (currentFileIndex < currentFileDomLines.size() || lastPublishDomIndex < lastPublishLines.size()) continue;
            break;
        }
        if (currentFileIndex < currentFileDomLines.size()) {
            this.parseTitle(currentFileIndex, currentFileDomLines.size(), currentFileDomLines, currentFileConfigDetailMap, true);
        }
        if (lastPublishIndex < lastPublishDomLines.size()) {
            this.parseTitle(lastPublishIndex, lastPublishDomLines.size(), lastPublishDomLines, lastPublishConfigDetailMap, true);
        }
    }
}

