/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.upgrade.vue.dom.util;

import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfig;
import com.jxdinfo.hussar.formdesign.upgrade.model.PublishFileType;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.DataValueInfo;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.VueDomAttributeInfo;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.model.VueDomPropValues;
import com.jxdinfo.hussar.formdesign.upgrade.vue.dom.util.VueDomParseCodeBeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VueDomParseCodeUtil {
    public static void parseCode(VueDomPropValues configDetail, List<String> domLines, UpgradeConfig upgradeConfig, String type, VueDomPropValues currentPublishConfigDetail, PublishFileType publishFileType, Map<String, String> dynamicRemoveMap) {
        try {
            VueDomParseCodeBeanUtil.getCodeParseVisitorBean(type).parseCode(configDetail, domLines, upgradeConfig, currentPublishConfigDetail, publishFileType, dynamicRemoveMap);
        }
        catch (LcdpException e) {
            throw new HussarException("Dom\u5c5e\u6027\u5904\u7406\u5931\u8d25", (Throwable)e);
        }
    }

    public static boolean identifyByRef(VueDomPropValues operator, String refStr, UpgradeConfig upgradeConfig) {
        if (HussarUtils.isEmpty(operator.getDataValueInfoMap())) {
            return false;
        }
        if (HussarUtils.isEmpty((Object)operator.getDataValueInfoMap().get("ref")) || HussarUtils.isEmpty(operator.getDataValueInfoMap().get("ref").getValueInfoMap())) {
            return VueDomParseCodeUtil.identifyExtend(upgradeConfig.getIdentifyExtend(), operator, refStr.replace("Ref", ""));
        }
        for (DataValueInfo ref : operator.getDataValueInfoMap().get("ref").getValueInfoMap().values()) {
            if (!HussarUtils.isNotBlank((CharSequence)ref.getValue()) || HussarUtils.equals((Object)ref.getValue(), (Object)refStr) || ref.getValue().contains("'" + refStr + "'")) continue;
            return false;
        }
        return true;
    }

    public static boolean identifyExtend(Map<String, String> identifyExtend, VueDomPropValues operator, String instanceKey) {
        if (HussarUtils.isEmpty(identifyExtend)) {
            return true;
        }
        if (HussarUtils.isEmpty(operator.getDataValueInfoMap())) {
            return false;
        }
        boolean matching = true;
        for (String key : identifyExtend.keySet()) {
            String regex = StringUtil.isBlank((CharSequence)instanceKey) ? "^" + identifyExtend.get(key).replaceAll("@[ID]", "\\S+") + "$" : "^" + identifyExtend.get(key).replaceAll("@[ID]", instanceKey).replaceAll(" ", "\\s") + "$";
            Pattern pattern = Pattern.compile(regex);
            VueDomAttributeInfo vueDomAttributeInfo = operator.getDataValueInfoMap().get(key);
            if (HussarUtils.isEmpty((Object)vueDomAttributeInfo) || HussarUtils.isEmpty(vueDomAttributeInfo.getValueInfoMap())) {
                matching = false;
                break;
            }
            matching = false;
            for (String value : vueDomAttributeInfo.getValueInfoMap().keySet()) {
                Matcher matcher = pattern.matcher(value);
                if (!matcher.matches()) continue;
                matching = true;
                break;
            }
            if (matching) continue;
            break;
        }
        return matching;
    }
}

