/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.structural.section.util;

import com.jxdinfo.hussar.formdesign.common.model.vuecode.Pair;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum ExtractFileType {
    DEFAULT("", "<!-- -->", "/* */", "//"),
    FOLDED("", "<#< >#>"),
    VUE("vue", "<!-- -->", "/* */", "//"),
    JAVA("java", "/* */", "//"),
    JS("js mjs", "/* */", "//"),
    XML("xml", "<!-- -->", "--");

    private static Map<String, ExtractFileType> suffixIndex;
    private final String[] suffixes;
    private final List<Pair<String>> commentDelimiters;

    private ExtractFileType(String suffixes, String ... commentDelimiters) {
        suffixes = suffixes.trim();
        this.suffixes = suffixes.isEmpty() ? new String[]{} : suffixes.split(" ");
        this.commentDelimiters = Arrays.stream(commentDelimiters).map(String::trim).map(CodeSplitUtil::fieldsDestruct).collect(Collectors.toList());
    }

    public static ExtractFileType byExtension(String path) {
        if (suffixIndex == null) {
            suffixIndex = new HashMap<String, ExtractFileType>();
            for (ExtractFileType type : ExtractFileType.values()) {
                for (String suffix : type.getSuffixes()) {
                    suffixIndex.put(suffix, type);
                }
            }
        }
        if (path == null || path.isEmpty() || path.lastIndexOf(46) < 0) {
            return DEFAULT;
        }
        String extension = path.substring(path.lastIndexOf(46) + 1);
        ExtractFileType type = suffixIndex.get(extension);
        return type != null ? type : DEFAULT;
    }

    public String wrapComment(String message) {
        Pair<String> delimiter;
        if (!((message = StringUtils.defaultString((String)message)).isEmpty() || message.endsWith("\n") || message.endsWith("\r"))) {
            message = message + System.lineSeparator();
        }
        if (((String)(delimiter = this.commentDelimiters.get(0)).getRight()).isEmpty()) {
            return CodeSplitUtil.linesOf((String)message).stream().map(line -> (String)delimiter.getLeft() + line).collect(Collectors.joining());
        }
        Pattern regexpDelimiter = Pattern.compile(Pattern.quote((String)delimiter.getLeft()) + "|" + Pattern.quote((String)delimiter.getRight()));
        return Arrays.stream(regexpDelimiter.split(message, -1)).collect(Collectors.joining((String)delimiter.getRight() + (String)delimiter.getLeft(), (String)delimiter.getLeft() + System.lineSeparator(), (String)delimiter.getRight() + System.lineSeparator()));
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    public List<Pair<String>> getCommentDelimiters() {
        return this.commentDelimiters;
    }

    static {
        suffixIndex = null;
    }
}

