/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.structural.section.container;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class ArrayStack<T>
implements Iterable<T> {
    private static final int INITIAL_CAPACITY = 8;
    private int top = 0;
    private final ArrayList<T> stack;

    public ArrayStack() {
        this(8);
    }

    public ArrayStack(int capacity) {
        this.stack = new ArrayList(capacity >= 0 ? capacity : 8);
    }

    public int size() {
        return this.top;
    }

    public void clear() {
        this.top = 0;
    }

    public void push(T value) {
        if (this.top < this.stack.size()) {
            this.stack.set(this.top++, value);
        } else {
            this.stack.add(value);
            ++this.top;
        }
    }

    public T pop() {
        if (this.top <= 0) {
            throw new ArrayIndexOutOfBoundsException("stack underflow");
        }
        return this.stack.get(--this.top);
    }

    public List<T> pop(int n) {
        if (this.top < n || n < 0) {
            throw new ArrayIndexOutOfBoundsException("pop amount is negative or too large");
        }
        ArrayList<T> copy = new ArrayList<T>(this.stack.subList(this.top - n, this.top));
        this.top -= n;
        return copy;
    }

    public T peek() {
        return this.peek(0);
    }

    public T peek(int offset) {
        if (this.top <= offset || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("peek offset out of range");
        }
        int index = this.top - offset - 1;
        return this.stack.get(index);
    }

    public int search(T value) {
        for (int i = 0; i < this.top; ++i) {
            T current = this.stack.get(this.top - i - 1);
            if (!Objects.equals(value, current)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<T> iterator() {
        return this.stack.subList(0, this.top).iterator();
    }

    public Stream<T> stream() {
        return this.stack.subList(0, this.top).stream();
    }
}

