/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.structural.section.util;

import com.jxdinfo.hussar.formdesign.common.model.vuecode.CommentDirective;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Pair;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.structural.section.container.ArrayStack;
import com.jxdinfo.hussar.formdesign.structural.section.model.index.CodeIndex;
import com.jxdinfo.hussar.formdesign.structural.section.model.index.CodeIndexLink;
import com.jxdinfo.hussar.formdesign.structural.section.model.result.ExtractFailure;
import com.jxdinfo.hussar.formdesign.structural.section.model.result.ExtractResult;
import com.jxdinfo.hussar.formdesign.structural.section.model.section.CodeSection;
import com.jxdinfo.hussar.formdesign.structural.section.model.section.Placeholder;
import com.jxdinfo.hussar.formdesign.structural.section.model.section.RootSection;
import com.jxdinfo.hussar.formdesign.structural.section.model.section.TextSection;
import com.jxdinfo.hussar.formdesign.structural.section.model.section.UserSection;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;

public class SectionExtractor {
    private static final List<String> SUPPORTED_VERBS = Arrays.asList("begin", "end", "placeholder");
    private static final Set<String> SUPPORTED_BEGIN_FLAGS = new HashSet<String>(Arrays.asList("merge", "m"));
    private String path;
    private final List<Pair<String>> commentDelimiters;
    private List<String> lines;
    private List<CommentDirective> directives;
    private ExtractResult result;
    private ExtractorStack stack;
    private int textStart;
    private CommentDirective firstDelimiter;
    private CommentDirective firstPlaceholder;

    private SectionExtractor(List<Pair<String>> commentDelimiters) {
        this.commentDelimiters = commentDelimiters != null ? commentDelimiters : ExtractFileType.DEFAULT.getCommentDelimiters();
    }

    public static ExtractResult extract(String path, String content, List<Pair<String>> commentDelimiters) {
        SectionExtractor extractor = new SectionExtractor(commentDelimiters);
        return extractor.performExtraction(path, content);
    }

    private ExtractResult performExtraction(String path, String content) {
        this.path = path;
        this.lines = CodeSplitUtil.linesOf((String)content);
        this.result = new ExtractResult();
        this.result.setPath(path);
        this.searchDirectives();
        this.textStart = 1;
        this.stack = new ExtractorStack();
        this.firstDelimiter = null;
        this.firstPlaceholder = null;
        LinkedList<CommentDirective> directiveStack = new LinkedList<CommentDirective>();
        int preDiffRow = 0;
        HashMap<String, CodeIndexLink> codeIndexMap = new HashMap<String, CodeIndexLink>();
        CodeIndexLink codeIndexList = new CodeIndexLink();
        codeIndexMap.put("#", codeIndexList);
        for (CommentDirective directive : this.directives) {
            if ("begin".equals(directive.getVerb())) {
                this.checkDirectiveConflict(directive);
                this.extractTextSectionBeforeDirective(directive);
                this.stack.enter(directive);
                directiveStack.addLast(directive);
                continue;
            }
            if ("end".equals(directive.getVerb())) {
                this.checkDirectiveConflict(directive);
                if (this.stack.level() <= 0) {
                    this.reportFatal("\u9884\u671f\u5916\u7684\u7ed3\u675f\u5b9a\u754c\u7b26\u5c06\u88ab\u5ffd\u7565", directive.getVerb(), directive);
                    continue;
                }
                this.extractTextSectionBeforeDirective(directive);
                ExtractorStack.Frame frame = this.stack.leave();
                CommentDirective begin = frame.getDirective();
                this.checkDirectives(begin, directive);
                this.extractUserSection(begin, directive.getLine(), false, frame.getChildren());
                CommentDirective directiveOut = (CommentDirective)directiveStack.removeLast();
                if (directiveStack.size() != 0) continue;
                int index = directiveOut.getLine() - preDiffRow;
                int addNumber = directive.getLine() - directiveOut.getLine();
                preDiffRow += directive.getLine() - directiveOut.getLine();
                CodeIndex codeIndex = new CodeIndex(index, addNumber);
                codeIndexList.add(codeIndex);
                continue;
            }
            if ("placeholder".equals(directive.getVerb())) {
                this.checkDirectiveConflict(directive);
                this.extractTextSectionBeforeDirective(directive);
                this.checkPlaceholder(directive);
                this.extractPlaceholder(directive);
                continue;
            }
            this.reportWarning("\u4e0d\u652f\u6301\u7684\u5b9a\u754c\u7b26\u5c06\u88ab\u5ffd\u7565", directive.getVerb(), directive);
        }
        this.result.setCodeIndexMap(codeIndexMap);
        if (this.lines.size() >= this.textStart) {
            this.extractTextSection(this.textStart, this.lines.size());
        }
        if (this.stack.level() > 0) {
            this.reportFatal("\u7f3a\u5c11\u7ed3\u675f\u5b9a\u754c\u7b26", "\u5f00\u59cb\u5b9a\u754c\u7b26\u7f3a\u5c11\u7ed3\u675f " + this.stack.inspectDirectiveStack(), this.stack.peekDirective());
            while (this.stack.level() > 0) {
                ExtractorStack.Frame frame = this.stack.leave();
                CommentDirective begin = frame.getDirective();
                this.checkDirectives(begin, null);
                this.extractUserSection(begin, this.lines.size(), true, frame.getChildren());
            }
        }
        List<CodeSection> children = this.stack.finish();
        this.result.setRoot(new RootSection(this.lines.size() > 0 ? 1 : 0, this.lines.size(), children));
        return this.result;
    }

    private void searchDirectives() {
        ArrayList<CommentDirective> directives = new ArrayList<CommentDirective>();
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i).trim();
            boolean isComment = false;
            for (Pair<String> pair : this.commentDelimiters) {
                if (!line.startsWith((String)pair.getLeft()) || !line.endsWith((String)pair.getRight())) continue;
                isComment = true;
                line = line.substring(((String)pair.getLeft()).length(), line.length() - ((String)pair.getRight()).length()).trim();
                break;
            }
            if (!isComment || !line.startsWith("@")) continue;
            String verb = (String)CodeSplitUtil.fieldsDestruct((String)line.substring("@".length())).getLeft();
            if (!SUPPORTED_VERBS.stream().anyMatch(supported -> supported.equals(verb))) continue;
            CommentDirective directive = CommentDirective.parse((String)line);
            directive.setLine(i + 1);
            directives.add(directive);
        }
        this.directives = directives;
    }

    private void checkDirectiveConflict(CommentDirective directive) {
        if ("placeholder".equals(directive.getVerb())) {
            if (this.firstDelimiter != null) {
                this.reportFatal("\u5360\u4f4d\u7b26\u548c\u9884\u7559\u533a\u57df\u4e0d\u80fd\u6df7\u7528", this.firstDelimiter.getVerb() + "@" + this.firstDelimiter.getLine(), directive);
            }
            if (this.firstPlaceholder == null) {
                this.firstPlaceholder = directive;
            }
        } else {
            if (this.firstPlaceholder != null) {
                this.reportFatal("\u5360\u4f4d\u7b26\u548c\u9884\u7559\u533a\u57df\u4e0d\u80fd\u6df7\u7528", this.firstPlaceholder.getVerb() + "@" + this.firstPlaceholder.getLine(), directive);
            }
            if (this.firstDelimiter == null) {
                this.firstDelimiter = directive;
            }
        }
    }

    private boolean shouldMerge(CommentDirective begin) {
        return begin.getFlag("merge") != null || begin.getFlag("m") != null;
    }

    private void checkDirectives(CommentDirective begin, CommentDirective end) {
        Object arguments;
        if (!"begin".equals(begin.getVerb())) {
            this.reportWarning("\u5f00\u59cb\u5b9a\u754c\u7b26\u6307\u4ee4\u540d\u4e0d\u89c4\u8303", begin.getVerb() + " != " + "begin", begin);
        }
        if (begin.getArgumentCount() == 0) {
            this.reportFatal("\u672a\u6307\u5b9a\u6807\u8bc6\u7b26", "begin", begin);
        } else if (begin.getArgumentCount() > 1) {
            arguments = IntStream.range(0, begin.getArgumentCount()).mapToObj(arg_0 -> ((CommentDirective)begin).getArgument(arg_0)).collect(Collectors.joining(" "));
            this.reportWarning("\u5f00\u59cb\u5b9a\u754c\u7b26\u53c2\u6570\u8fc7\u591a", (String)arguments, begin);
        }
        for (String flag : begin.getFlagNames()) {
            if (SUPPORTED_BEGIN_FLAGS.contains(flag)) continue;
            this.reportWarning("\u4e0d\u652f\u6301\u7684\u5f00\u59cb\u5b9a\u754c\u7b26\u53c2\u6570", flag, begin);
            break;
        }
        if (end == null) {
            return;
        }
        if (!"end".equals(end.getVerb())) {
            this.reportWarning("\u7ed3\u675f\u5b9a\u754c\u7b26\u6307\u4ee4\u540d\u4e0d\u89c4\u8303", end.getVerb() + " != " + "end", end);
        }
        if (begin.getArgumentCount() == 1 && end.getArgumentCount() == 1 && !Objects.equals(end.getArgument(0), begin.getArgument(0))) {
            this.reportWarning("\u7ed3\u675f\u5b9a\u754c\u7b26\u7684\u6807\u8bc6\u7b26\u4e0e\u5f00\u59cb\u5b9a\u754c\u7b26\u4e0d\u5339\u914d", end.getArgument(0) + " != " + begin.getArgument(0), end);
        }
        if (end.getArgumentCount() > 1) {
            arguments = IntStream.range(0, end.getArgumentCount()).mapToObj(arg_0 -> ((CommentDirective)end).getArgument(arg_0)).collect(Collectors.joining(" "));
            this.reportWarning("\u7ed3\u675f\u5b9a\u754c\u7b26\u53c2\u6570\u8fc7\u591a", (String)arguments, end);
        }
        if (end.getFlagCount() > 0) {
            String flags = String.join((CharSequence)", ", end.getFlagNames());
            this.reportWarning("\u7ed3\u675f\u5b9a\u754c\u7b26\u4e0d\u652f\u6301\u4f20\u9012\u53c2\u6570", flags, end);
        }
    }

    private void checkPlaceholder(CommentDirective placeholder) {
        if (!"placeholder".equals(placeholder.getVerb())) {
            this.reportWarning("\u5f00\u59cb\u5b9a\u754c\u7b26\u6307\u4ee4\u540d\u4e0d\u89c4\u8303", placeholder.getVerb() + " != " + "placeholder", placeholder);
        }
        if (placeholder.getArgumentCount() == 0) {
            this.reportFatal("\u672a\u6307\u5b9a\u6807\u8bc6\u7b26", "placeholder", placeholder);
        } else if (placeholder.getArgumentCount() > 1) {
            String arguments = IntStream.range(0, placeholder.getArgumentCount()).mapToObj(arg_0 -> ((CommentDirective)placeholder).getArgument(arg_0)).collect(Collectors.joining(" "));
            this.reportWarning("\u5360\u4f4d\u7b26\u53c2\u6570\u8fc7\u591a", arguments, placeholder);
        }
        if (placeholder.getFlagCount() > 0) {
            String flags = String.join((CharSequence)", ", placeholder.getFlagNames());
            this.reportWarning("\u5360\u4f4d\u7b26\u4e0d\u652f\u6301\u4f20\u9012\u53c2\u6570", flags, placeholder);
        }
    }

    private void extractTextSectionBeforeDirective(CommentDirective directive) {
        if (directive.getLine() - 1 >= this.textStart) {
            this.extractTextSection(this.textStart, directive.getLine() - 1);
        }
        this.textStart = directive.getLine() + 1;
    }

    private void extractTextSection(int start, int end) {
        String content = String.join((CharSequence)"", this.lines.subList(start - 1, end));
        TextSection section = new TextSection(start, end, content);
        this.stack.push(section);
    }

    private void extractUserSection(CommentDirective begin, int end, boolean missEndLine, List<CodeSection> children) {
        boolean merge = this.shouldMerge(begin);
        String id = StringUtils.defaultString((String)begin.getArgument(0));
        String beginLine = this.lines.get(begin.getLine() - 1);
        String endLine = missEndLine ? null : this.lines.get(end - 1);
        UserSection section = new UserSection(begin.getLine(), end, id, merge, beginLine, endLine, children);
        this.stack.push(section);
    }

    private void extractPlaceholder(CommentDirective placeholder) {
        int line = placeholder.getLine();
        String reference = StringUtils.defaultString((String)placeholder.getArgument(0));
        String placeholderLine = this.lines.get(line - 1);
        Placeholder section = new Placeholder(line, line, reference, placeholderLine);
        this.stack.push(section);
    }

    private void reportFatal(String type, String detail, CommentDirective directive) {
        this.result.addFailure(ExtractFailure.fatal(type + ": " + detail + " (" + directive.getVerb() + "@" + this.path + ":" + directive.getLine() + ")"));
    }

    private void reportWarning(String type, String detail, CommentDirective directive) {
        this.result.addFailure(ExtractFailure.warning(type + ": " + detail + " (" + directive.getVerb() + "@" + this.path + ":" + directive.getLine() + ")"));
    }

    private static class ExtractorStack {
        private final ArrayStack<CommentDirective> directives = new ArrayStack();
        private final ArrayStack<CodeSection> operands = new ArrayStack();

        private ExtractorStack() {
        }

        public int level() {
            return this.directives.size();
        }

        public void enter(CommentDirective directive) {
            this.directives.push(directive);
            this.operands.push(null);
        }

        public Frame leave() {
            CommentDirective directive = this.directives.pop();
            List<CodeSection> children = this.operands.pop(this.operands.search(null));
            this.operands.pop();
            return new Frame(directive, children);
        }

        public void push(CodeSection child) {
            this.operands.push(child);
        }

        public List<CodeSection> finish() {
            if (this.directives.size() > 0) {
                throw new IllegalStateException("finish not in root level");
            }
            return this.operands.pop(this.operands.size());
        }

        public String inspectDirectiveStack() {
            return this.directives.stream().map(cmd -> cmd.getVerb() + "@" + cmd.getLine()).collect(Collectors.joining(", "));
        }

        public CommentDirective peekDirective() {
            return this.directives.peek();
        }

        public static class Frame {
            private CommentDirective directive;
            private List<CodeSection> children;

            public Frame() {
            }

            public Frame(CommentDirective directive, List<CodeSection> children) {
                this.directive = directive;
                this.children = children;
            }

            public CommentDirective getDirective() {
                return this.directive;
            }

            public void setDirective(CommentDirective directive) {
                this.directive = directive;
            }

            public List<CodeSection> getChildren() {
                return this.children;
            }

            public void setChildren(List<CodeSection> children) {
                this.children = children;
            }
        }
    }
}

