/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.structural.section.model.result;

import com.jxdinfo.hussar.formdesign.structural.section.model.index.CodeIndexLink;
import com.jxdinfo.hussar.formdesign.structural.section.model.result.ExtractFailure;
import com.jxdinfo.hussar.formdesign.structural.section.model.section.CodeSection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ExtractResult {
    private String path;
    private CodeSection root;
    private Map<String, CodeSection> idTable;
    private List<ExtractFailure> failures;
    private Map<String, CodeIndexLink> codeIndexMap;

    public void setCodeIndexMap(Map<String, CodeIndexLink> codeIndexMap) {
        this.codeIndexMap = codeIndexMap;
    }

    public Map<String, CodeIndexLink> getCodeIndexMap() {
        return this.codeIndexMap;
    }

    public boolean containsAnyFailure() {
        return this.failures != null && this.failures.size() > 0;
    }

    public boolean containsFatalFailure() {
        return this.failures != null && this.failures.stream().anyMatch(ExtractFailure::isFatal);
    }

    public String assembleAllFailures() {
        if (this.failures == null) {
            return "";
        }
        return this.failures.stream().map(failure -> (failure.isFatal() ? "\u9519\u8bef: " : "\u8b66\u544a: ") + failure.getMessage()).collect(Collectors.joining(System.lineSeparator()));
    }

    public String assembleFatalFailures() {
        if (this.failures == null) {
            return "";
        }
        return this.failures.stream().filter(ExtractFailure::isFatal).map(ExtractFailure::getMessage).collect(Collectors.joining(System.lineSeparator()));
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public CodeSection getRoot() {
        return this.root;
    }

    public void setRoot(CodeSection root) {
        this.root = root;
        this.idTable = new HashMap<String, CodeSection>();
        if (root == null) {
            return;
        }
        this.idTable.put("#", root);
        root.traverse(section -> {
            String id = section.getId();
            if (id == null) {
                return true;
            }
            CodeSection existed = this.idTable.get(id);
            if (existed != null) {
                this.addFailure(ExtractFailure.warning("\u9884\u7559\u533a\u57df\u6807\u8bc6\u7b26\u51b2\u7a81: " + section.getId() + " == " + existed.getId() + " (@" + this.path + ":" + section.getStart() + "," + existed.getStart() + ")"));
            }
            this.idTable.put(id, (CodeSection)section);
            return true;
        });
    }

    public List<ExtractFailure> getFailures() {
        return this.failures;
    }

    public void addFailure(ExtractFailure failure) {
        if (this.failures == null) {
            this.failures = new ArrayList<ExtractFailure>();
        }
        this.failures.add(failure);
    }

    public String getPosition(String id) {
        CodeSection section;
        CodeSection codeSection = section = this.idTable != null ? this.idTable.get(id) : null;
        if (section == null) {
            return "<\u4e0d\u5b58\u5728\u533a\u57df: " + id + "@" + this.path + ">";
        }
        return section.getId() + "@" + this.path + ":" + section.getPosition();
    }

    public CodeSection getSection(String id) {
        return this.idTable != null ? this.idTable.get(id) : null;
    }
}

