/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.upgrade.util;

import com.jxdinfo.hussar.formdesign.common.formatter.CodeFormatter;
import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfig;
import com.jxdinfo.hussar.formdesign.common.model.upgrade.UpgradeConfigInfo;
import com.jxdinfo.hussar.formdesign.upgrade.model.UpgradeResult;
import com.jxdinfo.hussar.formdesign.upgrade.vue.util.VueParseCodeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;

public class CodeParseUtil {
    public static UpgradeResult parseVueCode(String currentFile, String lastPublish, String lastFile, String currentPublish, UpgradeConfigInfo upgradeConfigInfo, boolean hasFormatter) {
        if (HussarUtils.isNotEmpty((Object)upgradeConfigInfo) && HussarUtils.isNotEmpty((Object)upgradeConfigInfo.getUpgradeConfigs())) {
            if (!hasFormatter) {
                lastPublish = CodeFormatter.formatterHtml((String)lastPublish, (String)"vue").getCodeFormatCode();
                currentFile = CodeFormatter.formatterHtml((String)currentFile, (String)"vue").getCodeFormatCode();
                lastFile = CodeFormatter.formatterHtml((String)lastFile, (String)"vue").getCodeFormatCode();
            }
            UpgradeResult upgradeResult = new UpgradeResult(currentFile, lastPublish, lastFile, currentPublish);
            HashMap<String, HashMap<String, UpgradeConfig>> map = new HashMap<String, HashMap<String, UpgradeConfig>>();
            for (UpgradeConfig upgradeConfig : upgradeConfigInfo.getUpgradeConfigs()) {
                HashMap<String, UpgradeConfig> upgradeConfigMap = (HashMap<String, UpgradeConfig>)map.get(upgradeConfig.getPublishFileType());
                if (HussarUtils.isEmpty((Object)upgradeConfigMap)) {
                    upgradeConfigMap = new HashMap<String, UpgradeConfig>();
                }
                upgradeConfigMap.put(upgradeConfig.getUpgradeId(), upgradeConfig);
                map.put(upgradeConfig.getPublishFileType(), upgradeConfigMap);
            }
            for (String key : map.keySet()) {
                VueParseCodeUtil.parseCode(key, upgradeResult, (Map)map.get(key), upgradeConfigInfo.getRefMap());
            }
            return upgradeResult;
        }
        return null;
    }
}

