/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.structural.merge.util;

import com.jxdinfo.hussar.formdesign.common.model.vuecode.CommentDirective;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Pair;
import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.structural.merge.util.MergeInfoLineUtil;
import com.jxdinfo.hussar.formdesign.structural.merge.util.ParseVueMethodsUtil;
import com.jxdinfo.hussar.formdesign.structural.merge.util.PlainMerger;
import com.jxdinfo.hussar.formdesign.structural.merge.util.StructuralMergeException;
import com.jxdinfo.hussar.formdesign.structural.model.MergeConfig;
import com.jxdinfo.hussar.formdesign.structural.model.MergeDetail;
import com.jxdinfo.hussar.formdesign.structural.model.MergeInfo;
import com.jxdinfo.hussar.formdesign.structural.model.MergePlaceHolder;
import com.jxdinfo.hussar.formdesign.structural.section.model.index.CodeIndex;
import com.jxdinfo.hussar.formdesign.structural.section.model.index.CodeIndexLink;
import com.jxdinfo.hussar.formdesign.structural.section.model.result.ExtractResult;
import com.jxdinfo.hussar.formdesign.structural.section.model.section.CodeSection;
import com.jxdinfo.hussar.formdesign.structural.section.model.section.RootSection;
import com.jxdinfo.hussar.formdesign.structural.section.model.section.UserSection;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import com.jxdinfo.hussar.formdesign.structural.section.util.SectionExtractor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructuralMerger {
    private static final Logger logger = LoggerFactory.getLogger(StructuralMerger.class);
    private static final Pattern REGEXP_INDENT_IGNORE_LINE = Pattern.compile("\\s*(<#<.+>#>)?\\s*");
    private final String path;
    private final ExtractFileType type;
    private final ExtractResult lastPublishEx;
    private final ExtractResult currentFileEx;
    private final ExtractResult currentPublishEx;
    private final ExtractResult lastFileEx;
    private final Map<String, Optional<Result>> cache = new HashMap<String, Optional<Result>>();
    private final MergeConfig mergeConfig;

    private StructuralMerger(String path, ExtractFileType type, String lastPublish, String currentFile, String currentPublish, String lastFile, MergeConfig mergeConfig) throws StructuralMergeException {
        this.path = path;
        this.type = type;
        this.lastPublishEx = SectionExtractor.extract(path + "?type=last-publish", lastPublish, type.getCommentDelimiters());
        this.currentFileEx = SectionExtractor.extract(path + "?type=current-file", currentFile, type.getCommentDelimiters());
        this.currentPublishEx = SectionExtractor.extract(path + "?type=current-publish", currentPublish, type.getCommentDelimiters());
        this.lastFileEx = SectionExtractor.extract(path + "?type=last-file", lastFile, type.getCommentDelimiters());
        this.mergeConfig = mergeConfig;
        String failures = "";
        if (this.lastPublishEx.containsAnyFailure()) {
            failures = failures + this.lastPublishEx.assembleAllFailures();
        }
        if (this.currentFileEx.containsAnyFailure()) {
            failures = failures + this.currentFileEx.assembleAllFailures();
        }
        if (this.currentPublishEx.containsAnyFailure()) {
            failures = failures + this.currentPublishEx.assembleAllFailures();
        }
        if (!failures.isEmpty()) {
            throw new StructuralMergeException("\u5206\u6790\u5b9a\u754c\u7b26\u5931\u8d25\uff1a" + System.lineSeparator() + failures);
        }
    }

    public static Result hybridMerge(String path, ExtractFileType type, String lastPublish, String currentFile, String currentPublish, String lastFile) {
        return StructuralMerger.hybridMerge(path, type, lastPublish, currentFile, currentPublish, lastFile, new MergeConfig());
    }

    public static Result hybridMerge(String path, ExtractFileType type, String lastPublish, String currentFile, String currentPublish, String lastFile, MergeConfig mergeConfig) {
        try {
            Result result = new Result();
            result = StructuralMerger.merge(path, type, lastPublish, currentFile, currentPublish, lastFile, mergeConfig);
            result.setCurrentFile(currentFile);
            return result;
        }
        catch (StructuralMergeException e) {
            logger.warn("\u7ed3\u6784\u5316\u4e09\u8def\u5408\u5e76\u51fa\u9519\uff0c\u56de\u6eda\u81f3\u666e\u901a\u4e09\u8def\u5408\u5e76", (Throwable)e);
            PlainMerger.Result plainResult = PlainMerger.merge(lastPublish, currentFile, currentPublish, lastFile);
            String message = e.getMessage();
            String failures = StructuralMerger.checkSectionExtract(path, true, type, plainResult.getMerged()) + StructuralMerger.checkSectionExtract(path, false, type, plainResult.getConflicts());
            Result result = new Result();
            result.setConflicted(plainResult.isConflicted());
            result.setMerged(plainResult.getMerged());
            result.setConflicts(plainResult.getConflicts());
            result.setMergeInfo(plainResult.getMergeInfo());
            result.setBaseCode(plainResult.getBaseCode());
            if (!failures.isEmpty()) {
                String report = "\u8bf7\u6ce8\u610f\uff1a\u5c1d\u8bd5\u8fdb\u884c\u7ed3\u6784\u5316\u4e09\u8def\u5408\u5e76\u5931\u8d25\uff0c\u5efa\u8bae\u7ec8\u6b62\u53d1\u5e03\u540e\u68c0\u67e5\u5f53\u524dvue\u6587\u4ef6\u4e2d\u7684\u5b9a\u754c\u7b26\uff0c\u5e76\u5728\u4fee\u6539\u540e\u91cd\u65b0\u53d1\u5e03\u3002" + System.lineSeparator();
                result.setCurrentFile(type.wrapComment(report) + currentFile);
                result.setConflicted(true);
                String[] lines = type.wrapComment(report).split("\r\n|\r|\n");
                MergeInfoLineUtil.rectifyLineNumber(result.getMergeInfo().getCurrentFileDetail(), -1, lines.length);
            } else {
                result.setCurrentFile(currentFile);
            }
            return result;
        }
    }

    public static Result merge(String path, ExtractFileType type, String lastPublish, String currentFile, String currentPublish, String lastFile, MergeConfig mergeConfig) throws StructuralMergeException {
        StructuralMerger merger = new StructuralMerger(path, type, lastPublish, currentFile, currentPublish, lastFile, mergeConfig);
        return merger.require("#");
    }

    private Result require(String id) throws StructuralMergeException {
        String failures;
        CodeSection delimiterSource;
        if (this.cache.containsKey(id)) {
            Optional<Result> cached = this.cache.get(id);
            if (!cached.isPresent()) {
                throw new StructuralMergeException("\u68c0\u6d4b\u5230\u5faa\u73af\u4f9d\u8d56 " + id);
            }
            return cached.get();
        }
        this.cache.put(id, Optional.empty());
        CodeSection lastPublishSection = this.lastPublishEx.getSection(id);
        CodeSection currentFileSection = this.currentFileEx.getSection(id);
        CodeSection currentPublishSection = this.currentPublishEx.getSection(id);
        CodeSection lastFileSection = this.lastFileEx.getSection(id);
        if (lastPublishSection == null && currentFileSection == null && currentPublishSection == null) {
            throw new StructuralMergeException("\u4f9d\u8d56\u7684\u533a\u6bb5\u4e0d\u5b58\u5728 " + id);
        }
        boolean mergeEnabled = true;
        String beginLine = "";
        String endLine = "";
        CodeSection codeSection = currentPublishSection != null ? currentPublishSection : (delimiterSource = lastPublishSection != null ? lastPublishSection : currentFileSection);
        if (delimiterSource instanceof UserSection) {
            UserSection userSection = (UserSection)delimiterSource;
            mergeEnabled = userSection.isMerge();
            beginLine = StringUtils.defaultString((String)userSection.getBeginLine());
            if (StructuralMerger.missNewline(beginLine)) {
                beginLine = beginLine + System.lineSeparator();
            }
            if (StructuralMerger.missNewline(endLine = StringUtils.defaultString((String)userSection.getEndLine()))) {
                endLine = endLine + System.lineSeparator();
            }
        } else if (!(delimiterSource instanceof RootSection)) {
            throw new StructuralMergeException("\u533a\u6bb5\u7c7b\u578b\u4e0d\u652f\u6301\u63d0\u53d6\u5b9a\u754c\u7b26 " + delimiterSource.getClass().getName());
        }
        String lastPublishFolded = this.fold(lastPublishSection);
        String currentFileFolded = this.fold(currentFileSection);
        String currentPublishFolded = this.fold(currentPublishSection);
        String lastFileFolded = this.fold(lastFileSection);
        if ("#".equals(id) && this.mergeConfig.isVueMethod()) {
            lastPublishFolded = ParseVueMethodsUtil.parseVueMethods(lastPublishFolded);
            lastFileFolded = ParseVueMethodsUtil.parseVueMethods(lastFileFolded);
            currentFileFolded = ParseVueMethodsUtil.parseVueMethods(currentFileFolded);
            currentPublishFolded = ParseVueMethodsUtil.parseVueMethods(currentPublishFolded);
        }
        PlainMerger.Result foldedResult = this.mergeText(mergeEnabled, lastPublishFolded, currentFileFolded, currentPublishFolded, lastFileFolded);
        boolean conflicted = foldedResult.isConflicted();
        StringBuilder baseCodeBuilder = new StringBuilder();
        String baseCodeIndent = CodeSplitUtil.indentOf((String)foldedResult.getBaseCode(), line -> REGEXP_INDENT_IGNORE_LINE.matcher((CharSequence)line).matches());
        baseCodeBuilder.append(beginLine.isEmpty() || baseCodeIndent.isEmpty() ? beginLine : baseCodeIndent + CodeSplitUtil.stripIndent((String)beginLine));
        conflicted |= this.unfold(baseCodeBuilder, id, true, foldedResult.getBaseCode());
        if (StructuralMerger.missNewline(baseCodeBuilder) && !endLine.isEmpty()) {
            baseCodeBuilder.append(System.lineSeparator());
        }
        baseCodeBuilder.append(endLine.isEmpty() || baseCodeIndent.isEmpty() ? endLine : baseCodeIndent + CodeSplitUtil.stripIndent((String)endLine));
        String baseCode = baseCodeBuilder.toString();
        List<MergePlaceHolder> placeHolders = null;
        if (HussarUtils.equals((Object)id, (Object)"#")) {
            CodeIndexLink lastCodeIndexList = SectionExtractor.extract(this.path + "?type=last-publish", baseCode, this.type.getCommentDelimiters()).getCodeIndexMap().get(id);
            CodeIndexLink lastPublishCodeIndexLink = this.lastPublishEx.getCodeIndexMap().get(id);
            CodeIndexLink currentFileCodeIndexLink = this.currentFileEx.getCodeIndexMap().get(id);
            CodeIndexLink currentPublishCodeIndexLink = this.currentPublishEx.getCodeIndexMap().get(id);
            if (this.mergeConfig.isVueMethod()) {
                this.removeMethodLine(lastPublishFolded, lastCodeIndexList);
                this.removeMethodLine(lastPublishFolded, lastPublishCodeIndexLink);
                baseCode = this.removeMethodLine(baseCode, new CodeIndexLink());
                this.removeMethodLine(currentFileFolded, currentFileCodeIndexLink);
                this.removeMethodLine(currentPublishFolded, currentPublishCodeIndexLink);
            }
            if (conflicted && this.mergeConfig.isAllMerge()) {
                placeHolders = this.delimiterConflictAnalyse(foldedResult, currentPublishFolded, id);
            }
            List<MergeDetail> lastPublishDetail = foldedResult.getMergeInfo().getLastPublishDetail();
            this.reviseIndex(lastPublishDetail, lastCodeIndexList, lastCodeIndexList);
            List<MergeDetail> currentFileDetail = foldedResult.getMergeInfo().getCurrentFileDetail();
            this.reviseIndex(currentFileDetail, currentFileCodeIndexLink, lastCodeIndexList);
            List<MergeDetail> currentPublishDetail = foldedResult.getMergeInfo().getCurrentPublishDetail();
            this.reviseIndex(currentPublishDetail, currentPublishCodeIndexLink, lastCodeIndexList);
        }
        StringBuilder mergedBuilder = new StringBuilder();
        String mergedIndent = CodeSplitUtil.indentOf((String)foldedResult.getMerged(), line -> REGEXP_INDENT_IGNORE_LINE.matcher((CharSequence)line).matches());
        mergedBuilder.append(beginLine.isEmpty() || mergedIndent.isEmpty() ? beginLine : mergedIndent + CodeSplitUtil.stripIndent((String)beginLine));
        conflicted |= this.unfold(mergedBuilder, id, true, foldedResult.getMerged());
        if (StructuralMerger.missNewline(mergedBuilder) && !endLine.isEmpty()) {
            mergedBuilder.append(System.lineSeparator());
        }
        mergedBuilder.append(endLine.isEmpty() || mergedIndent.isEmpty() ? endLine : mergedIndent + CodeSplitUtil.stripIndent((String)endLine));
        String merged = mergedBuilder.toString();
        StringBuilder conflictsBuilder = new StringBuilder();
        String conflictsIndent = CodeSplitUtil.indentOf((String)foldedResult.getConflicts(), line -> REGEXP_INDENT_IGNORE_LINE.matcher((CharSequence)line).matches());
        conflictsBuilder.append(beginLine.isEmpty() || conflictsIndent.isEmpty() ? beginLine : conflictsIndent + CodeSplitUtil.stripIndent((String)beginLine));
        conflicted |= this.unfold(conflictsBuilder, id, false, foldedResult.getConflicts());
        if (StructuralMerger.missNewline(conflictsBuilder) && !endLine.isEmpty()) {
            conflictsBuilder.append(System.lineSeparator());
        }
        conflictsBuilder.append(endLine.isEmpty() || conflictsIndent.isEmpty() ? endLine : conflictsIndent + CodeSplitUtil.stripIndent((String)endLine));
        String conflicts = conflictsBuilder.toString();
        if (HussarUtils.equals((Object)id, (Object)"#") && this.mergeConfig.isVueMethod()) {
            merged = this.removeMethodLine(merged, new CodeIndexLink());
            conflicts = this.removeMethodLine(conflicts, new CodeIndexLink());
        }
        if (!(failures = StructuralMerger.checkSectionExtract(this.path, true, this.type, merged) + StructuralMerger.checkSectionExtract(this.path, false, this.type, conflicts)).isEmpty()) {
            throw new StructuralMergeException("\u68c0\u67e5\u5408\u5e76\u7ed3\u679c\u65f6\u62a5\u9519\uff1a" + System.lineSeparator() + failures);
        }
        Result result = new Result();
        result.setConflicted(conflicted);
        result.setMerged(merged);
        result.setConflicts(conflicts);
        result.setBaseCode(baseCode);
        result.setMergeInfo(foldedResult.getMergeInfo());
        result.setPlaceHolders(placeHolders);
        this.cache.put(id, Optional.of(result));
        return result;
    }

    private String removeMethodLine(String file, CodeIndexLink codeIndexLink) {
        List codeLine = CodeSplitUtil.linesOf((String)file);
        ArrayList<String> newCodeLine = new ArrayList<String>();
        for (int i = 0; i < codeLine.size(); ++i) {
            String code = (String)codeLine.get(i);
            Pattern pattern = Pattern.compile(ParseVueMethodsUtil.REGEX, 32);
            Matcher matcher = pattern.matcher(code);
            if (matcher.matches()) {
                codeIndexLink.addIndex(new CodeIndex(i + 1, -1));
                continue;
            }
            newCodeLine.add(code);
        }
        return String.join((CharSequence)"", newCodeLine);
    }

    private void reviseIndex(List<MergeDetail> mergeDetailList, CodeIndexLink codeIndexList, CodeIndexLink targetCodeIndexList) {
        for (MergeDetail mergeDetail : mergeDetailList) {
            int start = mergeDetail.getRevise().getStart();
            mergeDetail.getRevise().setStart(this.handleData(start, codeIndexList));
            int end = mergeDetail.getRevise().getEnd();
            mergeDetail.getRevise().setEnd(this.handleData(end, codeIndexList));
            if (!HussarUtils.isNotEmpty((Object)mergeDetail.getTarget())) continue;
            int targetStart = mergeDetail.getTarget().getStart();
            mergeDetail.getTarget().setStart(this.handleData(targetStart, targetCodeIndexList));
            int targetEnd = mergeDetail.getTarget().getEnd();
            mergeDetail.getTarget().setEnd(this.handleData(targetEnd, targetCodeIndexList));
        }
    }

    private int handleData(int num, CodeIndexLink codeIndexList) {
        CodeIndex codeIndex;
        int actualRow = 0;
        codeIndexList.init();
        int addRow = 0;
        while (codeIndexList.hasNext() && num >= (codeIndex = codeIndexList.next()).getIndex()) {
            addRow += codeIndex.getAddNumber();
        }
        actualRow = num + addRow;
        return actualRow;
    }

    private PlainMerger.Result mergeText(boolean mergeEnabled, String lastPublish, String currentFile, String currentPublish, String lastFile) {
        if (mergeEnabled) {
            lastPublish = StringUtils.defaultString((String)lastPublish);
            currentFile = StringUtils.defaultString((String)currentFile);
            currentPublish = StringUtils.defaultString((String)currentPublish);
            if (!(!StringUtils.isEmpty((CharSequence)lastPublish) || StringUtils.isNotEmpty((CharSequence)currentFile) && StringUtils.isNotEmpty((CharSequence)currentPublish))) {
                return StructuralMerger.adoptFirstNonEmpty(false, currentFile, currentPublish);
            }
            return PlainMerger.merge(lastPublish, currentFile, currentPublish, lastFile);
        }
        return StructuralMerger.adoptFirstNonEmpty(true, currentFile, currentPublish);
    }

    private static PlainMerger.Result adoptFirstNonEmpty(boolean onlyNull, String currentFile, String currentPublish) {
        Predicate<String> isEmpty;
        String adopt = "";
        Predicate<String> predicate = isEmpty = onlyNull ? Objects::isNull : StringUtils::isEmpty;
        if (!isEmpty.test(currentFile)) {
            adopt = currentFile;
        } else if (!isEmpty.test(currentPublish)) {
            adopt = currentPublish;
        }
        PlainMerger.Result result = new PlainMerger.Result();
        result.setConflicted(false);
        result.setMerged(adopt);
        result.setConflicts(adopt);
        return result;
    }

    private String fold(CodeSection section) {
        if (section == null) {
            return null;
        }
        if (section.isPlain()) {
            return section.getInnerCode();
        }
        List<CodeSection> children = section.getChildren();
        StringBuilder folded = new StringBuilder();
        for (CodeSection child : children) {
            if (child.isLeaf()) {
                child.appendOuterCode(folded);
                continue;
            }
            CommentDirective placeholder = new CommentDirective("placeholder");
            placeholder.putArgument(child.getId());
            Pair<String> foldedDelimiter = ExtractFileType.FOLDED.getCommentDelimiters().get(0);
            folded.append((String)foldedDelimiter.getLeft());
            folded.append(" ");
            folded.append(placeholder.represent());
            folded.append(" ");
            folded.append((String)foldedDelimiter.getRight());
            folded.append(System.lineSeparator());
        }
        return folded.toString();
    }

    private boolean unfold(StringBuilder unfolded, String id, boolean mergedSide, String body) throws StructuralMergeException {
        String virtualPath = this.path + "?type=folded&id=" + id + "&side=" + (mergedSide ? "merged" : "conflicts");
        ExtractResult extracted = SectionExtractor.extract(virtualPath, body, ExtractFileType.FOLDED.getCommentDelimiters());
        if (extracted.containsAnyFailure()) {
            throw new StructuralMergeException("\u5206\u6790\u5b9a\u754c\u7b26\u5931\u8d25\uff1a" + System.lineSeparator() + extracted.assembleAllFailures());
        }
        boolean conflicted = false;
        for (CodeSection child : extracted.getRoot().getChildren()) {
            String reference = child.getReference();
            if (reference == null) {
                child.appendOuterCode(unfolded);
                continue;
            }
            Result dependency = this.require(reference);
            conflicted |= dependency.isConflicted();
            if (mergedSide) {
                unfolded.append(dependency.getMerged());
                continue;
            }
            unfolded.append(dependency.getConflicts());
        }
        return conflicted;
    }

    private static boolean missNewline(CharSequence text) {
        return text.length() > 0 && !StringUtils.endsWith((CharSequence)text, (CharSequence)"\n") && !StringUtils.endsWith((CharSequence)text, (CharSequence)"\r");
    }

    private static String checkSectionExtract(String path, boolean mergedSide, ExtractFileType type, String source) {
        String virtualPath = path + "?type=post-check?side=" + (mergedSide ? "merged" : "conflicts");
        ExtractResult result = SectionExtractor.extract(virtualPath, source, type.getCommentDelimiters());
        return StringUtils.defaultString((String)result.assembleAllFailures());
    }

    private List<MergePlaceHolder> delimiterConflictAnalyse(PlainMerger.Result foldedResult, String currentPublishFolded, String id) {
        CodeIndexLink currentFileCodeIndices = this.currentFileEx.getCodeIndexMap().get(id);
        CodeIndexLink lastPublishCodeIndices = this.lastPublishEx.getCodeIndexMap().get(id);
        CodeIndexLink currentPublishCodeIndices = this.currentPublishEx.getCodeIndexMap().get(id);
        ArrayList<MergePlaceHolder> placeHolders = new ArrayList<MergePlaceHolder>();
        HashMap<Integer, Integer> currentPublishCodeIndiceMap = new HashMap<Integer, Integer>();
        currentPublishCodeIndices.init();
        while (currentPublishCodeIndices.hasNext()) {
            CodeIndex codeIndex = currentPublishCodeIndices.next();
            currentPublishCodeIndiceMap.put(codeIndex.getIndex(), codeIndex.getAddNumber());
        }
        List publish = foldedResult.getMergeInfo().getCurrentPublishDetail().stream().filter(a -> a.getConflict() && a.getType() == 1).collect(Collectors.toList());
        Map<Integer, MergeDetail> currentFileMap = foldedResult.getMergeInfo().getCurrentFileDetail().stream().filter(a -> a.getConflict() && a.getType() == 1).collect(Collectors.toMap(mergeDetail -> mergeDetail.getTarget().getStart(), mergeDetail -> mergeDetail));
        List currentPublishFoldList = CodeSplitUtil.linesOf((String)currentPublishFolded);
        Pattern pattern = Pattern.compile("<#< @placeholder (\\w+) >#>");
        for (MergeDetail mergeDetail2 : publish) {
            String placeHolderId;
            String s;
            Matcher matcher;
            int end;
            int start = mergeDetail2.getRevise().getStart();
            if (start != (end = mergeDetail2.getRevise().getEnd()) - 1 || !currentPublishCodeIndiceMap.containsKey(end) || !(matcher = pattern.matcher(s = (String)currentPublishFoldList.get(end - 1))).find() || this.lastPublishEx.getSection(placeHolderId = matcher.group(1)) != null || this.currentFileEx.getSection(placeHolderId) != null) continue;
            MergePlaceHolder mergePlaceHolder = new MergePlaceHolder();
            mergePlaceHolder.setCurrentPublishStart(this.handleData(start, currentPublishCodeIndices));
            mergePlaceHolder.setCurrentPublishEnd(this.handleData(end, currentPublishCodeIndices));
            int target = this.handleData(mergeDetail2.getTarget().getStart(), lastPublishCodeIndices);
            mergePlaceHolder.setLastPublishTarget(target);
            MergeDetail currentFileMergeDetail = currentFileMap.get(mergeDetail2.getTarget().getStart());
            mergePlaceHolder.setCurrentFileEnd(this.handleData(currentFileMergeDetail.getRevise().getEnd(), currentFileCodeIndices));
            placeHolders.add(mergePlaceHolder);
        }
        return placeHolders;
    }

    public static class Result {
        boolean conflicted;
        String merged;
        String conflicts;
        String currentFile;
        String baseCode;
        List<MergePlaceHolder> placeHolders;
        private MergeInfo mergeInfo;

        public List<MergePlaceHolder> getPlaceHolders() {
            return this.placeHolders;
        }

        public void setPlaceHolders(List<MergePlaceHolder> placeHolders) {
            this.placeHolders = placeHolders;
        }

        public MergeInfo getMergeInfo() {
            return this.mergeInfo;
        }

        public void setMergeInfo(MergeInfo mergeInfo) {
            this.mergeInfo = mergeInfo;
        }

        public boolean isConflicted() {
            return this.conflicted;
        }

        public void setConflicted(boolean conflicted) {
            this.conflicted = conflicted;
        }

        public String getBaseCode() {
            return this.baseCode;
        }

        public void setBaseCode(String baseCode) {
            this.baseCode = baseCode;
        }

        public String getMerged() {
            return this.merged;
        }

        public void setMerged(String merged) {
            this.merged = merged;
        }

        public String getConflicts() {
            return this.conflicts;
        }

        public void setConflicts(String conflicts) {
            this.conflicts = conflicts;
        }

        public String getCurrentFile() {
            return this.currentFile;
        }

        public void setCurrentFile(String currentFile) {
            this.currentFile = currentFile;
        }
    }
}

