/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.version.service.impl;

import com.jxdinfo.hussar.formdesign.common.config.condition.ConditionNotSharedStorage;
import com.jxdinfo.hussar.formdesign.common.file.FilePublishService;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.version.service.VersionManageService;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={ConditionNotSharedStorage.class})
public class VersionManageServiceImpl
implements VersionManageService {
    private static final String ANCESTOR_STORE_RELATIVE_PATH = "/publish/version/ancestor";
    private static String ANCESTOR_STORE_PATH;
    private static String PROJECT_PATH;
    private static String STORE_ROOT_PATH;

    @Autowired
    public VersionManageServiceImpl(FormDesignProperties formDesignProperties) {
        PROJECT_PATH = formDesignProperties.getProjectPath();
        STORE_ROOT_PATH = formDesignProperties.getProjectRootPath();
    }

    @Override
    public String getAncestorCodeById(String id) throws IOException {
        String filePath = this.getPublishVersionFilePathById(id);
        File toReadFile = new File(filePath);
        if (toReadFile.exists()) {
            return FileUtils.readFileToString((File)toReadFile, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public void saveLastPublishCode(String id, String code) throws IOException {
        String filePath = this.getPublishVersionFilePathById(id);
        File toSaveFile = new File(filePath);
        FileUtils.writeStringToFile((File)toSaveFile, (String)code, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public void saveCacheLastPublishCode(String id, String code, String pageId) {
        String filePath = this.getPublishVersionFilePathById(id);
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        filePublishService.writeStringToFile(code, filePath, pageId);
    }

    @Override
    public void saveCacheLastFileCode(String id, String code, String pageId) {
        String filePath = this.getLastFileVersionFilePathById(id);
        FilePublishService filePublishService = (FilePublishService)SpringContextUtil.getBean(FilePublishService.class);
        filePublishService.writeStringToFile(code, filePath, pageId);
    }

    @Override
    public void saveLastFileCode(String id, String code) throws IOException {
        String filePath = this.getLastFileVersionFilePathById(id);
        File toSaveFile = new File(filePath);
        FileUtils.writeStringToFile((File)toSaveFile, (String)code, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public String getLastFileCode(String id) throws IOException {
        String filePath = this.getLastFileVersionFilePathById(id);
        File toReadFile = new File(filePath);
        if (toReadFile.exists()) {
            return FileUtils.readFileToString((File)toReadFile, (Charset)StandardCharsets.UTF_8);
        }
        return null;
    }

    private String getPublishVersionFilePathById(String id) {
        ANCESTOR_STORE_PATH = FileUtil.posixPath((String[])new String[]{PROJECT_PATH, AppContextUtil.getServiceID(), STORE_ROOT_PATH, ANCESTOR_STORE_RELATIVE_PATH});
        String path = ANCESTOR_STORE_PATH + "/" + id.replace("_", "/");
        path = path + "/last_publish";
        return path + ".version";
    }

    private String getLastFileVersionFilePathById(String id) {
        ANCESTOR_STORE_PATH = FileUtil.posixPath((String[])new String[]{PROJECT_PATH, AppContextUtil.getServiceID(), STORE_ROOT_PATH, ANCESTOR_STORE_RELATIVE_PATH});
        String path = ANCESTOR_STORE_PATH + "/" + id.replace("_", "/");
        path = path + "/last_file";
        return path + ".version";
    }

    static {
        PROJECT_PATH = "";
        STORE_ROOT_PATH = "";
    }
}

