/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.structural.merge.util;

import com.jxdinfo.hussar.formdesign.structural.model.MergeCodeEdit;
import com.jxdinfo.hussar.formdesign.structural.model.MergeDetail;
import com.jxdinfo.hussar.formdesign.structural.model.MergeInfo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.merge.MergeAlgorithm;
import org.eclipse.jgit.merge.MergeChunk;
import org.eclipse.jgit.merge.MergeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainMerger {
    private static final Logger logger = LoggerFactory.getLogger(PlainMerger.class);
    private static final Pattern REGEXP_LINE_SEPARATOR = Pattern.compile("\\n|\\r\\n?", 8);
    private static final Pattern REGEXP_BLANK_LINES = Pattern.compile("(?<=[\\n\\r]|^)([ \\t\\v\\f]*([\\n\\r]+|$))+", 8);
    private final Options options;
    private final DiffAlgorithm diffAlgorithm;
    private final SequenceComparator<RawText> mergeComparator;
    private boolean missingNewlineAtEnd;

    private PlainMerger(Options options) {
        this.options = options != null ? options : Options.DEFAULT;
        this.diffAlgorithm = this.options.isUseMyers() ? MyersDiff.INSTANCE : new HistogramDiff();
        this.mergeComparator = this.options.isIgnoreWhitespaces() ? RawTextComparator.WS_IGNORE_LEADING : RawTextComparator.DEFAULT;
    }

    public static Result merge(String lastPublish, String currentFile, String currentPublish, String lastFile) {
        return PlainMerger.merge(lastPublish, currentFile, currentPublish, lastFile, Options.DEFAULT);
    }

    public MergeCodeEdit[] getEqualLines(RawText a, RawText b) {
        EditList edits = this.diffAlgorithm.diff(this.mergeComparator, (Sequence)a, (Sequence)b);
        MergeCodeEdit[] equalLines = new MergeCodeEdit[a.size() + 2];
        int i = 0;
        for (Edit edit : edits) {
            int end = edit.getBeginA();
            MergeCodeEdit equalLine = new MergeCodeEdit(i, end);
            for (int j = i + 1; j <= end; ++j) {
                equalLines[j] = equalLine;
            }
            i = edit.getEndA();
        }
        int end = a.size();
        MergeCodeEdit equalLine = new MergeCodeEdit(i, end);
        for (int j = i + 1; j <= end; ++j) {
            equalLines[j] = equalLine;
        }
        if (i != a.size()) {
            equalLines[a.size() + 1] = equalLine;
        }
        return equalLines;
    }

    public static Result merge(String lastPublish, String currentFile, String currentPublish, String lastFile, Options options) {
        PlainMerger merger = new PlainMerger(options);
        MergeCodeEdit[] equalLines = null;
        if (lastFile != null) {
            equalLines = merger.getEqualLines(merger.getRawText(currentFile), merger.getRawText(lastFile));
        }
        MergeResult<RawText> mergeResult = merger.executeMerge(merger.getRawText(lastPublish), merger.getRawText(currentFile), merger.getRawText(currentPublish));
        Result result = merger.convertResult(mergeResult);
        merger.setNoReviseDifference(result.getMergeInfo().getCurrentFileDetail(), equalLines);
        result.setBaseCode(lastPublish);
        return result;
    }

    public void setNoReviseDifference(List<MergeDetail> mergeDetails, MergeCodeEdit[] equalLines) {
        if (HussarUtils.isEmpty((Object[])equalLines)) {
            return;
        }
        for (MergeDetail mergeDetail : mergeDetails) {
            if (HussarUtils.equals((Object)mergeDetail.getType(), (Object)0)) continue;
            int start = mergeDetail.getRevise().getStart() + 1;
            int end = mergeDetail.getRevise().getEnd();
            if (equalLines[start] != null && equalLines[end] != null && equalLines[start] == equalLines[end]) {
                mergeDetail.setEdit(0);
                continue;
            }
            mergeDetail.setEdit(1);
        }
    }

    private MergeResult<RawText> executeMerge(RawText lastPublish, RawText currentFile, RawText currentPublish) {
        this.missingNewlineAtEnd = currentFile.isMissingNewlineAtEnd();
        return new MergeAlgorithm(this.diffAlgorithm).merge(this.mergeComparator, (Sequence)lastPublish, (Sequence)currentFile, (Sequence)currentPublish);
    }

    private RawText getRawText(String text) {
        text = REGEXP_LINE_SEPARATOR.matcher(text).replaceAll(Options.LineSeparator.UNIX_LF.getValue());
        if (this.options.isRemoveBlankLines()) {
            text = REGEXP_BLANK_LINES.matcher(text).replaceAll("");
        }
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        return new RawText(bytes);
    }

    private Result convertResult(MergeResult<RawText> mergeResult) {
        List sequences = mergeResult.getSequences();
        BytesBuffer mergedBuffer = new BytesBuffer(this.options.getLineSeparator().getValue());
        BytesBuffer conflictsBuffer = new BytesBuffer(this.options.getLineSeparator().getValue());
        BytesBuffer baseCodeBuffer = new BytesBuffer(this.options.getLineSeparator().getValue());
        int state = 0;
        String merged = "";
        BytesBuffer chunkBuffer = new BytesBuffer(this.options.lineSeparator.getValue());
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        MergeInfo mergeInfo = new MergeInfo();
        RawText file0 = (RawText)sequences.get(0);
        RawText file1 = (RawText)sequences.get(1);
        RawText file2 = (RawText)sequences.get(2);
        for (MergeChunk mergeChunk : mergeResult) {
            boolean isEqual = true;
            boolean isConflict = false;
            if (mergeChunk.getSequenceIndex() == 1) {
                int length = mergeChunk.getEnd() - mergeChunk.getBegin();
                if (length <= 0) {
                    isEqual = false;
                }
                for (int i = 0; i < length; ++i) {
                    String code1 = file1.getString(mergeChunk.getBegin() + i);
                    if (file2.size() <= mergeInfo.getLastIndex2() + i) {
                        isEqual = false;
                    } else {
                        String code2 = file2.getString(mergeInfo.getLastIndex2() + i);
                        if (HussarUtils.equals((Object)code1, (Object)code2)) continue;
                        isEqual = false;
                    }
                    break;
                }
            } else {
                isEqual = false;
            }
            switch (mergeChunk.getConflictState()) {
                case NO_CONFLICT: {
                    switch (state) {
                        case 0: 
                        case 1: {
                            break;
                        }
                        case 3: {
                            merged = this.withLineSeparator(merged);
                            this.withLineSeparator(chunkBuffer);
                            String conflicts = chunkBuffer.takeString();
                            chunks.add(new Chunk(true, merged, conflicts));
                            break;
                        }
                        default: {
                            logger.error("corrupted merge result");
                            throw new IllegalArgumentException("corrupted merge result: unexpected no conflict chunk");
                        }
                    }
                    state = 1;
                    chunkBuffer.writeChunk(sequences, mergeChunk);
                    mergedBuffer.writeChunk(sequences, mergeChunk);
                    conflictsBuffer.writeChunk(sequences, mergeChunk);
                    break;
                }
                case FIRST_CONFLICTING_RANGE: {
                    switch (state) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.withLineSeparator(chunkBuffer);
                            String content = chunkBuffer.takeString();
                            chunks.add(new Chunk(false, content, content));
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            merged = this.withLineSeparator(merged);
                            this.withLineSeparator(chunkBuffer);
                            String conflicts = chunkBuffer.takeString();
                            chunks.add(new Chunk(true, merged, conflicts));
                            break;
                        }
                        default: {
                            logger.error("corrupted merge result");
                            throw new IllegalArgumentException("corrupted merge result: unexpected first conflicting chunk");
                        }
                    }
                    isConflict = true;
                    state = 2;
                    chunkBuffer.writeChunk(sequences, mergeChunk);
                    mergedBuffer.writeChunk(sequences, mergeChunk);
                    break;
                }
                case NEXT_CONFLICTING_RANGE: {
                    switch (state) {
                        case 2: {
                            merged = chunkBuffer.takeString();
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            logger.error("corrupted merge result");
                            throw new IllegalArgumentException("corrupted merge result: unexpected next conflicting chunk");
                        }
                    }
                    isConflict = true;
                    state = 3;
                    chunkBuffer.writeChunk(sequences, mergeChunk);
                    conflictsBuffer.writeChunk(sequences, mergeChunk);
                    break;
                }
                default: {
                    logger.error("unsupported conflict state: " + mergeChunk.getConflictState());
                    throw new IllegalStateException("unsupported conflict state: " + mergeChunk.getConflictState());
                }
            }
            switch (mergeChunk.getSequenceIndex()) {
                case 0: {
                    mergeInfo.addNoEdit(mergeChunk.getBegin(), mergeChunk.getEnd());
                    break;
                }
                case 1: 
                case 2: {
                    mergeInfo.addConflict(mergeChunk.getBegin(), mergeChunk.getEnd(), mergeChunk.getSequenceIndex(), isConflict, isEqual);
                }
            }
        }
        mergeInfo.setEndNoEdit(file0.size(), file1.size(), file2.size());
        switch (state) {
            case 0: {
                break;
            }
            case 1: {
                if (!this.missingNewlineAtEnd) {
                    this.withLineSeparator(chunkBuffer);
                }
                String content = chunkBuffer.takeString();
                chunks.add(new Chunk(false, content, content));
                break;
            }
            case 3: {
                if (!this.missingNewlineAtEnd) {
                    merged = this.withLineSeparator(merged);
                    this.withLineSeparator(chunkBuffer);
                }
                String conflicts = chunkBuffer.takeString();
                chunks.add(new Chunk(true, merged, conflicts));
                break;
            }
            default: {
                logger.error("corrupted merge result");
                throw new IllegalArgumentException("corrupted merge result: unexpected chunk list termination");
            }
        }
        if (!this.missingNewlineAtEnd) {
            mergedBuffer.writeLineSeparator();
            conflictsBuffer.writeLineSeparator();
        }
        return new Result(mergeResult.containsConflicts(), chunks, mergedBuffer.takeString(), conflictsBuffer.takeString(), mergeInfo);
    }

    private String withLineSeparator(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        return text + this.options.getLineSeparator().getValue();
    }

    private void withLineSeparator(BytesBuffer buffer) {
        if (buffer == null || buffer.size() == 0) {
            return;
        }
        buffer.writeLineSeparator();
    }

    private static class BytesBuffer
    extends ByteArrayOutputStream {
        private final byte[] separator;
        private boolean lineBegin = true;

        public BytesBuffer(String separator) {
            this.separator = separator.getBytes(StandardCharsets.UTF_8);
        }

        public void writeChunk(List<RawText> sequences, MergeChunk chunk) {
            try {
                RawText sequence = sequences.get(chunk.getSequenceIndex());
                for (int i = chunk.getBegin(); i < chunk.getEnd(); ++i) {
                    if (!this.lineBegin) {
                        this.write(this.separator);
                    }
                    sequence.writeLine((OutputStream)this, i);
                    if (!this.lineBegin) continue;
                    this.write(this.separator);
                }
            }
            catch (IOException e) {
                logger.error("unreachable", (Throwable)e);
                throw new IllegalStateException("unreachable", e);
            }
        }

        public void writeLineSeparator() {
            try {
                this.write(this.separator);
            }
            catch (IOException e) {
                logger.error("unreachable", (Throwable)e);
                throw new IllegalStateException("unreachable", e);
            }
        }

        public String takeString() {
            try {
                String text = this.toString(StandardCharsets.UTF_8.name());
                this.reset();
                this.lineBegin = true;
                return text;
            }
            catch (UnsupportedEncodingException e) {
                logger.error("unreachable", (Throwable)e);
                throw new IllegalStateException("unreachable", e);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            if (len == 0) {
                return;
            }
            this.lineBegin = b[off + (len - 1)] == 10 || b[off + (len - 1)] == 13;
            super.write(b, off, len);
        }

        @Override
        public void write(int b) {
            this.lineBegin = b == 10 || b == 13;
            super.write(b);
        }
    }

    public static class Chunk {
        private boolean conflicted;
        private String merged;
        private String conflicts;

        public Chunk() {
        }

        public Chunk(boolean conflicted, String merged, String conflicts) {
            this.conflicted = conflicted;
            this.merged = merged;
            this.conflicts = conflicts;
        }

        public boolean isConflicted() {
            return this.conflicted;
        }

        public void setConflicted(boolean conflicted) {
            this.conflicted = conflicted;
        }

        public String getMerged() {
            return this.merged;
        }

        public void setMerged(String merged) {
            this.merged = merged;
        }

        public String getConflicts() {
            return this.conflicts;
        }

        public void setConflicts(String conflicts) {
            this.conflicts = conflicts;
        }
    }

    public static class Result {
        private boolean conflicted;
        private List<Chunk> chunks;
        private String merged;
        private String conflicts;
        private String baseCode;
        private MergeInfo mergeInfo;

        public Result() {
        }

        public Result(boolean conflicted, List<Chunk> chunks, String merged, String conflicts, MergeInfo mergeInfo) {
            this.conflicted = conflicted;
            this.chunks = chunks;
            this.merged = merged;
            this.conflicts = conflicts;
            this.mergeInfo = mergeInfo;
        }

        public String getBaseCode() {
            return this.baseCode;
        }

        public void setBaseCode(String baseCode) {
            this.baseCode = baseCode;
        }

        public MergeInfo getMergeInfo() {
            return this.mergeInfo;
        }

        public void setMergeInfo(MergeInfo mergeInfo) {
            this.mergeInfo = mergeInfo;
        }

        public boolean isConflicted() {
            return this.conflicted;
        }

        public void setConflicted(boolean conflicted) {
            this.conflicted = conflicted;
        }

        public List<Chunk> getChunks() {
            return this.chunks;
        }

        public void setChunks(List<Chunk> chunks) {
            this.chunks = chunks;
        }

        public String getMerged() {
            return this.merged;
        }

        public void setMerged(String merged) {
            this.merged = merged;
        }

        public String getConflicts() {
            return this.conflicts;
        }

        public void setConflicts(String conflicts) {
            this.conflicts = conflicts;
        }
    }

    public static class Options {
        public static final Options DEFAULT = Options.builder().build();
        private final boolean useMyers;
        private final boolean ignoreWhitespaces;
        private final boolean removeBlankLines;
        private final LineSeparator lineSeparator;

        private Options(boolean useMyers, boolean ignoreWhitespaces, boolean removeBlankLines, LineSeparator lineSeparator) {
            this.useMyers = useMyers;
            this.ignoreWhitespaces = ignoreWhitespaces;
            this.removeBlankLines = removeBlankLines;
            this.lineSeparator = lineSeparator;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean isUseMyers() {
            return this.useMyers;
        }

        public boolean isIgnoreWhitespaces() {
            return this.ignoreWhitespaces;
        }

        public boolean isRemoveBlankLines() {
            return this.removeBlankLines;
        }

        public LineSeparator getLineSeparator() {
            return this.lineSeparator;
        }

        public static enum LineSeparator {
            WINDOWS_CRLF("\r\n"),
            UNIX_LF("\n"),
            MAC_CR("\r");

            public static final LineSeparator DEFAULT;
            private final String value;

            private LineSeparator(String value) {
                this.value = value;
            }

            private static LineSeparator getDefault() {
                return LineSeparator.from(System.lineSeparator());
            }

            public static LineSeparator from(String value) {
                for (LineSeparator sep : LineSeparator.values()) {
                    if (!value.equals(sep.getValue())) continue;
                    return sep;
                }
                logger.warn("unsupported line separator, use unix lf instead");
                return UNIX_LF;
            }

            public String getValue() {
                return this.value;
            }

            static {
                DEFAULT = LineSeparator.getDefault();
            }
        }

        public static class Builder {
            private boolean flagUseMyers = false;
            private boolean flagIgnoreWhitespaces = true;
            private boolean flagRemoveBlankLines = false;
            private LineSeparator paramLineSeparator = LineSeparator.DEFAULT;

            public Builder useMyers(boolean useMyers) {
                this.flagUseMyers = useMyers;
                return this;
            }

            public Builder ignoreWhitespaces(boolean ignoreWhitespaces) {
                this.flagIgnoreWhitespaces = ignoreWhitespaces;
                return this;
            }

            public Builder removeBlankLines(boolean removeBlankLines) {
                this.flagRemoveBlankLines = removeBlankLines;
                return this;
            }

            public Builder lineSeparator(LineSeparator lineSeparator) {
                this.paramLineSeparator = lineSeparator != null ? lineSeparator : LineSeparator.DEFAULT;
                return this;
            }

            public Builder lineSeparator(String lineSeparator) {
                this.paramLineSeparator = LineSeparator.from(lineSeparator);
                return this;
            }

            public Options build() {
                return new Options(this.flagUseMyers, this.flagIgnoreWhitespaces, this.flagRemoveBlankLines, this.paramLineSeparator);
            }
        }
    }
}

