/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.structural.merge.service.impl;

import com.jxdinfo.hussar.formdesign.common.util.CodeSplitUtil;
import com.jxdinfo.hussar.formdesign.structural.merge.service.CodeMergeService;
import com.jxdinfo.hussar.formdesign.structural.merge.util.PlainMerger;
import com.jxdinfo.hussar.formdesign.structural.merge.util.StructuralMerger;
import com.jxdinfo.hussar.formdesign.structural.model.MergeResult;
import com.jxdinfo.hussar.formdesign.structural.section.util.ExtractFileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CodeMergeServiceImpl
implements CodeMergeService {
    private static final Logger logger = LoggerFactory.getLogger(CodeMergeServiceImpl.class);

    @Override
    public MergeResult textMerge(String lastPublish, String currentFile, String currentPublish, String lastFile, boolean removeEmptyLines) {
        if (logger.isDebugEnabled()) {
            logger.debug(CodeMergeServiceImpl.entitle("CodeMergeService.textMerge: removeEmptyLines=" + removeEmptyLines, '='));
            logger.debug(CodeMergeServiceImpl.entitle("lastPublish (textMerge)", '-') + System.lineSeparator() + lastPublish);
            logger.debug(CodeMergeServiceImpl.entitle("currentFile (textMerge)", '-') + System.lineSeparator() + currentFile);
            logger.debug(CodeMergeServiceImpl.entitle("currentPublish (textMerge)", '-') + System.lineSeparator() + currentPublish);
        }
        if (removeEmptyLines) {
            lastPublish = CodeSplitUtil.removeEmptyLines((String)lastPublish);
            currentFile = CodeSplitUtil.removeEmptyLines((String)currentFile);
            currentPublish = CodeSplitUtil.removeEmptyLines((String)currentPublish);
            lastFile = CodeSplitUtil.removeEmptyLines((String)lastFile);
        }
        PlainMerger.Result result = PlainMerger.merge(lastPublish, currentFile, currentPublish, lastFile);
        MergeResult mergeResult = new MergeResult();
        mergeResult.setConflict(result.isConflicted());
        mergeResult.setMergedCode(result.getMerged());
        mergeResult.setConflictsCode(result.getConflicts());
        mergeResult.setMergeInfo(result.getMergeInfo());
        mergeResult.setLastPublish(lastPublish);
        mergeResult.setCurrentFile(currentFile);
        mergeResult.setCurrentPublish(currentPublish);
        if (logger.isDebugEnabled()) {
            logger.debug(CodeMergeServiceImpl.entitle("conflicted=" + result.isConflicted() + " (textMerge)", '-'));
            logger.debug(CodeMergeServiceImpl.entitle("merged (textMerge)", '-') + System.lineSeparator() + result.getMerged());
            logger.debug(CodeMergeServiceImpl.entitle("conflicts (textMerge)", '-') + System.lineSeparator() + result.getConflicts());
        }
        return mergeResult;
    }

    @Override
    public MergeResult structuralMerge(String path, ExtractFileType type, String lastPublish, String currentFile, String currentPublish, String lastFile, boolean removeEmptyLines) {
        String string = lastFile = lastFile == null ? "" : lastFile;
        if (logger.isDebugEnabled()) {
            logger.debug(CodeMergeServiceImpl.entitle("CodeMergeService.structuralMerge: path=" + path + ", type=" + (Object)((Object)type) + ", removeEmptyLines=" + removeEmptyLines, '='));
            logger.debug(CodeMergeServiceImpl.entitle("lastPublish (structuralMerge)", '-') + System.lineSeparator() + lastPublish);
            logger.debug(CodeMergeServiceImpl.entitle("currentFile (structuralMerge)", '-') + System.lineSeparator() + currentFile);
            logger.debug(CodeMergeServiceImpl.entitle("currentPublish (structuralMerge)", '-') + System.lineSeparator() + currentPublish);
        }
        if (removeEmptyLines) {
            lastPublish = CodeSplitUtil.removeEmptyLines((String)lastPublish);
            currentFile = CodeSplitUtil.removeEmptyLines((String)currentFile);
            currentPublish = CodeSplitUtil.removeEmptyLines((String)currentPublish);
            lastFile = CodeSplitUtil.removeEmptyLines((String)lastFile);
        }
        StructuralMerger.Result result = StructuralMerger.hybridMerge(path, type, lastPublish, currentFile, currentPublish, lastFile);
        MergeResult mergeResult = new MergeResult();
        mergeResult.setConflict(result.isConflicted());
        mergeResult.setMergedCode(result.getMerged());
        mergeResult.setConflictsCode(result.getConflicts());
        mergeResult.setLastPublish(result.getBaseCode());
        mergeResult.setCurrentFile(result.getCurrentFile());
        mergeResult.setCurrentPublish(currentPublish);
        mergeResult.setMergeInfo(result.getMergeInfo());
        if (logger.isDebugEnabled()) {
            logger.debug(CodeMergeServiceImpl.entitle("conflicted=" + result.isConflicted() + " (structuralMerge)", '-'));
            logger.debug(CodeMergeServiceImpl.entitle("merged (structuralMerge)", '-') + System.lineSeparator() + result.getMerged());
            logger.debug(CodeMergeServiceImpl.entitle("conflicts (structuralMerge)", '-') + System.lineSeparator() + result.getConflicts());
        }
        return mergeResult;
    }

    private static String entitle(String title, char pad) {
        int i;
        int n = title.length() > 80 ? 10 : (100 - title.length()) / 2;
        int m = title.length() > 80 ? 10 : 100 - title.length() - n;
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < n; ++i) {
            builder.append(pad);
        }
        builder.append(title);
        for (i = 0; i < m; ++i) {
            builder.append(pad);
        }
        return builder.toString();
    }
}

