/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.speedcode.structural.section.model.section;

import com.jxdinfo.hussar.speedcode.structural.section.model.result.ExtractResult;
import com.jxdinfo.hussar.speedcode.structural.section.model.section.SectionType;
import com.jxdinfo.hussar.speedcode.structural.section.model.section.SectionVisitor;
import java.util.List;
import java.util.function.Predicate;

public abstract class CodeSection {
    private int start;
    private int end;

    public boolean traverse(SectionVisitor a) {
        CodeSection a2;
        if (a2.isLeaf()) {
            return a.visit(a2);
        }
        if (!a.enter(a2)) {
            return false;
        }
        List<CodeSection> list = a2.getChildren();
        if (list != null) {
            list = list.iterator();
            while (list.hasNext()) {
                if (((CodeSection)list.next()).traverse(a)) continue;
                return false;
            }
        }
        return a.leave(a2);
    }

    public boolean isPlain() {
        CodeSection a;
        if (a.isLeaf()) {
            return true;
        }
        List<CodeSection> list = a.getChildren();
        if (list == null || list.size() == 0) {
            return true;
        }
        list = list.iterator();
        while (list.hasNext()) {
            if (((CodeSection)list.next()).isLeaf()) continue;
            return false;
        }
        return true;
    }

    public abstract List<CodeSection> getChildren();

    public void setStart(int a) {
        a.start = a;
    }

    public void setEnd(int a) {
        a.end = a;
    }

    public String getOuterCode() {
        CodeSection a;
        return a.getInnerCode();
    }

    public CodeSection(int a, int a2) {
        CodeSection a3;
        CodeSection codeSection = a3;
        codeSection.start = a;
        codeSection.end = a2;
    }

    public String getPosition() {
        CodeSection a;
        return a.start + ExtractResult.const("\u000b") + a.end;
    }

    public void appendInnerCode(StringBuilder a) {
        CodeSection a2;
        List<CodeSection> list = a2.getChildren();
        if (list == null || list.size() == 0) {
            return;
        }
        Object object = list = list.iterator();
        while (object.hasNext()) {
            CodeSection codeSection = (CodeSection)list.next();
            object = list;
            a.append(codeSection.getOuterCode());
        }
    }

    public boolean traverse(Predicate<CodeSection> a) {
        CodeSection a2;
        if (!a.test(a2)) {
            return false;
        }
        List<CodeSection> list = a2.getChildren();
        if (list == null) {
            return true;
        }
        list = list.iterator();
        while (list.hasNext()) {
            if (((CodeSection)list.next()).traverse(a)) continue;
            return false;
        }
        return true;
    }

    public String getReference() {
        return null;
    }

    public abstract SectionType getType();

    public void appendOuterCode(StringBuilder a) {
        CodeSection a2;
        a2.appendInnerCode(a);
    }

    public CodeSection() {
        CodeSection a;
    }

    public String getInnerCode() {
        CodeSection a;
        List<CodeSection> list = a.getChildren();
        if (list == null || list.size() == 0) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0).getOuterCode();
        }
        StringBuilder stringBuilder = new StringBuilder();
        Object object = list = list.iterator();
        while (object.hasNext()) {
            CodeSection codeSection = (CodeSection)list.next();
            object = list;
            stringBuilder.append(codeSection.getOuterCode());
        }
        return stringBuilder.toString();
    }

    public abstract boolean isLeaf();

    public String getId() {
        return null;
    }

    public int getStart() {
        CodeSection a;
        return a.start;
    }

    public int getEnd() {
        CodeSection a;
        return a.end;
    }
}

