/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.AsyncActionUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.EventUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Base.DataImportAction")
public class DataImport
implements ActionVisitor {
    private FileMappingService fileMappingService;

    @Autowired
    public DataImport(FileMappingService fileMappingService) {
        this.fileMappingService = fileMappingService;
    }

    public void visitor(Action action, Ctx ctx) throws Exception {
        String modelId;
        HashMap<String, Object> templateMap = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath("/template/common/event/DataImport.ftl");
        LcdpComponent myLcdpComponent = action.getCurrentLcdpComponent();
        String trigger = action.getTrigger();
        String triggerName = myLcdpComponent.getInstanceKey() + trigger.substring(0, 1).toUpperCase() + trigger.substring(1);
        templateMap.put("trigger", triggerName);
        Map paramValues = action.getParamValues();
        Map actionParams = paramValues != null ? (Map)paramValues.get("dataImport") : null;
        String apiFileName = "";
        String apiFilePath = "";
        String operationName = "dataImport";
        String string = modelId = actionParams != null ? (String)actionParams.get("id") : null;
        if (ToolUtil.isNotEmpty((Object)modelId)) {
            templateMap.put("modelId", modelId);
            apiFileName = this.fileMappingService.getFileName(modelId);
            apiFilePath = this.fileMappingService.getImportPath(modelId);
        }
        if (ToolUtil.isNotEmpty((Object)apiFilePath)) {
            EventUtil.addCtxImport(ctx, apiFileName, apiFilePath);
            templateMap.put("apiFileName", apiFileName);
        }
        templateMap.put("operationName", operationName);
        List bodies = action.getBodies();
        templateMap.put("bodies", bodies);
        templateMap.put("asyncBodyCode", AsyncActionUtil.getAsyncBodyCode(bodies));
        templateMap.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        ctx.addImports("DataImportDialog", "hussar-static-code-pc/src/components/DataImport/index");
        renderCore.registerParam(templateMap);
        RenderResult renderResult = renderCore.render();
        if (renderResult.isStatus()) {
            ctx.addMethod(triggerName, renderResult.getRenderString(), false);
        }
    }
}

