/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.formdesign.back.adapter.ModelProvideAdapter;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.DataModelBase;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSConditionListAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSParamConfigs;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.utils.AsyncActionUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.QueryAttrUtil;
import com.jxdinfo.hussar.formdesign.common.constant.ClientKindEnum;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.LcdpComponent;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.FrontClientConverter;
import com.jxdinfo.hussar.formdesign.common.util.RenderUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Base.SqlCustomizeAction")
public class SqlCustomizeService
implements ActionVisitor<Ctx> {
    private static final String API_INVOKE_TFL_PATH = "template/common/event/sqlCustomize.ftl";
    @Autowired
    private FileMappingService fileMappingService;

    public void visitor(Action action, Ctx ctx) throws Exception {
        DataModelBase dataModelBase = this.getDataModel(action);
        if (HussarUtils.isEmpty((Object)dataModelBase)) {
            return;
        }
        String name = dataModelBase.getName();
        String trigger = action.getTrigger();
        String triggerName = action.getCurrentLcdpComponent().getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
        List bodies = action.getBodies();
        RenderResult renderResult = this.render(action, AsyncActionUtil.getAsyncBodyCode(bodies), ctx);
        if (renderResult.isStatus()) {
            ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
        }
        ctx.addImports("*", name, this.fileMappingService.getImportPath(dataModelBase.getId()));
    }

    private DataModelBase getDataModel(Action action) throws LcdpException {
        if (HussarUtils.isEmpty((Object)action.getParamValues()) || HussarUtils.isEmpty(action.getParamValues().get("sqlDataModel")) || HussarUtils.isEmpty((Object)JSON.parseObject((String)action.getParamValues().get("sqlDataModel").toString()).get((Object)"dataModelId").toString())) {
            return null;
        }
        return DataModelUtil.getDataModelBase((String)JSON.parseObject((String)action.getParamValues().get("sqlDataModel").toString()).get((Object)"dataModelId").toString());
    }

    private RenderResult render(Action action, String bodies, Ctx ctx) throws LcdpException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(API_INVOKE_TFL_PATH);
        map.put("asyncBodyCode", bodies);
        map.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        map.put("actionName", action.getLabel());
        map.put("instanceKey", action.getCurrentLcdpComponent().getInstanceKey());
        this.sortAndOrder(action, map, ctx);
        renderCore.registerParam(map);
        return renderCore.render();
    }

    private void sortAndOrder(Action action, Map<String, Object> map, Ctx ctx) throws LcdpException {
        String sortConditionName;
        DataSortConditionAnalysis dataSortConditionAnalysis;
        DataModelBase dataModel = this.getDataModel(action);
        if (HussarUtils.isEmpty((Object)dataModel)) {
            return;
        }
        JSONObject sqlDataModel = JSON.parseObject((String)action.getParamValues().get("sqlDataModel").toString());
        JSONObject condition = JSON.parseObject((String)sqlDataModel.getString("condition"));
        String dataModelId = dataModel.getId();
        String dataModelName = dataModel.getName();
        if (HussarUtils.isNotEmpty((Object)condition)) {
            String querySelectionName = condition.getString("selectCondition");
            LcdpComponent lcdpComponent = action.getCurrentLcdpComponent();
            List conditionList = (List)JSON.parseObject((String)condition.getString("queryConditionModelList"), (TypeReference)new TypeReference<List<DataSConditionListAnalysis>>(){}, (Feature[])new Feature[0]);
            List<DataSParamConfigs> paramValue = new ArrayList<DataSParamConfigs>();
            if (HussarUtils.isNotEmpty((Object)sqlDataModel.get((Object)"paramValue"))) {
                paramValue = (List)JSON.parseObject((String)sqlDataModel.getString("paramValue"), (TypeReference)new TypeReference<List<DataSParamConfigs>>(){}, (Feature[])new Feature[0]);
            }
            map.put("queryAttr", QueryAttrUtil.getDataSetQueryAttr(conditionList, paramValue, ctx, dataModelId));
            map.put("isDataSetSearch", false);
            List dataItemPath = ModelProvideAdapter.adaptor((String)dataModelId).getFields(dataModelId);
            map.put("allFields", dataItemPath);
            if (ToolUtil.isNotEmpty((Object)querySelectionName)) {
                map.put("isDataSetSearch", true);
                Map queryConditions = DataModelUtil.getQueryConditionByModelIDAndName((String)dataModelId, (String)querySelectionName);
                map.put("queryConditions", queryConditions);
                ctx.addImports("getQueryConditionsResult", (String)FrontClientConverter.getPathResolver((String)ClientKindEnum.CLIENT_PATH.kind(ctx.getPageInfo().getType())).imports().get("getQueryConditionsResult"));
                ArrayList<String> queryConditionParams = new ArrayList<String>();
                queryConditionParams.add("params");
                ctx.addMethod(lcdpComponent.getInstanceKey() + "SqlCustomizeGetQueryConditions", queryConditionParams, RenderUtil.renderTemplate((String)"template/echartsui/event/echarts_getQueryConditionsMethod.ftl", map), false, MultilineExegesisUtil.dealMethodExegesis(lcdpComponent, "\u83b7\u53d6\u7b5b\u9009\u53c2\u6570\u65b9\u6cd5"));
            }
        }
        if (ToolUtil.isNotEmpty((Object)(dataSortConditionAnalysis = (DataSortConditionAnalysis)JSON.parseObject((String)sqlDataModel.getString("sortCondition"), DataSortConditionAnalysis.class))) && ToolUtil.isNotEmpty((Object)(sortConditionName = dataSortConditionAnalysis.getSortCondition()))) {
            Map sortConditions = DataModelUtil.getSortConditionByModelIDAndName((String)dataModelId, (String)sortConditionName);
            map.put("sortConditions", sortConditions);
            map.put("orders", RenderUtil.renderTemplate((String)"template/common/event/SqlCustomizeSortCondition", map));
        }
        map.put("importMethod", "conditionTableQuery");
        map.put("importName", dataModelName);
    }
}

