/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.back.model.apiModel.ApiDataModel;
import com.jxdinfo.hussar.formdesign.base.common.analysismodel.datas.DataSortConditionListAnalysis;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.ApiInvoke;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.ApiInvokeFactory;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.model.ApiActionModel;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.ApiBodyTypeParam;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.ApiOrderParam;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.ApiRequestParam;
import com.jxdinfo.hussar.formdesign.base.common.event.apiInvoke.templateParam.WebTemplateParam;
import com.jxdinfo.hussar.formdesign.base.common.utils.AsyncActionUtil;
import com.jxdinfo.hussar.formdesign.base.common.utils.MultilineExegesisUtil;
import com.jxdinfo.hussar.formdesign.common.ctx.Ctx;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpException;
import com.jxdinfo.hussar.formdesign.common.file.FileMappingService;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.Action;
import com.jxdinfo.hussar.formdesign.common.model.vuecode.ComponentData;
import com.jxdinfo.hussar.formdesign.common.render.RenderCore;
import com.jxdinfo.hussar.formdesign.common.render.RenderResult;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.visitor.ActionVisitor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="Base.ApiInvokeAction")
public class ApiInvokeService
implements ActionVisitor {
    private static final String API_INVOKE_TFL_PATH = "/template/common/event/ApiInvoke.ftl";
    private static final String API_INPUT_PARAM_PATH = "template/common/dataitem/ApiInputParam.ftl";
    @Autowired
    private FileMappingService fileMappingService;

    public void visitor(Action action, Ctx ctx) throws Exception {
        List<ApiActionModel> apiActionModels = ApiInvokeFactory.getApiAction(action);
        for (ApiActionModel apiActionModel : apiActionModels) {
            JSONObject object = DataModelUtil.getDataModelJson((String)apiActionModel.getModelId());
            String dataSourceName = (String)object.get((Object)"dataSourceName");
            WebTemplateParam webTemplateParam = null;
            String name = "";
            if (HussarUtils.equals((Object)dataSourceName, (Object)"APP")) {
                webTemplateParam = this.buildAppTemplateParam(ctx, apiActionModel, object);
                name = (String)object.get((Object)"name");
            } else {
                ApiDataModel apiDataModel = (ApiDataModel)DataModelUtil.getDataModelObject((String)apiActionModel.getModelId(), ApiDataModel.class);
                webTemplateParam = this.buildWebTemplateParam(ctx, apiActionModel, apiDataModel);
                name = apiDataModel.getName();
            }
            String trigger = action.getTrigger();
            String triggerName = action.getCurrentLcdpComponent().getInstanceKey() + ToolUtil.firstLetterToUpper((String)trigger);
            List bodies = action.getBodies();
            RenderResult renderResult = this.render(action, webTemplateParam, AsyncActionUtil.getAsyncBodyCode(bodies));
            if (renderResult.isStatus()) {
                ctx.addMethod(trigger, triggerName, renderResult.getRenderString());
            }
            ctx.addImports("*", name, this.fileMappingService.getImportPath((String)object.get((Object)"id")));
        }
    }

    public String visitorInputParam(ApiActionModel apiActionModel, Ctx ctx, List<DataSortConditionListAnalysis> dataSortConditionListAnalyses) throws LcdpException {
        JSONObject object = DataModelUtil.getDataModelJson((String)apiActionModel.getModelId());
        String dataSourceName = (String)object.get((Object)"dataSourceName");
        WebTemplateParam webTemplateParam = null;
        if (HussarUtils.equals((Object)dataSourceName, (Object)"APP")) {
            webTemplateParam = this.buildAppTemplateParam(ctx, apiActionModel, object);
        } else {
            ApiDataModel apiDataModel = (ApiDataModel)DataModelUtil.getDataModelObject((String)apiActionModel.getModelId(), ApiDataModel.class);
            webTemplateParam = this.buildWebTemplateParam(ctx, apiActionModel, apiDataModel);
        }
        if (HussarUtils.isNotEmpty(dataSortConditionListAnalyses)) {
            this.renderOrder(dataSortConditionListAnalyses, apiActionModel, webTemplateParam);
        }
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(API_INPUT_PARAM_PATH);
        HashMap<String, Object> map = new HashMap<String, Object>(webTemplateParam.toMap());
        renderCore.registerParam(map);
        return renderCore.render().getRenderString();
    }

    private void renderOrder(List<DataSortConditionListAnalysis> dataSortConditionListAnalyses, ApiActionModel apiActionModel, WebTemplateParam webTemplateParam) throws LcdpException {
        String bodyName = this.getAppBodyName(apiActionModel.getModelId(), apiActionModel.getOperationId());
        if (HussarUtils.isBlank((CharSequence)bodyName)) {
            return;
        }
        ApiRequestParam apiRequestParam = new ApiRequestParam(apiActionModel.getName());
        if (HussarUtils.isNotEmpty((Object)webTemplateParam.getApiRequestParam())) {
            apiRequestParam = webTemplateParam.getApiRequestParam();
        }
        webTemplateParam.setApiRequestParam(apiRequestParam);
        ApiBodyTypeParam bodyParam = new ApiBodyTypeParam();
        if (HussarUtils.isNotEmpty((Object)apiRequestParam.getBodyParam())) {
            bodyParam = apiRequestParam.getBodyParam();
        }
        apiRequestParam.setBodyParam(bodyParam);
        List<ApiBodyTypeParam> apiBodyTypeParams = new ArrayList<ApiBodyTypeParam>();
        if (HussarUtils.isNotEmpty(bodyParam.getApiBodyTypeParams())) {
            apiBodyTypeParams = bodyParam.getApiBodyTypeParams();
        }
        bodyParam.setApiBodyTypeParams(apiBodyTypeParams);
        ApiBodyTypeParam apiBodyTypeParam = null;
        for (ApiBodyTypeParam bodyTypeParam : apiBodyTypeParams) {
            if (!HussarUtils.equals((Object)bodyName, (Object)bodyTypeParam.getBodyName())) continue;
            apiBodyTypeParam = bodyTypeParam;
        }
        if (apiBodyTypeParam == null) {
            apiBodyTypeParam = new ApiBodyTypeParam();
            apiBodyTypeParam.setBodyName(bodyName);
            apiBodyTypeParam.setDatasetType(ComponentData.DataTypeEnum.OBJECT.getValue());
            apiBodyTypeParams.add(apiBodyTypeParam);
        }
        ApiBodyTypeParam orderTypeParam = new ApiBodyTypeParam();
        orderTypeParam.setBodyName("orders");
        orderTypeParam.setDatasetType("order");
        apiBodyTypeParam.addApiBodyTypeParams(orderTypeParam);
        for (DataSortConditionListAnalysis sortCondition : dataSortConditionListAnalyses) {
            ApiOrderParam apiOrderParam = new ApiOrderParam();
            apiOrderParam.setColumn(sortCondition.getSortAttrName());
            apiOrderParam.setAsc("asc".equals(sortCondition.getSortCondition()));
            orderTypeParam.addApiOrderParams(apiOrderParam);
        }
    }

    public String getAppBodyName(String modelId, String operationId) throws LcdpException {
        JSONObject model = DataModelUtil.getDataModelJson((String)modelId);
        if (HussarUtils.isEmpty((Object)model)) {
            return null;
        }
        List operations = (List)model.get((Object)"operations");
        if (HussarUtils.isEmpty((Object)operations)) {
            return null;
        }
        for (JSONObject operation : operations) {
            if (HussarUtils.isEmpty((Object)operation) || !HussarUtils.equals((Object)operationId, (Object)operation.get((Object)"id"))) continue;
            JSONObject inParams = (JSONObject)operation.get((Object)"inParams");
            if (HussarUtils.isEmpty((Object)inParams)) {
                return null;
            }
            List body = (List)inParams.get((Object)"body");
            if (HussarUtils.isEmpty((Object)body)) {
                return null;
            }
            for (JSONObject param : body) {
                Integer type = (Integer)param.get((Object)"type");
                if (type == null || type <= 5) continue;
                return (String)param.get((Object)"name");
            }
        }
        return null;
    }

    private RenderResult render(Action action, WebTemplateParam webTemplateParam, String bodies) throws LcdpException {
        RenderCore inputParamCore = new RenderCore();
        inputParamCore.registerTemplatePath(API_INPUT_PARAM_PATH);
        HashMap<String, Object> map = new HashMap<String, Object>(webTemplateParam.toMap());
        inputParamCore.registerParam(map);
        RenderCore renderCore = new RenderCore();
        renderCore.registerTemplatePath(API_INVOKE_TFL_PATH);
        map.put("inputParam", inputParamCore.render().getRenderString());
        map.put("asyncBodyCode", bodies);
        map.put("exegesisResult", MultilineExegesisUtil.handleActionExegesisText(action));
        map.put("actionName", action.getLabel());
        renderCore.registerParam(map);
        return renderCore.render();
    }

    private WebTemplateParam buildWebTemplateParam(Ctx ctx, ApiActionModel apiActionModel, ApiDataModel apiDataModel) throws LcdpException {
        ApiInvoke apiInvoke = new ApiInvoke(ctx, apiDataModel, apiActionModel);
        return apiInvoke.buildWebParam();
    }

    private WebTemplateParam buildAppTemplateParam(Ctx ctx, ApiActionModel apiActionModel, JSONObject object) throws LcdpException {
        ApiInvoke apiInvoke = new ApiInvoke(apiActionModel, ctx, object);
        return apiInvoke.buildAppParam();
    }
}

