/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.back.common.constant;

import com.jxdinfo.hussar.formdesign.back.common.constant.EngineColumnType;
import java.util.Optional;

public enum TypeLengthEnum {
    VARCHAR("mysql", "VARCHAR", 255, 16383),
    INT("mysql", "INTEGER", 10, 10),
    BIGINT("mysql", "BIGINT", 19, 19),
    DOUBLE("mysql", "DOUBLE", 10, 255),
    DATETIME("mysql", "TIMESTAMP", 0, 0),
    TINYINT("mysql", "TINYINT", 3, 3);

    private String database;
    private String type;
    private int defaultLength;
    private int maxLength;

    private TypeLengthEnum(String database, String type, int defaultLength, int maxLength) {
        this.database = database;
        this.type = type;
        this.defaultLength = defaultLength;
        this.maxLength = maxLength;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getType() {
        return this.type;
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public static int getDbTypeLength(Optional<EngineColumnType> engineColumnType) {
        if (engineColumnType.isPresent()) {
            for (TypeLengthEnum typeLengthEnum : TypeLengthEnum.values()) {
                if (!typeLengthEnum.getType().equals(engineColumnType.get().getJdbcType().getName())) continue;
                return typeLengthEnum.getDefaultLength();
            }
        }
        return 255;
    }

    static class DatabaseType {
        private static final String MYSQL = "mysql";

        private DatabaseType() {
        }
    }
}

