/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.model.GenerateField;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.properties.LowCodeArtificialIntelligenceProperties;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.lowcode.service.DataModelRecommendService;
import com.jxdinfo.hussar.formdesign.common.model.ResultCoreVO;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.RestTemplateHttpUtil;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;

@Service
public class DataModelRecommendServiceImpl
implements DataModelRecommendService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataModelRecommendServiceImpl.class);

    @Override
    public FormDesignResponse<List<GenerateField>> dataModel(String description, String dataModelType) {
        FormDesignResponse response = new FormDesignResponse();
        try {
            String address = ((LowCodeArtificialIntelligenceProperties)SpringUtil.getBean(LowCodeArtificialIntelligenceProperties.class)).getAiFormDesignServiceAddress() + "/predict";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("content", description);
            params.put("dataModelType", dataModelType);
            params.put("methodName", "lowCodeDataModel");
            ResultCoreVO resultCoreVO = RestTemplateHttpUtil.sendPostRequest((String)address, params);
            if (HussarUtils.isEmpty((Object)resultCoreVO)) {
                LOGGER.error("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u6307\u9488");
                response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
                response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u6307\u9488");
            } else if (HussarUtils.isEmpty((Object)resultCoreVO.getData()) && resultCoreVO.getCode() == 200) {
                LOGGER.error("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u5217\u8868");
                response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
                response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u5217\u8868");
            } else {
                Object data = resultCoreVO.getData();
                List fieldList = JSON.parseArray((String)JSON.toJSONString((Object)data), GenerateField.class);
                response.setData((Object)fieldList);
                response.setErrorCode(resultCoreVO.getCode().intValue());
                response.setErrorMsg(resultCoreVO.getMsg());
            }
        }
        catch (ResourceAccessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setErrorMsg("AI\u670d\u52a1\u5668\u672a\u8fde\u63a5\uff0c\u8bf7\u5148\u914d\u7f6eAI\u670d\u52a1\u5668\u5730\u5740\u3002");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
        return response;
    }
}

