/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.artificial.intelligence.nocode.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.nocode.properties.NoCodeArtificialIntelligenceProperties;
import com.jxdinfo.hussar.formdesign.artificial.intelligence.nocode.service.AudioToTextService;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AudioToTextServiceImpl
implements AudioToTextService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AudioToTextServiceImpl.class);
    private final RestTemplate restTemplate = new RestTemplate();

    @Override
    public FormDesignResponse<String> audioToText(MultipartFile file) {
        FormDesignResponse response = new FormDesignResponse();
        try {
            String address = ((NoCodeArtificialIntelligenceProperties)SpringUtil.getBean(NoCodeArtificialIntelligenceProperties.class)).getAudioToTextAddress() + "/api/asr/long";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            String fileName = file.getOriginalFilename();
            File fileTemp = File.createTempFile("temp", fileName.substring(fileName.lastIndexOf(46)));
            file.transferTo(fileTemp);
            FileSystemResource resource = new FileSystemResource(fileTemp);
            params.add((Object)"files", (Object)resource);
            HttpEntity requestEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
            ResponseEntity result = this.restTemplate.exchange(address, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            String responseData = (String)result.getBody();
            if (HussarUtils.isEmpty((Object)responseData)) {
                LOGGER.error("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u6307\u9488");
                response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
                response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u8fd4\u56de\u7a7a\u6307\u9488");
            } else {
                JSONArray jsonArray = JSON.parseArray((String)responseData);
                String cleanText = jsonArray.getJSONObject(0).get((Object)"clean_text").toString();
                response.setErrorCode(10000);
                response.setData((Object)cleanText);
                response.setErrorMsg("\u8f6c\u6362\u6210\u529f");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            response.setErrorCode(HttpStatus.INTERNAL_SERVER_ERROR.value());
            response.setErrorMsg("\u8c03\u7528Python\u670d\u52a1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a" + e.getMessage());
        }
        return response;
    }
}

