/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.util;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestTemplateHttpUtil {
    public static ApiResponse sendPostRequest(String url, Map<String, String> params) {
        RestTemplate client = new RestTemplate();
        client.setRequestFactory((ClientHttpRequestFactory)RestTemplateHttpUtil.getSimpleClientHttpRequestFactory());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity(params, (MultiValueMap)headers);
        ResponseEntity response = client.postForEntity(url, (Object)requestEntity, ApiResponse.class, new Object[0]);
        return (ApiResponse)response.getBody();
    }

    public static ApiResponse sendGetRequest(String url, Map<String, String> params) {
        RestTemplate client = new RestTemplate();
        client.setRequestFactory((ClientHttpRequestFactory)RestTemplateHttpUtil.getSimpleClientHttpRequestFactory());
        HttpHeaders headers = new HttpHeaders();
        ResponseEntity response = client.getForEntity(url, ApiResponse.class, params);
        return (ApiResponse)response.getBody();
    }

    public static InputStream downloadFile(String url, Map<String, String> params) throws IOException {
        RestTemplate client = new RestTemplate();
        client.setRequestFactory((ClientHttpRequestFactory)RestTemplateHttpUtil.getSimpleClientHttpRequestFactory());
        HttpHeaders headers = new HttpHeaders();
        ResponseEntity response = client.getForEntity(URI.create(url), Resource.class);
        InputStream inputStream = ((Resource)response.getBody()).getInputStream();
        return inputStream;
    }

    private static SimpleClientHttpRequestFactory getSimpleClientHttpRequestFactory() {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(600000);
        clientHttpRequestFactory.setReadTimeout(600000);
        return clientHttpRequestFactory;
    }
}

