/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.sync.union.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.service.ISysApplicationBoService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitFormAuthorizeRoles;
import com.jxdinfo.hussar.formdesign.application.authority.model.SysAppVisitRoleButton;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitFormAuthorizeRolesService;
import com.jxdinfo.hussar.formdesign.application.authority.service.ISysAppVisitRoleButtonService;
import com.jxdinfo.hussar.formdesign.application.form.enums.Button;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.model.SysFormGroup;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormGroupService;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class SyncUnionHelper {
    @Resource
    private ISysApplicationBoService sysApplicationBoService;
    @Resource
    private ISysFormGroupService formGroupService;
    @Resource
    private ISysFormService formService;
    @Resource
    private ISysAppVisitFormAuthorizeRolesService formAuthService;
    @Resource
    private ISysAppVisitRoleButtonService buttonAuthService;
    @Resource
    private ISysFunctionsBoService functionsBoService;
    @Resource
    private IHussarBaseResourceService hussarBaseResourceService;
    @Resource
    private ISysFunctionResourcesBoService functionResourcesBoService;
    @Resource
    private ISysRolesExternalService rolesExternalService;

    public List<SysFormGroup> getFormGroups(Long appId) {
        return this.formGroupService.list((Wrapper)new LambdaQueryWrapper().eq(SysFormGroup::getAppId, (Object)appId));
    }

    public List<Long> listFormGroupIds(Long appId) {
        return this.getFormGroups(appId).stream().map(SysFormGroup::getId).collect(Collectors.toList());
    }

    public List<SysForm> getAllForm(Long appId) {
        return this.formService.list((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
    }

    public List<Long> getAllFormId(Long appId) {
        return this.getAllForm(appId).stream().map(SysForm::getId).collect(Collectors.toList());
    }

    public List<SysAppVisitFormAuthorizeRoles> getAllFormAuth(Long appId) {
        return this.formAuthService.list((Wrapper)new LambdaQueryWrapper().eq(SysAppVisitFormAuthorizeRoles::getAppId, (Object)appId));
    }

    public List<SysAppVisitRoleButton> getAllButtonAuth(Long appId) {
        List formList = this.formService.list((Wrapper)new LambdaQueryWrapper().eq(SysForm::getAppId, (Object)appId));
        List ordinaryOrFlowFormIds = formList.stream().filter(form -> "0".equals(form.getFormType()) || "1".equals(form.getFormType())).map(SysForm::getId).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(ordinaryOrFlowFormIds)) {
            return this.buttonAuthService.list((Wrapper)new LambdaQueryWrapper().in(SysAppVisitRoleButton::getFormId, ordinaryOrFlowFormIds));
        }
        return null;
    }

    public Long getAppDevRoleId(Long appId) {
        return this.sysApplicationBoService.selectById(appId).getDevelopRoleId();
    }

    public void saveFunRes(Long funId, Long resId) {
        SysFunctionResources funRes = new SysFunctionResources();
        funRes.setFunctionId(funId);
        funRes.setResourceId(resId);
        this.functionResourcesBoService.saveOneFunRes(funRes);
    }

    public void saveRoleFun(Long roleId, Long funId) {
        SysRoleFunctions roleFun = new SysRoleFunctions();
        roleFun.setRoleId(roleId);
        roleFun.setFunctionId(funId);
        this.rolesExternalService.saveOneRoleFun(roleFun);
    }

    public void saveRoleRes(Long role, Long resId) {
        SysRoleResource roleRes = new SysRoleResource();
        roleRes.setRoleId(role);
        roleRes.setResourceId(resId);
        roleRes.setRelationSource("1");
        this.rolesExternalService.saveOneRoleRes(roleRes);
        HussarCacheUtil.evictKeysLike((String)"resource_info", (String)"hussar_resource:");
    }

    public Long getMenuFunId(Long formId) {
        String eleCode = "menu_" + formId;
        SysFunctions function = this.functionsBoService.getOneByCode(eleCode);
        return HussarUtils.isNotEmpty((Object)function) ? function.getId() : null;
    }

    public Map<Long, Long> getMenuFunIds(List<Long> formIds) {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        ArrayList<String> codes = new ArrayList<String>();
        for (Long formId : formIds) {
            String eleCode = "menu_" + formId;
            codes.add(eleCode);
        }
        List functions = this.functionsBoService.getFunctionListByFuncCode(codes);
        for (SysFunctions sysFunctions : functions) {
            String functionCode = sysFunctions.getFunctionCode();
            String formId = functionCode.replace("menu_", "");
            result.put(sysFunctions.getId(), Long.valueOf(formId));
        }
        return result;
    }

    public Map<Long, Long> listAllPageFunctionIdsForAppForms(Long appId) {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        List<Long> allFormId = this.getAllFormId(appId);
        if (HussarUtils.isNotEmpty(allFormId)) {
            for (Long formId : allFormId) {
                result.put(this.getMenuFunId(formId), formId);
            }
        }
        return result;
    }

    public Map<Long, Long> getFunctionIdsForAppForms(Long appId) {
        Map<Long, Long> result = new HashMap<Long, Long>();
        List<Long> allFormId = this.getAllFormId(appId);
        if (HussarUtils.isNotEmpty(allFormId)) {
            result = this.getMenuFunIds(allFormId);
        }
        return result;
    }

    public Long getMenuResId(Long formId) {
        String eleCode = "menu_" + formId;
        SysResources res = this.hussarBaseResourceService.getResourcesByCode(eleCode);
        return HussarUtils.isNotEmpty((Object)res) ? res.getId() : null;
    }

    public List<SysResources> getAllElementRes(Long formId) {
        String eleCode = "element_" + formId;
        return this.hussarBaseResourceService.getResListLikeCode(eleCode);
    }

    public List<SysResources> getAllDataRes(Long formId) {
        String dataCode = formId + "_" + "res_form_rights" + "_";
        return this.hussarBaseResourceService.getResListLikeCode(dataCode);
    }

    public List<Long> listDataResIdByForm(Long formId) {
        return this.getAllDataRes(formId).stream().map(SysResources::getId).collect(Collectors.toList());
    }

    public List<Long> listFunIdsByApp(Long appId) {
        ArrayList<Long> appFunIds = new ArrayList<Long>();
        List<Long> allFormId = this.getAllFormId(appId);
        if (HussarUtils.isNotEmpty(allFormId)) {
            for (Long formId : allFormId) {
                List<Long> formFunIds = this.listFunIdsByForm(formId);
                if (!HussarUtils.isNotEmpty(formFunIds)) continue;
                appFunIds.addAll(formFunIds);
            }
        }
        return appFunIds;
    }

    public List<Long> listFunIdsByForm(Long formId) {
        List funList = this.functionsBoService.listByModuleId(formId);
        return funList.stream().map(SysFunctions::getId).collect(Collectors.toList());
    }

    public List<Long> listResIdsByApp(Long appId) {
        ArrayList<Long> appResIds = new ArrayList<Long>();
        List<Long> allFormId = this.getAllFormId(appId);
        if (HussarUtils.isNotEmpty(allFormId)) {
            for (Long formId : allFormId) {
                List<Long> formResIds = this.listResIdsByForm(formId);
                if (!HussarUtils.isNotEmpty(formResIds)) continue;
                appResIds.addAll(formResIds);
            }
        }
        return appResIds;
    }

    public List<Long> listResIdsByForm(Long formId) {
        List resList = this.hussarBaseResourceService.getResourcesByModuleId(formId);
        return resList.stream().map(SysResources::getId).collect(Collectors.toList());
    }

    public List<Long> listMenuFunIdsByApp(Long appId) {
        ArrayList<Long> menuFunIdsByApp = new ArrayList<Long>();
        List<Long> allFormId = this.getAllFormId(appId);
        if (HussarUtils.isNotEmpty(allFormId)) {
            for (Long formId : allFormId) {
                Long menuFunId = this.getMenuFunId(formId);
                if (!HussarUtils.isNotEmpty((Object)menuFunId)) continue;
                menuFunIdsByApp.add(menuFunId);
            }
        }
        return menuFunIdsByApp;
    }

    public List<SysAppVisitRoleButton> listButtonAuthByFlowSystemButton(Long formId) {
        ArrayList<String> flowSystemButtonCodeList = new ArrayList<String>(2);
        flowSystemButtonCodeList.add(Button.SUBMIT_OPERATE.getButtonCode());
        flowSystemButtonCodeList.add(Button.REJECT_OPERATE.getButtonCode());
        return this.buttonAuthService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppVisitRoleButton::getFormId, (Object)formId)).in(SysAppVisitRoleButton::getButtonCode, flowSystemButtonCodeList));
    }

    public Long getElementFunctionIdByButtonCode(Long formId, String buttonCode) {
        String functionCode = "element_" + formId + "_" + buttonCode;
        SysFunctions function = this.functionsBoService.getOneByCode(functionCode);
        return HussarUtils.isNotEmpty((Object)function) ? function.getId() : null;
    }

    public Long getElementResourceIdByButtonCode(Long formId, String buttonCode) {
        String resourceCode = "element_" + formId + "_" + buttonCode;
        SysResources resource = this.hussarBaseResourceService.getResourcesByCode(resourceCode);
        return HussarUtils.isNotEmpty((Object)resource) ? resource.getId() : null;
    }
}

