/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.property.util;

import com.jxdinfo.hussar.formdesign.application.property.model.ScriptParam;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptBase;
import com.jxdinfo.hussar.formdesign.application.property.vo.ScriptMethodConstruct;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsScriptParser {
    private static final Pattern METHOD_NAME_PARAM_PATTERN = Pattern.compile("(export)(\\s*)((async)?)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))");
    private static final Pattern PARAM_NAME_PATTERN = Pattern.compile("(?<=\\()(.*?)(?=\\))");
    private static final Pattern NAME_NOTE_SPATTERN = Pattern.compile("(@name)(.*?)(export)(\\s*)((async)?)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))");
    private static final Pattern NAME_PATTERN = Pattern.compile("(@name)(.*?)((\\*\\s@)|(\\*\\/))");
    private static final Pattern CHINESE_NAME_PATTERN = Pattern.compile("(function)(.*?)(\\()");
    private static final Pattern DESCRIPTION_NOTE_SPATTERN = Pattern.compile("(@description)(.*?)(export)(\\s*)((async)?)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))");
    private static final Pattern PARAM_NOTE_SPATTERN = Pattern.compile("(\\@param)(.*?)(export)(\\s*)((async)?)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))");
    private static final Pattern PARAM_PATTERN = Pattern.compile("(@param)(.*?)(\\*\\/)");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("(@description)(.*?)((\\*\\s@)|(\\*\\/))");
    private static final Pattern RETURN_NOTE_SPATTERN = Pattern.compile("(@return(s)?)(.*?)(export)(\\s*)((async)?)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))");
    private static final Pattern RETURN_COUNT = Pattern.compile("(@return(s)?)(.*?)(export)(\\s*)((async)?)(\\s*)(function)(\\s*)(\\S+)(\\s*)(\\((.*?)\\))(\\s*)(\\{[^\\*](.*?)\\})");
    private static final Pattern RETURN_PATTERN = Pattern.compile("(@return(s)?)(.*?)(\\*)");

    public static ScriptBase parseScript(String editorNote) {
        ScriptBase scriptBase = new ScriptBase();
        ArrayList<ScriptMethodConstruct> methodList = new ArrayList<ScriptMethodConstruct>();
        String jsContent = editorNote;
        jsContent = jsContent.replaceAll("[\r\n]", "").replaceAll("\\u00A0", "");
        Matcher methodNameMatcher = METHOD_NAME_PARAM_PATTERN.matcher(jsContent);
        StringBuilder methodGroup = new StringBuilder();
        while (methodNameMatcher.find()) {
            methodGroup.append(methodNameMatcher.group());
        }
        if (HussarUtils.isEmpty((Object)methodGroup.toString())) {
            scriptBase.setMethods(methodList);
            return scriptBase;
        }
        String[] methodName = methodGroup.toString().replaceAll("(export\\s)", "").replaceAll("(async\\s)", "").replaceAll("(function\\s)", "").replaceAll("\\((.*?)\\)", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
        List<String> methodNameList = Arrays.asList(methodName);
        Matcher paramNameMatcher = PARAM_NAME_PATTERN.matcher(methodGroup.toString());
        ArrayList<String> paramNameList = new ArrayList<String>();
        while (paramNameMatcher.find()) {
            paramNameList.add(paramNameMatcher.group());
        }
        Matcher nameNotesMatcher = NAME_NOTE_SPATTERN.matcher(jsContent);
        StringBuffer nameNotesGroup = new StringBuffer();
        while (nameNotesMatcher.find()) {
            nameNotesGroup.append(nameNotesMatcher.group());
        }
        String[] chineseNames = null;
        String[] chineseNameMethodName = null;
        if (!ToolUtil.isEmpty((Object)nameNotesGroup)) {
            Matcher nameMatcher = NAME_PATTERN.matcher(nameNotesGroup.toString());
            StringBuilder chineseNameGroup = new StringBuilder();
            while (nameMatcher.find()) {
                chineseNameGroup.append(nameMatcher.group());
            }
            chineseNames = chineseNameGroup.toString().replaceAll("((\\*\\s@)|(\\*\\/))", "&&,&&,&&").replaceAll("@name", "").split("&&,&&,&&");
            Matcher chineseNameMatcher = CHINESE_NAME_PATTERN.matcher(nameNotesGroup.toString());
            StringBuilder chineseGroup = new StringBuilder();
            while (chineseNameMatcher.find()) {
                chineseGroup.append(chineseNameMatcher.group());
            }
            chineseNameMethodName = chineseGroup.toString().replaceAll("export", "").replaceAll("async", "").replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
        }
        Matcher returncounts = RETURN_COUNT.matcher(jsContent);
        StringBuilder counts = new StringBuilder();
        while (returncounts.find()) {
            counts.append(returncounts.group()).append("&&,&&,&&");
        }
        String[] allreturns = counts.toString().split("&&,&&,&&");
        HashMap<String, String> returnMaps = new HashMap<String, String>();
        for (String s : allreturns) {
            Matcher returnNoteMather = RETURN_NOTE_SPATTERN.matcher(s);
            StringBuilder returnNoteGroup = new StringBuilder();
            while (returnNoteMather.find()) {
                returnNoteGroup.append(returnNoteMather.group());
            }
            Matcher chineseNameMatcher = CHINESE_NAME_PATTERN.matcher(returnNoteGroup.toString());
            StringBuilder chineseGroup = new StringBuilder();
            while (chineseNameMatcher.find()) {
                chineseGroup.append(chineseNameMatcher.group());
            }
            String returnMethodName = chineseGroup.toString().replaceAll("export", "").replaceAll("async", "").replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").replaceAll("&&,&&,&&", "");
            returnMaps.put(returnMethodName, s);
        }
        Matcher returnNotesMather = RETURN_NOTE_SPATTERN.matcher(jsContent);
        StringBuilder returnNotesGroup = new StringBuilder();
        while (returnNotesMather.find()) {
            returnNotesGroup.append(returnNotesMather.group());
        }
        String[] returns = null;
        String[] returnMethodName = null;
        if (!ToolUtil.isEmpty((Object)returnNotesGroup)) {
            Matcher returnMatcher = RETURN_PATTERN.matcher(returnNotesGroup.toString());
            StringBuilder returnGroup = new StringBuilder();
            while (returnMatcher.find()) {
                returnGroup.append(returnMatcher.group());
            }
            returns = returnGroup.toString().replaceAll("\\*", "&&,&&,&&").replaceAll("@return(s)?", "").split("&&,&&,&&");
            Matcher functionReturnMatcher = CHINESE_NAME_PATTERN.matcher(returnNotesGroup.toString());
            StringBuilder functionReturnGroup = new StringBuilder();
            while (functionReturnMatcher.find()) {
                functionReturnGroup.append(functionReturnMatcher.group());
            }
            returnMethodName = functionReturnGroup.toString().replaceAll("export", "").replaceAll("async", "").replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
        }
        Matcher descriptionNotesMatcher = DESCRIPTION_NOTE_SPATTERN.matcher(jsContent);
        StringBuffer descriptionNotesGroup = new StringBuffer();
        while (descriptionNotesMatcher.find()) {
            descriptionNotesGroup.append(descriptionNotesMatcher.group());
        }
        String[] descriptions = null;
        String[] descriptionMethodName = null;
        if (!ToolUtil.isEmpty((Object)descriptionNotesGroup)) {
            Matcher descriptionMatcher = DESCRIPTION_PATTERN.matcher(descriptionNotesGroup.toString());
            StringBuilder descriptionGroup = new StringBuilder();
            while (descriptionMatcher.find()) {
                descriptionGroup.append(descriptionMatcher.group());
            }
            descriptions = descriptionGroup.toString().replaceAll("((\\*\\s@)|(\\*\\/))", "&&,&&,&&").replaceAll("@description", "").split("&&,&&,&&");
            Matcher functionDescriptionMatcher = CHINESE_NAME_PATTERN.matcher(descriptionNotesGroup.toString());
            StringBuilder functionDescriptionGroup = new StringBuilder();
            while (functionDescriptionMatcher.find()) {
                functionDescriptionGroup.append(functionDescriptionMatcher.group());
            }
            descriptionMethodName = functionDescriptionGroup.toString().replaceAll("export", "").replaceAll("async", "").replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
        }
        Matcher paramNotesMatcher = PARAM_NOTE_SPATTERN.matcher(jsContent);
        StringBuffer paramNotesGroup = new StringBuffer();
        while (paramNotesMatcher.find()) {
            paramNotesGroup.append(paramNotesMatcher.group());
        }
        Matcher paramMatcher = PARAM_PATTERN.matcher(paramNotesGroup.toString());
        StringBuilder paramGroup = new StringBuilder();
        while (paramMatcher.find()) {
            paramGroup.append(paramMatcher.group());
        }
        String[] paramDescription = paramGroup.toString().replaceAll("(\\*\\s@)", "&&,&&,&&").replaceAll("&&,&&,&&param", "&&,&&,&&").replaceAll("@param", "").replaceAll("\\*\\/", "&&;&&").split("&&;&&");
        Matcher paramFunctionNameMatcher = CHINESE_NAME_PATTERN.matcher(paramNotesGroup);
        StringBuilder containParamFunction = new StringBuilder();
        while (paramFunctionNameMatcher.find()) {
            containParamFunction.append(paramFunctionNameMatcher.group());
        }
        String[] paramMethodName = containParamFunction.toString().replaceAll("export", "").replaceAll("async", "").replaceAll("function", "").replaceAll("\\(", "&&,&&,&&").replaceAll(" ", "").split("&&,&&,&&");
        for (int i = 0; i < methodNameList.size(); ++i) {
            int j;
            int k;
            int j2;
            ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
            ArrayList<ScriptParam> paramList = new ArrayList<ScriptParam>();
            ScriptMethodConstruct scriptMethodConstructVO = new ScriptMethodConstruct();
            if (StringUtil.isNotBlank((CharSequence)((CharSequence)paramNameList.get(i)))) {
                String[] oneMethodParam;
                for (String s : oneMethodParam = ((String)paramNameList.get(i)).split(",")) {
                    ScriptParam extendJsParam = new ScriptParam();
                    extendJsParam.setName(s.trim());
                    extendJsParam.setParamType("0");
                    paramList.add(extendJsParam);
                }
            }
            for (j2 = 0; j2 < paramMethodName.length; ++j2) {
                String[] methodParamNotes;
                if (!paramMethodName[j2].equals(methodNameList.get(i))) continue;
                for (String methodParamNote : methodParamNotes = paramDescription[j2].split("&&,&&,&&")) {
                    String[] oneMethodParamNotes = methodParamNote.trim().replaceAll("\\s{1,}", " ").split(" ");
                    for (ScriptParam extendJsParam : paramList) {
                        if (!extendJsParam.getName().equals(oneMethodParamNotes[0]) || oneMethodParamNotes.length < 2) continue;
                        String content = oneMethodParamNotes[1];
                        for (k = 2; k < oneMethodParamNotes.length; ++k) {
                            content = content + " " + oneMethodParamNotes[k];
                        }
                        extendJsParam.setDescription(content);
                        result.put(oneMethodParamNotes[0], content);
                    }
                }
            }
            if (descriptionMethodName != null) {
                for (j2 = 0; j2 < descriptionMethodName.length; ++j2) {
                    if (!descriptionMethodName[j2].equals(methodNameList.get(i))) continue;
                    scriptMethodConstructVO.setAnnotation(descriptions[j2].trim());
                }
            }
            String[] notess = editorNote.split("\n");
            String startLine = "";
            String endLine = "";
            int right = 0;
            int left = 0;
            boolean isAsync = false;
            block25: for (j = 0; j < notess.length && (startLine.isEmpty() || endLine.isEmpty()); ++j) {
                String cname = "(export)(\\s*)((async)?)(\\s*)(function)(\\s*)" + methodNameList.get(i) + "(\\s*)";
                Pattern cnamePattern = Pattern.compile(cname);
                Matcher nameMatcher = cnamePattern.matcher(editorNote);
                if (!notess[j].contains(methodNameList.get(i)) || !notess[j].contains("export") || !notess[j].contains("function") || !nameMatcher.find()) continue;
                if (notess[j].contains("async")) {
                    isAsync = true;
                }
                startLine = String.valueOf(j + 1);
                for (k = j; k < notess.length; ++k) {
                    if ((left += JsScriptParser.countNum(notess[k], "{").intValue()) != (right += JsScriptParser.countNum(notess[k], "}").intValue()) || left == 0) continue;
                    endLine = String.valueOf(k + 1);
                    left = 0;
                    right = 0;
                    continue block25;
                }
            }
            scriptMethodConstructVO.setStartLine(startLine);
            scriptMethodConstructVO.setAsync(isAsync);
            scriptMethodConstructVO.setEndLine(endLine);
            if (returnMethodName != null) {
                for (j = 0; j < returnMethodName.length; ++j) {
                    String[] num;
                    if (!returnMethodName[j].equals(methodNameList.get(i)) || !ToolUtil.isNotEmpty(returnMaps.get(methodNameList.get(i))) || (num = ((String)returnMaps.get(methodNameList.get(i))).split("return")).length <= 2) continue;
                    ScriptParam returnValue = new ScriptParam();
                    String[] ss = returns[j].trim().split("}");
                    Object[] s = new String[ss.length];
                    Arrays.fill(s, "");
                    System.arraycopy(ss, 0, s, 0, ss.length);
                    if (((String)s[0]).contains("{")) {
                        if (s.length == 1) {
                            returnValue.setType(((String)s[0]).substring(((String)s[0]).indexOf("{") + 1).trim());
                            returnValue.setDescription("");
                        }
                        if (s.length == 2) {
                            returnValue.setType(((String)s[0]).substring(((String)s[0]).indexOf("{") + 1).trim());
                            returnValue.setDescription((String)s[1]);
                        }
                    } else {
                        returnValue.setType("");
                        returnValue.setDescription((String)s[0]);
                    }
                    returnValue.setParamType("1");
                    scriptMethodConstructVO.setReturnValue(returnValue);
                }
            }
            if (chineseNameMethodName != null) {
                for (j = 0; j < chineseNameMethodName.length; ++j) {
                    if (!chineseNameMethodName[j].equals(methodNameList.get(i))) continue;
                    scriptMethodConstructVO.setDescription(chineseNames[j].trim());
                }
            }
            scriptMethodConstructVO.setName(methodNameList.get(i));
            scriptMethodConstructVO.setParams(paramList);
            methodList.add(scriptMethodConstructVO);
        }
        scriptBase.setMethods(methodList);
        scriptBase.setEditorNote(editorNote);
        return scriptBase;
    }

    public static Integer countNum(String str, String target) {
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(target, index)) != -1) {
            index += target.length();
            ++count;
        }
        return count;
    }
}

