/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.property.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.formdesign.application.property.model.PageExp;
import com.jxdinfo.hussar.formdesign.application.property.service.IPageExpService;
import com.jxdinfo.hussar.formdesign.application.property.vo.PageExpGroupVo;
import com.jxdinfo.hussar.formdesign.application.property.vo.PageExpVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarNoCode/property/page"})
public class PageExpController {
    @Resource
    private IPageExpService pageExpService;

    @GetMapping(value={"/import"})
    @ApiOperation(value="\u65b0\u589e\u62d3\u5c55\u9875\u9762\uff0c\u5bfc\u5165\u9875\u9762")
    public ApiResponse<Void> importPage(@RequestParam(value="fileId") Long fileId, @RequestParam(value="groupId") Long groupId) {
        return this.pageExpService.importPage(fileId, groupId);
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u62d3\u5c55\u9875\u9762\uff0c\u6811\u5f62\u5c55\u793a")
    public ApiResponse<List<PageExpGroupVo>> getPages(@RequestParam(value="pageName") String pageName) {
        return this.pageExpService.getPages(pageName);
    }

    @GetMapping(value={"/pageList"})
    @ApiOperation(value="\u67e5\u8be2\u62d3\u5c55\u9875\u9762\uff0c\u5206\u9875\u5c55\u793a")
    public ApiResponse<Page<PageExpVo>> getPagesPage(@RequestParam(value="size") Long size, @RequestParam(value="current") Long current, @RequestParam(value="pageName") String pageName, @RequestParam(value="pageGroupId") Long pageGroupId) {
        PageInfo pageInfo = new PageInfo(current.longValue(), size.longValue());
        return this.pageExpService.getPagesPage(pageInfo, pageName, pageGroupId);
    }

    @GetMapping(value={"/allPages"})
    @ApiOperation(value="\u67e5\u8be2\u62d3\u5c55\u9875\u9762\uff0c\u67e5\u8be2\u5168\u90e8")
    public ApiResponse<List<PageExp>> getAllPages() {
        return ApiResponse.success((Object)this.pageExpService.list());
    }

    @GetMapping(value={"/allUsablePages"})
    @ApiOperation(value="\u67e5\u8be2\u62d3\u5c55\u9875\u9762\uff0c\u67e5\u8be2\u6240\u6709\u672a\u5220\u9664\u7684\u9875\u9762")
    public ApiResponse<List<PageExp>> getAllUsablePages() {
        return ApiResponse.success((Object)this.pageExpService.getAllUsablePages());
    }

    @PostMapping(value={"/getPagesByName"})
    @ApiOperation(value="\u67e5\u8be2\u62d3\u5c55\u9875\u9762\uff0c\u6839\u636e\u540d\u79f0\u96c6\u5408\u67e5\u8be2")
    public ApiResponse<List<PageExp>> getPagesByName(@RequestBody List<String> pageNames) {
        List pageExps = this.pageExpService.getPagesByName(pageNames);
        return ApiResponse.success((Object)pageExps);
    }

    @GetMapping(value={"/showImage"})
    @ApiOperation(value="\u62d3\u5c55\u9875\u9762\u56fe\u6807\u5c55\u793a")
    public void showImage(@RequestParam(value="pageName") String pageName, @RequestParam(value="fileName") String fileName, HttpServletResponse response) {
        this.pageExpService.showImage(pageName, fileName, response);
    }

    @PostMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u5220\u9664\u62d3\u5c55\u9875\u9762")
    public ApiResponse<Void> deletePage(@PathVariable(value="id") Long id) {
        this.pageExpService.deletePage(id);
        return ApiResponse.success();
    }

    @GetMapping(value={"/fileContent"})
    @ApiOperation(value="\u83b7\u53d6\u9875\u9762\u4e0b\u6587\u4ef6\u5185\u5bb9")
    public String getPageFileContent(@RequestParam(value="pageName") String pageName, @RequestParam(value="fileName") String fileName) throws IOException {
        return this.pageExpService.getPageFileContent(pageName, fileName);
    }
}

