/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.application.openapi.form.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.service.ISysFormService;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.model.ThirdUserRela;
import com.jxdinfo.hussar.formdesign.application.openapi.authority.v2.service.IThirdUserService;
import com.jxdinfo.hussar.formdesign.application.openapi.form.service.OpenFormService;
import com.jxdinfo.hussar.formdesign.application.openapi.form.vo.WidgetVo;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.extension.api.dto.TableUpdateDto;
import com.jxdinfo.hussar.formdesign.extension.api.service.IOpeApiService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.impl.FormOperateExposedImpl;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.unifiedtodo.dto.QueryToDoDto;
import com.jxdinfo.hussar.unifiedtodo.dto.SaveToDoDto;
import com.jxdinfo.hussar.unifiedtodo.service.IUnifiedToDoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.external.openapi.form.service.impl.OpenFormServiceImpl")
public class OpenFormServiceImpl
implements OpenFormService {
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private IThirdUserService thirdUserService;
    @Resource
    private FormOperateExposedImpl formOperateExposedService;
    @Resource
    private ISysFormService sysFormService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private IUnifiedToDoService unifiedToDoService;
    @Resource
    private IOpeApiService iOpeApiService;
    private static final Long EXTERNAL_USER_ID = 8934723032766293738L;
    private static final String USER_NAME = "\u5916\u90e8\u7528\u6237";
    private static final String LOGIN_USER_ID = "CURRENT_USER_ID";
    private static final String LOGIN_USER_NAME = "CURRENT_USER_NAME";
    private static final String IMPORT_KEY = "importList";
    private static final String TODO = "0";
    private static final String DONE = "1";
    private static final String URGE = "2";
    private static final String SEND = "3";
    private static final String CREATE = "4";
    private static final String USER_TYPE_FOCUS = "0";
    private static final String USER_TYPE_EXEC = "1";
    private static final String USER_TYPE_URGE = "2";
    private static final String USER_TYPE_CREATE = "3";

    @Override
    public ResponseEntity<ApiResponse<Object>> formQuery(String formId, String id, String appId, String tabType) {
        return this.formOperateExposedService.formQuery(formId, id, tabType, appId, Boolean.TRUE.booleanValue());
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> tableQuery(String formId, Map<String, Object> params, String appId, String viewId) {
        return ResponseEntity.ok((Object)this.iOpeApiService.tableQuery(formId, params, appId, viewId));
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> create(String thirdUserId, String formId, Map<String, Object> params, String appId) {
        Long currentUserId = HussarUtils.isEmpty((Object)params.get(LOGIN_USER_ID)) ? null : Long.valueOf((String)params.get(LOGIN_USER_ID));
        String currentUserName = HussarUtils.isEmpty((Object)params.get(LOGIN_USER_NAME)) ? null : (String)params.get(LOGIN_USER_NAME);
        this.setExternalUserDetails(thirdUserId, currentUserId, currentUserName);
        return ResponseEntity.ok((Object)this.iOpeApiService.create(formId, params, appId));
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> flowFormSubmit(String thirdUserId, String formId, Map<String, Object> params) {
        Long currentUserId = HussarUtils.isEmpty((Object)params.get(LOGIN_USER_ID)) ? null : Long.valueOf((String)params.get(LOGIN_USER_ID));
        String currentUserName = HussarUtils.isEmpty((Object)params.get(LOGIN_USER_NAME)) ? null : (String)params.get(LOGIN_USER_NAME);
        this.setExternalUserDetails(thirdUserId, currentUserId, currentUserName);
        return ResponseEntity.ok((Object)this.iOpeApiService.flowFormSubmit(formId, params));
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> createBatch(String thirdUserId, String formId, Map<String, Object> params, String appId) {
        Long currentUserId = HussarUtils.isEmpty((Object)params.get(LOGIN_USER_ID)) ? null : Long.valueOf((String)params.get(LOGIN_USER_ID));
        String currentUserName = HussarUtils.isEmpty((Object)params.get(LOGIN_USER_NAME)) ? null : (String)params.get(LOGIN_USER_NAME);
        this.setExternalUserDetails(thirdUserId, currentUserId, currentUserName);
        return ResponseEntity.ok((Object)this.iOpeApiService.createBatch(appId, formId, params));
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> update(String thirdUserId, String formId, Map<String, Object> params, String appId) {
        Long currentUserId = HussarUtils.isEmpty((Object)params.get(LOGIN_USER_ID)) ? null : Long.valueOf((String)params.get(LOGIN_USER_ID));
        String currentUserName = HussarUtils.isEmpty((Object)params.get(LOGIN_USER_NAME)) ? null : (String)params.get(LOGIN_USER_NAME);
        this.setExternalUserDetails(thirdUserId, currentUserId, currentUserName);
        return ResponseEntity.ok((Object)this.iOpeApiService.update(formId, params, appId));
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> updateBatch(String thirdUserId, String appId, String formId, TableUpdateDto tableUpdateDto) {
        Long currentUserId = HussarUtils.isEmpty(tableUpdateDto.getFields().get(LOGIN_USER_ID)) ? null : Long.valueOf((String)tableUpdateDto.getFields().get(LOGIN_USER_ID));
        String currentUserName = HussarUtils.isEmpty(tableUpdateDto.getFields().get(LOGIN_USER_NAME)) ? null : (String)tableUpdateDto.getFields().get(LOGIN_USER_NAME);
        this.setExternalUserDetails(thirdUserId, currentUserId, currentUserName);
        return ResponseEntity.ok((Object)this.iOpeApiService.updateBatch(appId, formId, tableUpdateDto));
    }

    @Override
    public ResponseEntity<ApiResponse<Object>> deleteBatch(String formId, String ids, String appId) {
        return ResponseEntity.ok((Object)this.iOpeApiService.deleteBatch(formId, ids, appId));
    }

    @Override
    public ResponseEntity<ApiResponse<List<WidgetVo>>> getFields(String formId) {
        SysForm targetForm = (SysForm)this.sysFormService.getDetailById(Long.valueOf(formId)).getData();
        AssertUtil.isNotNull((Object)targetForm, (String)"\u76ee\u6807\u8868\u5355\u4e0d\u5b58\u5728");
        FormCanvasSchema canvasSchema = Optional.ofNullable(this.canvasSchemaService.get(formId)).map(FormDesignResponse::getData).orElseThrow(() -> new BaseException("\u8868\u5355\u753b\u5e03\u83b7\u53d6\u5931\u8d25"));
        List widgets = canvasSchema.getWidgets();
        ArrayList<WidgetVo> widgetVos = new ArrayList<WidgetVo>();
        this.widgetFilter(widgetVos, widgets);
        return ResponseEntity.ok((Object)ApiResponse.success(widgetVos, (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    @Override
    public ApiResponse<Page<SaveToDoDto>> getTodoTaskList(String thirdUserId, Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        String userId = this.mapping2FlatUserId(thirdUserId);
        queryToDoDto.setExecuteStatus("0");
        queryToDoDto.setUserType("1");
        queryToDoDto.setUserId(userId);
        ApiResponse response = this.unifiedToDoService.getListTask(page, queryToDoDto);
        this.recordFilter((Page<SaveToDoDto>)((Page)response.getData()), "0");
        return response;
    }

    @Override
    public ApiResponse<Page<SaveToDoDto>> getDoneTaskList(String thirdUserId, Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        String userId = this.mapping2FlatUserId(thirdUserId);
        queryToDoDto.setExecuteStatus("1");
        queryToDoDto.setUserType("1");
        queryToDoDto.setUserId(userId);
        ApiResponse response = this.unifiedToDoService.getListTask(page, queryToDoDto);
        this.recordFilter((Page<SaveToDoDto>)((Page)response.getData()), "1");
        return response;
    }

    @Override
    public ApiResponse<Page<SaveToDoDto>> getUrgeTaskList(String thirdUserId, Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        String userId = this.mapping2FlatUserId(thirdUserId);
        queryToDoDto.setExecuteStatus("0");
        queryToDoDto.setUserType("2");
        queryToDoDto.setUserId(userId);
        ApiResponse response = this.unifiedToDoService.getListTask(page, queryToDoDto);
        this.recordFilter((Page<SaveToDoDto>)((Page)response.getData()), "2");
        return response;
    }

    @Override
    public ApiResponse<Page<SaveToDoDto>> getSendTaskList(String thirdUserId, Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        String userId = this.mapping2FlatUserId(thirdUserId);
        queryToDoDto.setUserType("0");
        queryToDoDto.setUserId(userId);
        ApiResponse response = this.unifiedToDoService.getListTask(page, queryToDoDto);
        this.recordFilter((Page<SaveToDoDto>)((Page)response.getData()), "3");
        return response;
    }

    @Override
    public ApiResponse<Page<SaveToDoDto>> getCreateTaskList(String thirdUserId, Page<SaveToDoDto> page, QueryToDoDto queryToDoDto) {
        String userId = this.mapping2FlatUserId(thirdUserId);
        queryToDoDto.setUserType("3");
        queryToDoDto.setCreateUserId(userId);
        ApiResponse response = this.unifiedToDoService.getListTask(page, queryToDoDto);
        this.recordFilter((Page<SaveToDoDto>)((Page)response.getData()), CREATE);
        return response;
    }

    private String mapping2FlatUserId(String thirdUserId) {
        if (HussarUtils.isNotEmpty((Object)thirdUserId)) {
            ThirdUserRela thirdUserRela = (ThirdUserRela)((Object)this.thirdUserService.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdUserRela::getThirdUserId, (Object)thirdUserId)));
            return String.valueOf(thirdUserRela.getUserId());
        }
        return null;
    }

    private String mapping2ThirdUserId(String userId) {
        if (HussarUtils.isNotEmpty((Object)userId)) {
            ThirdUserRela thirdUserRela = (ThirdUserRela)((Object)this.thirdUserService.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdUserRela::getUserId, (Object)userId)));
            return HussarUtils.isNull((Object)((Object)thirdUserRela)) ? null : String.valueOf(thirdUserRela.getThirdUserId());
        }
        return null;
    }

    private void recordFilter(Page<SaveToDoDto> records, String taskType) {
        if (HussarUtils.isNotEmpty(records)) {
            records.getRecords().forEach(record -> {
                record.setCreateUserId(this.mapping2ThirdUserId(record.getCreateUserId()));
                record.setSendUserId(this.mapping2ThirdUserId(record.getSendUserId()));
                record.setUrgeUserId(this.mapping2ThirdUserId(record.getUrgeUserId()));
                record.setMandator(this.mapping2ThirdUserId(record.getMandator()));
                this.addLinkUrl((SaveToDoDto)record, taskType);
            });
        }
    }

    private void addLinkUrl(SaveToDoDto record, String taskType) {
        String pcUrl = "";
        String mobileUrl = "";
        switch (taskType) {
            case "0": {
                pcUrl = "/hussarAppFrame/?appId=" + this.appendParam(record.getAppId()) + "#/form-detail/" + record.getFormId() + "?rowId=" + this.appendParam(record.getBusinessid()) + "&processInstId=" + this.appendParam(record.getProcessInstanceid()) + "&tabType=2";
                mobileUrl = "/hussarApp/#/container/form?id=" + this.appendParam(record.getBusinessid()) + "&appId=" + this.appendParam(record.getAppId()) + "&formId=" + this.appendParam(record.getFormId()) + "&formType=1&tabType=" + "2" + "&taskId=" + this.appendParam(record.getTaskId());
                break;
            }
            case "1": {
                pcUrl = "/hussarAppFrame/?appId=" + this.appendParam(record.getAppId()) + "#/form-detail/" + record.getFormId() + "?rowId=" + this.appendParam(record.getBusinessid()) + "&processInstId=" + this.appendParam(record.getProcessInstanceid()) + "&taskId=" + this.appendParam(record.getTaskId()) + "&tabType=1";
                mobileUrl = "/hussarApp/#/container/form?id=" + this.appendParam(record.getBusinessid()) + "&appId=" + this.appendParam(record.getAppId()) + "&formId=" + this.appendParam(record.getFormId()) + "&formType=1&tabType=" + "1" + "&taskId=" + this.appendParam(record.getTaskId());
                break;
            }
            case "2": {
                pcUrl = "/hussarAppFrame/?appId=" + this.appendParam(record.getAppId()) + "#/form-detail/" + record.getFormId() + "?rowId=" + this.appendParam(record.getBusinessid()) + "&processInstId=" + this.appendParam(record.getProcessInstanceid()) + "&taskId=" + this.appendParam(record.getTaskId()) + "&tabType=2";
                mobileUrl = "/hussarApp/#/container/form?id=" + this.appendParam(record.getBusinessid()) + "&appId=" + this.appendParam(record.getAppId()) + "&formId=" + this.appendParam(record.getFormId()) + "&formType=1&tabType=" + "2" + "&taskId=" + this.appendParam(record.getTaskId());
                break;
            }
            case "3": {
                pcUrl = "/hussarAppFrame/?appId=" + this.appendParam(record.getAppId()) + "#/form-detail/" + record.getFormId() + "?rowId=" + this.appendParam(record.getBusinessid()) + "&processInstId=" + this.appendParam(record.getProcessInstanceid()) + "&taskId=" + this.appendParam(record.getTaskId()) + "&tabType=0";
                mobileUrl = "/hussarApp/#/container/form?id=" + this.appendParam(record.getBusinessid()) + "&appId=" + this.appendParam(record.getAppId()) + "&formId=" + this.appendParam(record.getFormId()) + "&formType=1&tabType=" + "0" + "&taskId=" + this.appendParam(record.getTaskId());
                break;
            }
            case "4": {
                pcUrl = "/hussarAppFrame/?appId=" + this.appendParam(record.getAppId()) + "#/form-detail/" + record.getFormId() + "?rowId=" + this.appendParam(record.getBusinessid()) + "&processInstId=" + this.appendParam(record.getProcessInstanceid()) + "&tabType=0";
                mobileUrl = "/hussarApp/#/container/form?id=" + this.appendParam(record.getBusinessid()) + "&appId=" + this.appendParam(record.getAppId()) + "&formId=" + this.appendParam(record.getFormId()) + "&formType=1&tabType=" + "0" + "&taskId=" + this.appendParam(record.getTaskId());
            }
        }
        record.setWebLinkurl(pcUrl);
        record.setMobileLinkurl(mobileUrl);
    }

    private String appendParam(Object param) {
        return HussarUtils.isNull((Object)param) ? "" : param.toString();
    }

    public void widgetFilter(List<WidgetVo> target, List<Widget> source) {
        if (HussarUtils.isEmpty(source)) {
            return;
        }
        source.forEach(widget -> {
            WidgetVo widgetVo = new WidgetVo.Builder().name(widget.getName()).title(widget.getTitle()).type(widget.getType()).dbType(widget.getDbType()).dataType(widget.getDataType()).build();
            target.add(widgetVo);
            if (HussarUtils.isNotEmpty((Object)widget.getChildren())) {
                widgetVo.setChildren(new ArrayList<WidgetVo>());
                this.widgetFilter(widgetVo.getChildren(), widget.getChildren());
            }
        });
    }

    public String getIdValue(String formId, Map<String, Object> entity) {
        ApiResponse sysFormApiResponse = this.sysFormService.getDetailById(Long.valueOf(formId));
        String tableName = Optional.ofNullable(sysFormApiResponse).map(ApiResponse::getData).map(SysForm::getTableName).orElseThrow(() -> new BaseException("\u8868\u5355\u540d\u67e5\u8be2\u5931\u8d25"));
        return String.valueOf(entity.get(tableName));
    }

    public void setExternalUserDetails(String thirdUserId, Long currentUserId, String currentUserName) {
        UserDetails userDetails = new UserDetails();
        SecurityUser loginUser = new SecurityUser();
        if (!HussarUtils.isNull((Object)thirdUserId)) {
            ThirdUserRela thirdUserRela = (ThirdUserRela)((Object)this.thirdUserService.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdUserRela::getThirdUserId, (Object)thirdUserId)));
            AssertUtil.isNotNull((Object)((Object)thirdUserRela), (String)"\u5916\u90e8\u7528\u6237\u4e0d\u5b58\u5728");
            userDetails.setUserId(thirdUserRela.getUserId());
            loginUser.setUserId(thirdUserRela.getUserId());
            userDetails.setUserName(USER_NAME);
        } else if (HussarUtils.isNotEmpty((Object)currentUserId)) {
            userDetails.setUserId(currentUserId);
            loginUser.setUserId(currentUserId);
            userDetails.setUserName(currentUserName);
        } else {
            userDetails.setUserId(EXTERNAL_USER_ID);
            loginUser.setUserId(EXTERNAL_USER_ID);
            userDetails.setUserName(USER_NAME);
        }
        EngineUserUtil.setUser((UserDetails)userDetails);
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)loginUser);
    }
}

